/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.tiles.nodes;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.logistics.api.filters.ITransferFilteredTile;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.tiles.INetworkTile;
import sonar.logistics.api.tiles.IPriority;
import sonar.logistics.api.tiles.nodes.NodeConnectionType;
import sonar.logistics.api.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.tiles.nodes.TransferType;

public abstract class NodeConnection<T extends IInfo> {
    public INetworkTile source;
    public boolean isFiltered;
    public int priority;

    public NodeConnection(INetworkTile source) {
        this.source = source;
        this.isFiltered = source instanceof ITransferFilteredTile;
        this.priority = source instanceof IPriority ? ((IPriority)((Object)source)).getPriority() : 0;
    }

    public abstract T getChannel();

    public abstract NodeConnectionType getType();

    public boolean canTransferFluid(NodeConnection connection, StoredFluidStack stack, NodeTransferMode mode) {
        ITransferFilteredTile node;
        return !this.isFiltered || (node = (ITransferFilteredTile)this.source).getChannels().isMonitored(connection) || node.getTransferMode().matches(mode) && node.getFilters().matches(stack, mode);
    }

    public boolean canTransferItem(NodeConnection connection, StoredItemStack stack, NodeTransferMode mode) {
        ITransferFilteredTile node;
        return !this.isFiltered || (node = (ITransferFilteredTile)this.source).getChannels().isMonitored(connection) || node.getTransferMode().matches(mode) && node.getFilters().matches(stack, mode);
    }

    public boolean canTransferEnergy(NodeConnection connection, StoredEnergyStack stack, NodeTransferMode mode) {
        ITransferFilteredTile node;
        return !this.isFiltered || (node = (ITransferFilteredTile)this.source).getChannels().isMonitored(connection) || node.isTransferEnabled(TransferType.ENERGY);
    }

    public static List<NodeConnection> sortConnections(List<NodeConnection> connections) {
        Collections.sort(connections, new Comparator<NodeConnection>(){

            @Override
            public int compare(NodeConnection str1, NodeConnection str2) {
                return Integer.compare(str2.priority, str1.priority);
            }
        });
        return connections;
    }
}

