/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.tiles.readers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mcmultipart.multipart.IMultipart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.wireless.ClientDataEmitter;
import sonar.logistics.helpers.CableHelper;

public class ClientLocalProvider
implements INBTSyncable {
    public List<ISyncPart> syncParts = new ArrayList<ISyncPart>();
    public SyncTagType.INT identity = new SyncTagType.INT(0);
    public SyncCoords coords = new SyncCoords(1);

    public ClientLocalProvider() {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords}));
    }

    public ClientLocalProvider(ILogicListenable monitor) {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords}));
        this.identity.setObject((Object)monitor.getIdentity());
        this.coords.setCoords(monitor.getCoords());
    }

    public ClientLocalProvider(int uuid, BlockCoords coords) {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords}));
        this.identity.setObject((Object)uuid);
        this.coords.setCoords(coords);
    }

    public ClientLocalProvider copy() {
        return new ClientLocalProvider((Integer)this.identity.getObject(), this.coords.getCoords());
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.readSyncParts((NBTTagCompound)nbt, (NBTHelper.SyncType)type, this.syncParts);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.writeSyncParts((NBTTagCompound)nbt, (NBTHelper.SyncType)type, this.syncParts, (boolean)type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE}));
        return nbt;
    }

    public ILogicListenable getViewable() {
        IMultipart part;
        ILogicListenable viewable = CableHelper.getMonitorFromIdentity(((Integer)this.identity.getObject()).hashCode(), true);
        if (viewable != null && (part = SonarMultipartHelper.getPartFromHash((int)((Integer)this.identity.getObject()).hashCode(), (World)this.coords.getCoords().getWorld(), (BlockPos)this.coords.getCoords().getBlockPos())) != null && part instanceof ILogicListenable) {
            ILogicListenable partViewer = (ILogicListenable)part;
            viewable = (ILogicListenable)part;
        }
        return viewable;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ClientDataEmitter) {
            return this.hashCode() == obj.hashCode() && this.coords.getCoords().equals((Object)((ClientDataEmitter)obj).coords.getCoords());
        }
        return false;
    }

    public int hashCode() {
        return (Integer)this.identity.getObject();
    }
}

