/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.tiles.signaller;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import sonar.core.network.sync.BaseSyncListPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUnidentifiedObject;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.api.tiles.signaller.ILogisticsStatement;
import sonar.logistics.api.tiles.signaller.InputTypes;
import sonar.logistics.api.tiles.signaller.LogicOperator;
import sonar.logistics.api.tiles.signaller.LogicState;
import sonar.logistics.logic.comparators.ILogicComparator;

public class EmitterStatement<T>
extends BaseSyncListPart
implements ILogisticsStatement {
    public ILogicComparator<T> comparator;
    public SyncTagType.INT hashCode = new SyncTagType.INT(-1);
    public SyncTagType.INT comparatorID = new SyncTagType.INT(0);
    public SyncEnum<LogicOperator> operator = new SyncEnum((Enum[])LogicOperator.values(), 1);
    public SyncEnum<InputTypes> useInfo = new SyncEnum((Enum[])InputTypes.values(), 2);
    public SyncNBTAbstract<InfoUUID> uuid1 = new SyncNBTAbstract(InfoUUID.class, 3);
    public SyncNBTAbstract<InfoUUID> uuid2 = new SyncNBTAbstract(InfoUUID.class, 4);
    public SyncTagType.STRING key1 = new SyncTagType.STRING(5);
    public SyncTagType.STRING key2 = new SyncTagType.STRING(6);
    public SyncUnidentifiedObject obj = new SyncUnidentifiedObject(7);
    public SyncTagType.BOOLEAN wasTrue = new SyncTagType.BOOLEAN(9);

    public EmitterStatement() {
        this.syncList.addParts(new IDirtyPart[]{this.hashCode, this.comparatorID, this.operator, this.useInfo, this.uuid1, this.uuid2, this.key1, this.key2, this.obj, this.wasTrue});
        this.hashCode.setObject((Object)UUID.randomUUID().hashCode());
    }

    public EmitterStatement(ILogicComparator<T> comparator) {
        this.syncList.addParts(new IDirtyPart[]{this.hashCode, this.comparatorID, this.operator, this.useInfo, this.uuid1, this.uuid2, this.key1, this.key2, this.obj, this.wasTrue});
        this.comparator = comparator;
        this.comparatorID.setObject((Object)PL2.getComparatorRegistry().getObjectID(comparator.getName()));
        this.operator.setObject((Enum)comparator.getValidOperators().get(0));
        this.hashCode.setObject((Object)UUID.randomUUID().hashCode());
    }

    public void addRequiredUUIDs(List<InfoUUID> uuids) {
        if (this.uuid1.getObject() != null && !uuids.contains(this.uuid1.getObject())) {
            uuids.add((InfoUUID)this.uuid1.getObject());
        }
        if (((InputTypes)this.useInfo.getObject()).usesInfo() && this.uuid2.getObject() != null && !uuids.contains(this.uuid2.getObject())) {
            uuids.add((InfoUUID)this.uuid2.getObject());
        }
    }

    public ILogicComparator<T> getComparator() {
        if (this.comparator == null) {
            this.comparator = (ILogicComparator)PL2.getComparatorRegistry().getRegisteredObject((Integer)this.comparatorID.getObject());
        }
        return this.comparator;
    }

    public Object getObject(Map<InfoUUID, IInfo> info, int pos) {
        if (pos == 0) {
            return this.getObject(info, (InfoUUID)this.uuid1.getObject(), (String)this.key1.getObject());
        }
        if (((InputTypes)this.useInfo.getObject()).usesInfo()) {
            return this.getObject(info, (InfoUUID)this.uuid2.getObject(), (String)this.key2.getObject());
        }
        if (this.obj.get() != null && this.getComparator().isValidObject(this.obj.get())) {
            return this.obj.get();
        }
        return null;
    }

    public Object getObject(Map<InfoUUID, IInfo> info, InfoUUID id, String key) {
        IInfo info1;
        if (id != null && key != null && (info1 = info.get(id)) != null && info1 instanceof IComparableInfo) {
            IComparableInfo provider1 = (IComparableInfo)info1;
            ComparableObject obj = ComparableObject.getComparableObject(provider1.getComparableObjects(Lists.newArrayList()), key);
            if (this.getComparator().isValidObject(obj.object)) {
                return obj.object;
            }
        }
        return null;
    }

    @Override
    public LogicState isMatching(Map<InfoUUID, IInfo> info) {
        Object num1 = this.getObject(info, 0);
        Object num2 = this.getObject(info, 1);
        if (num1 != null && num2 != null) {
            return this.getComparator().getLogicState((LogicOperator)this.operator.getObject(), num1, num2);
        }
        return LogicState.FALSE;
    }

    @Override
    public LogicOperator getOperator() {
        return (LogicOperator)this.operator.getObject();
    }

    @Override
    public List<LogicOperator> validOperators() {
        return this.getComparator().getValidOperators();
    }

    public int hashCode() {
        return (Integer)this.hashCode.getObject();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof EmitterStatement) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    public InputTypes getInputType() {
        return (InputTypes)this.useInfo.getObject();
    }

    public void incrementInputType() {
        this.useInfo.incrementEnum();
    }

    public void incrementOperator() {
        int ordinal;
        LogicOperator current = (LogicOperator)this.operator.getObject();
        List<LogicOperator> valid = this.validOperators();
        int pos = -1;
        int currentPos = 0;
        for (LogicOperator op : this.validOperators()) {
            if (op == current) {
                pos = currentPos;
                break;
            }
            ++currentPos;
        }
        if (pos == -1) {
            this.operator.setObject((Enum)valid.get(0));
        }
        if ((ordinal = pos + 1) < valid.size()) {
            this.operator.setObject((Enum)valid.get(ordinal));
        } else {
            this.operator.setObject((Enum)valid.get(0));
        }
    }
}

