/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import sonar.core.api.StorageSize;
import sonar.core.utils.Pair;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.IJoinableInfo;

public class MonitoredList<T extends IInfo>
extends ArrayList<T> {
    public List<T> changed = new ArrayList<T>();
    public List<T> removed = new ArrayList<T>();
    public StorageSize sizing;
    public boolean hasChanged = true;
    public int networkID;

    public MonitoredList(int networkID) {
        this.networkID = networkID;
    }

    public MonitoredList(int networkID, List<T> items, StorageSize sizing, List<T> changed, List<T> removed) {
        super(items);
        this.networkID = networkID;
        this.sizing = sizing;
        this.changed = changed;
        this.removed = removed;
    }

    public static <I extends IInfo> MonitoredList<I> newMonitoredList(int networkID) {
        return new MonitoredList(networkID, Lists.newArrayList(), new StorageSize(0L, 0L), Lists.newArrayList(), Lists.newArrayList());
    }

    public List<T> cloneInfo() {
        return (List)super.clone();
    }

    public MonitoredList<T> setInfo(List<T> list) {
        this.clear();
        this.addAll(list);
        return this;
    }

    public MonitoredList<T> copyInfo() {
        return new MonitoredList<T>(this.networkID, this.cloneInfo(), new StorageSize(this.sizing.getStored(), this.sizing.getMaxStored()), Lists.newArrayList(this.changed), Lists.newArrayList(this.removed));
    }

    public T findInfoInList(T newInfo, MonitoredList<T> previousList) {
        for (IInfo lastInfo : previousList) {
            if (!lastInfo.isIdenticalInfo(newInfo)) continue;
            return (T)lastInfo;
        }
        return null;
    }

    public void addInfoToList(T newInfo, MonitoredList<T> previousList) {
        if (newInfo instanceof IJoinableInfo) {
            for (int i = 0; i < this.size(); ++i) {
                IInfo storedInfo = (IInfo)this.get(i);
                if (!((IJoinableInfo)storedInfo).canJoinInfo(newInfo)) continue;
                this.set(i, ((IJoinableInfo)storedInfo).joinInfo(newInfo));
                return;
            }
        }
        this.add(newInfo);
    }

    public MonitoredList<T> updateList(MonitoredList<?> monitoredList) {
        List changed = this.cloneInfo();
        List<?> removed = monitoredList.cloneInfo();
        monitoredList.cloneInfo().forEach((? super T last) -> this.forEach((? super E current) -> {
            if (last.isMatchingType((IInfo)current)) {
                if (last.isMatchingInfo(current)) {
                    removed.remove(last);
                }
                if (last.isIdenticalInfo(current)) {
                    changed.remove(current);
                }
            }
        }));
        this.changed = changed;
        this.removed = removed;
        this.hasChanged = !changed.isEmpty() || !removed.isEmpty();
        return this;
    }

    public void markDirty() {
        this.hasChanged = true;
    }

    public Pair<Boolean, IInfo> getLatestInfo(IInfo oldInfo) {
        for (IInfo newInfo : this) {
            if (!newInfo.isMatchingType(oldInfo) || !newInfo.isMatchingInfo(oldInfo)) continue;
            return new Pair((Object)(!newInfo.isIdenticalInfo(oldInfo) ? 1 : 0), (Object)newInfo);
        }
        return new Pair((Object)false, (Object)oldInfo);
    }
}

