/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.wireless;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.wireless.IDataEmitter;

public class ClientDataEmitter
implements INBTSyncable {
    public List<ISyncPart> syncParts = new ArrayList<ISyncPart>();
    public SyncTagType.INT identity = new SyncTagType.INT(0);
    public SyncCoords coords = new SyncCoords(1);
    public SyncTagType.STRING name = new SyncTagType.STRING(2);

    public ClientDataEmitter() {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords, this.name}));
    }

    public ClientDataEmitter(IDataEmitter emitter) {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords, this.name}));
        this.identity.setObject((Object)emitter.getIdentity());
        this.coords.setCoords(emitter.getCoords());
        this.name.setObject((Object)emitter.getEmitterName());
    }

    public ClientDataEmitter(int uuid, BlockCoords coords, String name) {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords, this.name}));
        this.identity.setObject((Object)uuid);
        this.coords.setCoords(coords);
        this.name.setObject((Object)name);
    }

    public int getIdentity() {
        return (Integer)this.identity.getObject();
    }

    public ClientDataEmitter copy() {
        return new ClientDataEmitter((Integer)this.identity.getObject(), this.coords.getCoords(), (String)this.name.getObject());
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.readSyncParts((NBTTagCompound)nbt, (NBTHelper.SyncType)type, this.syncParts);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.writeSyncParts((NBTTagCompound)nbt, (NBTHelper.SyncType)type, this.syncParts, (boolean)type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE}));
        return nbt;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ClientDataEmitter) {
            return this.hashCode() == obj.hashCode() && this.coords.getCoords().equals((Object)((ClientDataEmitter)obj).coords.getCoords());
        }
        return false;
    }

    public int hashCode() {
        return (Integer)this.identity.getObject();
    }
}

