/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.client.BlockModelsCache;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.info.types.LogicInfoList;
import sonar.logistics.info.types.MonitoredItemStack;

public class CachedInventoryRenderer {
    public List<CachedItemRenderer> renders = Lists.newArrayList();

    public void update(LogicInfoList info, MonitoredList<MonitoredItemStack> list) {
        this.renders = this.create(info, list);
    }

    public List<CachedItemRenderer> create(LogicInfoList info, MonitoredList<MonitoredItemStack> list) {
        ArrayList<CachedItemRenderer> renders = new ArrayList<CachedItemRenderer>();
        int currentX = 0;
        int currentY = 0;
        int pageCount = info.pageCount;
        for (int i = info.perPage * pageCount; i < Math.min(info.perPage + info.perPage * pageCount, list.size()); ++i) {
            MonitoredItemStack m = (MonitoredItemStack)list.get(i);
            StoredItemStack s = m.getStoredStack();
            int current = i - info.perPage * pageCount;
            int xLevel = (int)((double)current - Math.floor(current / info.xSlots) * (double)info.xSlots);
            int yLevel = (int)Math.floor(current / info.xSlots);
            int x = xLevel - currentX;
            int y = yLevel - currentY;
            currentX = xLevel;
            currentY = yLevel;
            renders.add(new CachedItemRenderer(s.item, BlockModelsCache.INSTANCE.getOrLoadModel(s.item), "" + s.getStackSize(), x, y));
        }
        return renders;
    }

    public void updateSizing(LogicInfoList info) {
        int currentX = 0;
        int currentY = 0;
        for (int i = info.perPage * info.pageCount; i < Math.min(info.perPage + info.perPage * info.pageCount, this.renders.size()); ++i) {
            CachedItemRenderer m = this.renders.get(i);
            int current = i - info.perPage * info.pageCount;
            int xLevel = (int)((double)current - Math.floor(current / info.xSlots) * (double)info.xSlots);
            int yLevel = (int)Math.floor(current / info.xSlots);
            int x = xLevel - currentX;
            int y = yLevel - currentY;
            currentX = xLevel;
            currentY = yLevel;
            m.x = x;
            m.y = y;
        }
    }

    public void render() {
        GlStateManager.func_179094_E();
        RenderHelper.saveBlendState();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-0.91875, (double)-0.6875, (double)0.0);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)-0.022, (double)0.022, (double)0.01);
        RenderHelper.textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        for (CachedItemRenderer render : this.renders) {
            GL11.glTranslated((double)render.x, (double)render.y, (double)0.0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)0.04);
            GlStateManager.func_179140_f();
            this.renderItemModelIntoGUI(render.stack, 0, 0, render.model);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        RenderHelper.textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179094_E();
        float scaleFactor = 0.5f;
        float inverseScaleFactor = 2.0f;
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        for (CachedItemRenderer render : this.renders) {
            GlStateManager.func_179137_b((double)(render.x * 2.0), (double)(render.y * 2.0), (double)0.0);
            int X = (int)((15.0f - (float)RenderHelper.fontRenderer.func_78256_a(render.stored) * 0.5f) * 2.0f);
            int Y = 23;
            RenderHelper.fontRenderer.func_175063_a(render.stored, (float)X, 23.0f, 0xFFFFFF);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        RenderHelper.restoreBlendState();
        GlStateManager.func_179121_F();
    }

    public void renderItemModelIntoGUI(ItemStack stack, int x, int y, IBakedModel bakedmodel) {
        RenderHelper.textureManager.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.setupGuiTransform((int)x, (int)y, (boolean)bakedmodel.func_177556_c());
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        RenderHelper.itemRender.func_180454_a(stack, bakedmodel);
    }

    public static class CachedItemRenderer {
        public double x;
        public double y;
        public String stored;
        public ItemStack stack;
        public IBakedModel model;

        public CachedItemRenderer(ItemStack stack, IBakedModel model, String stored, int x, int y) {
            this.stack = stack;
            this.model = model;
            this.stored = stored;
            this.x = (double)x * 22.7;
            this.y = (double)y * 22.7;
        }
    }
}

