/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import org.lwjgl.input.Keyboard;

public class DisplayTextFields
extends Gui {
    public GuiTextField[] fields;
    public int x;
    public int y;
    public int size;
    public int width = 160;
    public int height = 12;

    public DisplayTextFields(int x, int y, int size) {
        this.x = x;
        this.y = y;
        this.size = size;
    }

    public void initFields(List<String> textList) {
        Keyboard.enableRepeatEvents((boolean)true);
        this.fields = new GuiTextField[this.size];
        FontRenderer render = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < this.fields.length; ++i) {
            GuiTextField field = new GuiTextField(i, render, this.x, this.y + i * this.height, this.width, this.height);
            field.func_146203_f(64);
            field.func_146180_a(textList.size() > i ? textList.get(i) : "");
            field.func_146185_a(false);
            this.fields[i] = field;
        }
    }

    public GuiTextField getSelectedField() {
        for (int i = 0; i < this.fields.length; ++i) {
            GuiTextField field = this.fields[i];
            if (!field.func_146206_l()) continue;
            return field;
        }
        return null;
    }

    public int getSelectedPos() {
        for (int i = 0; i < this.fields.length; ++i) {
            GuiTextField field = this.fields[i];
            if (!field.func_146206_l()) continue;
            return i;
        }
        return -1;
    }

    public void drawTextBox() {
        DisplayTextFields.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height * this.size + 1), (int)-6250336);
        DisplayTextFields.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height * this.size), (int)-16777216);
        for (int i = 0; i < this.fields.length; ++i) {
            GuiTextField field = this.fields[i];
            field.func_146194_f();
        }
    }

    public boolean isFocused() {
        return this.getSelectedField() != null;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean flag;
        boolean bl = flag = mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height * this.size;
        if (!flag) {
            return;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            GuiTextField field = this.fields[i];
            field.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    public void keyTyped(char typedChar, int keyCode) {
        for (int i = 0; i < this.fields.length; ++i) {
            GuiTextField field = this.fields[i];
            if (!field.func_146206_l()) continue;
            if (typedChar == '\u001b') {
                field.func_146195_b(false);
            } else if (keyCode == 200) {
                field.func_146195_b(false);
                if (i - 1 > 0) {
                    this.fields[i - 1].func_146195_b(true);
                } else {
                    this.fields[this.fields.length - 1].func_146195_b(true);
                }
            } else if (keyCode == 208 || typedChar == '\r') {
                field.func_146195_b(false);
                if (i + 1 < this.fields.length) {
                    this.fields[i + 1].func_146195_b(true);
                } else {
                    this.fields[0].func_146195_b(true);
                }
            } else {
                field.func_146201_a(typedChar, keyCode);
            }
            return;
        }
    }

    public ArrayList<String> textList() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.fields.length; ++i) {
            GuiTextField field = this.fields[i];
            list.add(field.func_146179_b());
        }
        return list;
    }
}

