/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import com.google.common.collect.Lists;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.wireless.ClientDataEmitter;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.client.RenderBlockSelection;
import sonar.logistics.client.gui.generic.GuiSelectionList;
import sonar.logistics.common.containers.ContainerDataReceiver;
import sonar.logistics.common.multiparts.wireless.DataReceiverPart;
import sonar.logistics.helpers.InfoRenderer;

public class GuiDataReceiver
extends GuiSelectionList<ClientDataEmitter> {
    public DataReceiverPart tile;

    public GuiDataReceiver(DataReceiverPart tile) {
        super((Container)new ContainerDataReceiver(tile), tile);
        this.tile = tile;
        this.field_146999_f = 248;
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)PL2Translate.DATA_RECEIVER.t(), (int)this.field_146999_f, (int)6, (CustomColour)LogisticsColours.white_text);
        FontHelper.textCentre((String)PL2Translate.DATA_RECEIVER_HELP.t(), (int)this.field_146999_f, (int)18, (CustomColour)LogisticsColours.grey_text);
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, ClientDataEmitter info) {
        if (buttonID == 0) {
            this.tile.selectedEmitter.setObject((INBTSyncable)info);
            this.tile.sendByteBufPacket(0);
        } else {
            RenderBlockSelection.addPosition(info.coords.getCoords(), false);
        }
    }

    @Override
    public void setInfo() {
        this.infoList = Lists.newArrayList(PL2.getClientManager().clientEmitters);
    }

    @Override
    public boolean isCategoryHeader(ClientDataEmitter info) {
        return !RenderBlockSelection.positions.isEmpty() && RenderBlockSelection.isPositionRenderered(info.coords.getCoords());
    }

    @Override
    public boolean isSelectedInfo(ClientDataEmitter info) {
        return this.tile.clientEmitters.getObjects().contains(info);
    }

    @Override
    public void renderInfo(ClientDataEmitter info, int yPos) {
        int colour = LogisticsColours.white_text.getRGB();
        FontHelper.text((String)((String)info.name.getObject()), (int)InfoRenderer.identifierLeft, (int)yPos, (int)colour);
        FontHelper.text((String)info.coords.getCoords().toString(), (int)173, (int)yPos, (int)colour);
    }

    @Override
    public int getColour(int i, int type) {
        return LogisticsColours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(ClientDataEmitter info) {
        return false;
    }
}

