/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.Container;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.info.render.DisplayInfo;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.client.DisplayTextFields;
import sonar.logistics.client.LogisticsButton;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.client.RenderBlockSelection;
import sonar.logistics.client.gui.generic.GuiSelectionList;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.common.multiparts.displays.LargeDisplayScreenPart;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.MonitoredBlockCoords;

public class GuiDisplayScreen
extends GuiSelectionList<Object> {
    public AbstractDisplayPart part;
    public DisplayTextFields textFields;
    private GuiState state = GuiState.LIST;
    private int left = 7;
    public int infoID = -1;
    public int coolDown = 0;

    public GuiDisplayScreen(AbstractDisplayPart part) {
        super((Container)new ContainerMultipartSync((SonarMultipart)part), part);
        this.part = part;
        this.field_147000_g = 20 + part.maxInfo() * 26;
        this.enableListRendering = false;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        switch (this.state) {
            case CREATE: {
                break;
            }
            case EDIT: {
                this.field_146292_n.add(new GuiButton(0, this.field_147003_i + 8, this.field_147009_r + 5, 40, 20, PL2Translate.BUTTON_DATA.t()));
                this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 48, this.field_147009_r + 5, 40, 20, PL2Translate.BUTTON_NAME.t()));
                this.field_146292_n.add(new GuiButton(2, this.field_147003_i + 88, this.field_147009_r + 5, 40, 20, PL2Translate.BUTTON_PREFIX.t()));
                this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 128, this.field_147009_r + 5, 40, 20, PL2Translate.BUTTON_SUFFIX.t()));
                this.field_146292_n.add(new GuiButton(4, this.field_147003_i + 8, this.field_147009_r + 130 + 8, 50, 20, PL2Translate.BUTTON_RESET.t()));
                this.field_146292_n.add(new GuiButton(5, this.field_147003_i + 8 + 50, this.field_147009_r + 130 + 8, 50, 20, PL2Translate.BUTTON_CLEAR.t()));
                this.field_146292_n.add(new GuiButton(6, this.field_147003_i + 108, this.field_147009_r + 130 + 8, 50, 20, PL2Translate.BUTTON_SAVE.t()));
                ArrayList<String> strings = this.textFields == null ? this.part.container().getDisplayInfo(this.infoID).getUnformattedStrings() : this.textFields.textList();
                this.textFields = new DisplayTextFields(8, 32, 8);
                this.textFields.initFields(strings);
                break;
            }
            case LIST: {
                this.field_146292_n.add(new LogisticsButton(this, -1, this.field_147003_i + 127, this.field_147009_r + 3, 64, 0 + 16 * this.part.getLayout().ordinal(), PL2Translate.BUTTON_LAYOUT.t() + ": " + (Object)((Object)this.part.getLayout()), "button.ScreenLayout"));
                if (this.part instanceof LargeDisplayScreenPart) {
                    LargeDisplayScreenPart display = (LargeDisplayScreenPart)this.part;
                    this.field_146292_n.add(new LogisticsButton(this, -2, this.field_147003_i + 127 + 20, this.field_147009_r + 3, 160, (Boolean)display.getDisplayScreen().isLocked.getObject() != false ? 0 : 16, PL2Translate.BUTTON_LOCKED.t() + ": " + display.getDisplayScreen().isLocked.getObject(), "button.LockDisplay"));
                }
                int height = 20;
                int left = 7;
                for (int i = 0; i < this.part.maxInfo(); ++i) {
                    int top = 22 + (height + 6) * i;
                    this.field_146292_n.add(new LogisticsButton(this, i, this.field_147003_i + 127, this.field_147009_r + top, 32, 224, PL2Translate.BUTTON_EDIT.t(), ""));
                    this.field_146292_n.add(new LogisticsButton(this, i + 100, this.field_147003_i + 147, this.field_147009_r + top, 32, 240, PL2Translate.BUTTON_SOURCE.t(), ""));
                }
                break;
            }
            case SOURCE: {
                this.scroller = new SonarScroller(this.field_147003_i + 164 + 71, this.field_147009_r + 29, 134, 10);
                for (int i = 0; i < this.size; ++i) {
                    this.field_146292_n.add(new GuiSelectionList.SelectionButton(this, 10 + i, this.field_147003_i + 7, this.field_147009_r + 29 + i * 12, this.listWidth, this.listHeight));
                }
                break;
            }
        }
    }

    @Override
    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        if (this.coolDown != 0) {
            --this.coolDown;
        }
    }

    @Override
    public void func_146284_a(GuiButton button) {
        if (this.coolDown != 0 || button == null) {
            return;
        }
        switch (this.state) {
            case CREATE: {
                break;
            }
            case EDIT: {
                GuiTextField field = this.textFields.getSelectedField();
                switch (button.field_146127_k) {
                    case 0: {
                        if (field == null) break;
                        field.func_146191_b("%DATA%");
                        break;
                    }
                    case 1: {
                        if (field == null) break;
                        field.func_146191_b("%NAME%");
                        break;
                    }
                    case 2: {
                        if (field == null) break;
                        field.func_146191_b("%PRE%");
                        break;
                    }
                    case 3: {
                        if (field == null) break;
                        field.func_146191_b("%SUF%");
                        break;
                    }
                    case 4: {
                        this.textFields.initFields(this.part.container().getDisplayInfo(this.infoID).getUnformattedStrings());
                        break;
                    }
                    case 5: {
                        this.textFields.initFields(Lists.newArrayList());
                        break;
                    }
                    case 6: {
                        this.part.container().getDisplayInfo(this.infoID).setFormatStrings(this.textFields.textList());
                        this.part.currentSelected = this.infoID;
                        this.part.sendByteBufPacket(1);
                        this.changeState(GuiState.LIST, -1);
                    }
                }
                break;
            }
            case LIST: {
                if (button.field_146127_k == -1) {
                    this.part.incrementLayout();
                    this.reset();
                    this.part.sendByteBufPacket(2);
                    break;
                }
                if (button.field_146127_k == -2) {
                    ((LargeDisplayScreenPart)this.part).getDisplayScreen().isLocked.invert();
                    this.reset();
                    this.part.sendByteBufPacket(6);
                    break;
                }
                if (button.field_146127_k >= 100) {
                    this.changeState(GuiState.SOURCE, button.field_146127_k - 100);
                    break;
                }
                this.changeState(GuiState.EDIT, button.field_146127_k);
                break;
            }
            case SOURCE: {
                super.func_146284_a(button);
                break;
            }
        }
    }

    public void changeState(GuiState state, int btnID) {
        this.state = state;
        this.infoID = btnID;
        this.field_146999_f = state.xSize;
        this.field_147000_g = state == GuiState.LIST ? 20 + this.part.maxInfo() * 26 : state.ySize;
        boolean bl = this.enableListRendering = state == GuiState.SOURCE;
        if (this.scroller != null) {
            this.scroller.renderScroller = state == GuiState.SOURCE;
        }
        this.coolDown = state != GuiState.LIST ? 25 : 0;
        this.reset();
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        switch (this.state) {
            case CREATE: {
                break;
            }
            case EDIT: {
                this.textFields.drawTextBox();
                break;
            }
            case LIST: {
                FontHelper.textCentre((String)PL2Translate.DISPLAY_SCREEN.t(), (int)this.field_146999_f, (int)6, (int)LogisticsColours.white_text.getRGB());
                RenderHelper.saveBlendState();
                for (int i = 0; i < this.part.maxInfo(); ++i) {
                    this.drawInfo(i, i < this.size ? this.part.container().getDisplayInfo(i) : null);
                }
                RenderHelper.restoreBlendState();
                break;
            }
            case SOURCE: {
                FontHelper.textCentre((String)PL2Translate.SCREEN_INFO_SELECT.t(), (int)this.field_146999_f, (int)6, (CustomColour)LogisticsColours.white_text);
                FontHelper.textCentre((String)PL2Translate.SCREEN_INFO_SELECT_HELP.t(), (int)this.field_146999_f, (int)18, (CustomColour)LogisticsColours.grey_text);
                break;
            }
        }
    }

    @Override
    public void func_73864_a(int i, int j, int k) throws IOException {
        if (this.coolDown != 0) {
            return;
        }
        if (this.state == GuiState.EDIT) {
            this.textFields.mouseClicked(i - this.field_147003_i, j - this.field_147009_r, k);
        }
        super.func_73864_a(i, j, k);
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (this.state == GuiState.EDIT && this.textFields.isFocused()) {
            this.textFields.keyTyped(c, i);
            return;
        }
        if (this.state != GuiState.LIST && (i == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(i))) {
            this.changeState(GuiState.LIST, -1);
            return;
        }
        super.func_73869_a(c, i);
    }

    public void drawInfo(int pos, DisplayInfo info) {
        int width = 162;
        int height = 20;
        int left = 7;
        int top = 20 + (height + 6) * pos;
        GuiDisplayScreen.drawTransparentRect((int)left, (int)top, (int)(left + width), (int)(top + height), (int)LogisticsColours.layers[2].getRGB());
        GuiDisplayScreen.drawTransparentRect((int)(left + 1), (int)(top + 1), (int)(left - 1 + width), (int)(top - 1 + height), (int)LogisticsColours.grey_base.getRGB());
        if (info == null) {
            return;
        }
        IInfo monitorInfo = info.getSidedCachedInfo(true);
        if (monitorInfo instanceof INameableInfo) {
            INameableInfo directInfo = (INameableInfo)monitorInfo;
            FontHelper.text((String)directInfo.getClientIdentifier(), (int)11, (int)(top + 6), (int)LogisticsColours.white_text.getRGB());
        } else {
            FontHelper.text((String)(!info.getUnformattedStrings().isEmpty() ? PL2Translate.SCREEN_CUSTOM_DATA.t() : PL2Translate.SCREEN_NO_DATA.t()), (int)11, (int)(top + 6), (int)LogisticsColours.white_text.getRGB());
        }
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        RenderHelper.restoreBlendState();
    }

    @Override
    public int getColour(int i, int type) {
        return LogisticsColours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(Object info) {
        return info instanceof IInfoProvider && !RenderBlockSelection.positions.isEmpty() && RenderBlockSelection.isPositionRenderered(((IInfoProvider)info).getCoords());
    }

    @Override
    public boolean isCategoryHeader(Object info) {
        return info instanceof IInfoProvider;
    }

    @Override
    public boolean isSelectedInfo(Object info) {
        return info instanceof InfoUUID && this.part.container().getInfoUUID(this.infoID) != null && this.part.container().getInfoUUID(this.infoID).equals(info);
    }

    @Override
    public void renderInfo(Object info, int yPos) {
        if (info instanceof InfoUUID) {
            IInfo monitorInfo = PL2.getClientManager().info.get((InfoUUID)info);
            if (monitorInfo != null) {
                InfoRenderer.renderMonitorInfoInGUI(monitorInfo, yPos + 1, LogisticsColours.white_text.getRGB());
            } else {
                FontHelper.text((String)"-", (int)InfoRenderer.identifierLeft, (int)yPos, (int)LogisticsColours.white_text.getRGB());
            }
        } else if (info instanceof IInfoProvider) {
            IInfoProvider monitor = (IInfoProvider)info;
            InfoRenderer.renderMonitorInfoInGUI(new MonitoredBlockCoords(monitor.getCoords(), monitor.getDisplayName()), yPos + 1, LogisticsColours.white_text.getRGB());
        }
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, Object info) {
        if (buttonID == 0 && info instanceof InfoUUID) {
            this.part.container().setUUID((InfoUUID)info, this.infoID);
            this.part.currentSelected = this.infoID;
            this.part.sendByteBufPacket(0);
        } else if (info instanceof IInfoProvider) {
            RenderBlockSelection.addPosition(((IInfoProvider)info).getCoords(), false);
        }
    }

    @Override
    public void setInfo() {
        this.infoList = Lists.newArrayList((Iterable)PL2.getClientManager().sortedLogicMonitors.getOrDefault(this.part.getIdentity(), Lists.newArrayList()));
    }

    public static enum GuiState {
        LIST(176, 0),
        EDIT(176, 166),
        SOURCE(248, 166),
        CREATE(176, 166);

        int xSize;
        int ySize;

        private GuiState(int xSize, int ySize) {
            this.xSize = xSize;
            this.ySize = ySize;
        }
    }
}

