/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.tiles.readers.EnergyReader;
import sonar.logistics.client.LogisticsButton;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.client.RenderBlockSelection;
import sonar.logistics.client.gui.generic.GuiSelectionList;
import sonar.logistics.common.containers.ContainerEnergyReader;
import sonar.logistics.common.multiparts.readers.EnergyReaderPart;
import sonar.logistics.info.types.MonitoredEnergyStack;

public class GuiEnergyReader
extends GuiSelectionList<MonitoredEnergyStack> {
    public EnergyReaderPart part;
    public EntityPlayer player;

    public GuiEnergyReader(EntityPlayer player, EnergyReaderPart tile) {
        super((Container)new ContainerEnergyReader(player, tile), tile);
        this.part = tile;
        this.player = player;
        this.field_146999_f = 248;
        this.listHeight = 18;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
    }

    public void initButtons() {
        int start = 8;
        this.field_146292_n.add(new LogisticsButton.CHANNELS(this, 0, this.field_147003_i + start, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton.HELP(this, 1, this.field_147003_i + start + 18, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton(this, 2, this.field_147003_i + start + 36, this.field_147009_r + 9, 144, 16 * ((EnergyReader.Modes)this.part.setting.getObject()).ordinal(), ((EnergyReader.Modes)this.part.setting.getObject()).getName(), ((EnergyReader.Modes)this.part.setting.getObject()).getDescription()));
        if (this.part.setting.getObject() != EnergyReader.Modes.STORAGES) {
            this.field_146292_n.add(new GuiButton(3, this.field_147003_i + 190, this.field_147009_r + 6, 40, 20, this.part.energyType.getEnergyType().getStorageSuffix()));
        }
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button != null) {
            switch (button.field_146127_k) {
                case 0: {
                    FlexibleGuiHandler.changeGui((IFlexibleGui)this.part, (int)1, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
                    break;
                }
                case 1: {
                    GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                    this.reset();
                    break;
                }
                case 2: {
                    this.part.setting.incrementEnum();
                    this.part.sendByteBufPacket(3);
                    this.reset();
                    break;
                }
                case 3: {
                    this.part.energyType.incrementType();
                    this.part.sendByteBufPacket(4);
                    this.reset();
                }
            }
        }
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)PL2Translate.ENERGY_READER.t(), (int)this.field_146999_f, (int)10, (CustomColour)LogisticsColours.white_text);
    }

    @Override
    public double listScale() {
        return 1.0;
    }

    @Override
    public void setInfo() {
        this.infoList = this.part.getMonitoredList().cloneInfo();
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, MonitoredEnergyStack info) {
        if (buttonID == 0) {
            if (info.isValid() && !info.isHeader()) {
                this.part.selected.setCoords(info.getMonitoredCoords().getCoords());
                this.part.sendByteBufPacket(buttonID == 0 ? -9 : -10);
            }
        } else {
            RenderBlockSelection.addPosition(info.getMonitoredCoords().getCoords(), false);
        }
    }

    @Override
    public boolean isCategoryHeader(MonitoredEnergyStack info) {
        if (!RenderBlockSelection.positions.isEmpty() && RenderBlockSelection.isPositionRenderered(info.getMonitoredCoords().getCoords())) {
            return true;
        }
        return info.isHeader();
    }

    @Override
    public boolean isSelectedInfo(MonitoredEnergyStack info) {
        if (!info.isValid() || info.isHeader()) {
            return false;
        }
        return this.part.selected.getCoords() != null && this.part.selected.getCoords().equals((Object)info.getMonitoredCoords().getCoords());
    }

    @Override
    public boolean isPairedInfo(MonitoredEnergyStack info) {
        if (!info.isValid() || info.isHeader()) {
            return false;
        }
        return false;
    }

    @Override
    public void renderInfo(MonitoredEnergyStack info, int yPos) {
        StoredItemStack storedStack;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (info.getEnergyStack().capacity > 0L) {
            int l = (int)(info.getEnergyStack().stored * 231L / info.getEnergyStack().capacity);
            RenderHelper.saveBlendState();
            GuiEnergyReader.drawTransparentRect((int)25, (int)(yPos + 6), (int)231, (int)(yPos + 14), (int)new CustomColour(0, 10, 5).getRGB());
            if (l != 0) {
                GuiEnergyReader.drawTransparentRect((int)25, (int)(yPos + 6), (int)l, (int)(yPos + 14), (int)new CustomColour(0, 100, 50).getRGB());
            }
            RenderHelper.restoreBlendState();
        }
        if ((storedStack = info.getDropStack()) != null) {
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            GL11.glEnable((int)2929);
            RenderHelper.saveBlendState();
            ItemStack stack = storedStack.item;
            RenderHelper.renderItem((GuiSonar)this, (int)8, (int)(yPos - 2), (ItemStack)stack);
            RenderHelper.renderStoredItemStackOverlay((ItemStack)stack, (long)0L, (int)8, (int)(yPos - 2), null, (boolean)true);
            RenderHelper.restoreBlendState();
        }
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        FontHelper.text((String)(info.getMonitoredCoords().getClientIdentifier() + " - " + info.getMonitoredCoords().getClientObject()), (int)35, (int)((int)((double)(yPos * 1) / 0.75) - 1), (int)LogisticsColours.white_text.getRGB());
        FontHelper.text((String)info.getClientIdentifier(), (int)35, (int)((int)((double)(yPos * 1) / 0.75) + 10), (int)1);
        FontHelper.text((String)info.getClientObject(), (int)160, (int)((int)((double)(yPos * 1) / 0.75) + 10), (int)1);
        GL11.glScaled((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
    }

    @Override
    public int getColour(int i, int type) {
        IInfo info = (IInfo)this.infoList.get(i + this.start);
        if (info == null || info.isHeader()) {
            return LogisticsColours.layers[1].getRGB();
        }
        return LogisticsColours.getDefaultSelection().getRGB();
    }
}

