/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.SonarTextField;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.tiles.readers.FluidReader;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.client.LogisticsButton;
import sonar.logistics.client.gui.generic.GuiSelectionGrid;
import sonar.logistics.common.containers.ContainerFluidReader;
import sonar.logistics.common.multiparts.readers.FluidReaderPart;
import sonar.logistics.info.types.MonitoredFluidStack;

public class GuiFluidReader
extends GuiSelectionGrid<MonitoredFluidStack> {
    public static final ResourceLocation stackBGround = new ResourceLocation("practicallogistics2:textures/gui/inventoryReader_stack.png");
    public static final ResourceLocation clearBGround = new ResourceLocation("practicallogistics2:textures/gui/inventoryReader_clear.png");
    public FluidReaderPart part;
    private SonarTextField slotField;
    private SonarTextField searchField;
    public static final int STACK = 0;
    public static final int POS = 1;
    public static final int INV = 2;
    public static final int STORAGE = 3;
    public EntityPlayer player;

    public GuiFluidReader(FluidReaderPart part, EntityPlayer player) {
        super((Container)new ContainerFluidReader(part, player), part);
        this.part = part;
        this.player = player;
        this.eWidth = 27;
        this.eHeight = 27;
        this.gWidth = 8;
        this.gHeight = 5;
    }

    public FluidReader.Modes getSetting() {
        return (FluidReader.Modes)this.part.setting.getObject();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
        switch (this.getSetting()) {
            case POS: {
                this.slotField = new SonarTextField(2, this.field_146289_q, 63, 10, 32, 14);
                this.slotField.func_146203_f(7);
                this.slotField.func_146180_a("" + this.part.posSlot.getObject());
                this.slotField.setDigitsOnly(true);
                this.fieldList.add(this.slotField);
                break;
            }
        }
        this.searchField = new SonarTextField(3, this.field_146289_q, 135, 10, 104, 14);
        this.searchField.func_146203_f(20);
        this.fieldList.add(this.searchField);
    }

    public void initButtons() {
        super.initButtons();
        int start = 8;
        this.field_146292_n.add(new LogisticsButton.CHANNELS(this, 2, this.field_147003_i + 8, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton.HELP(this, 3, this.field_147003_i + start + 18, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton(this, -1, this.field_147003_i + start + 36, this.field_147009_r + 9, 128, 16 * ((FluidReader.Modes)this.part.setting.getObject()).ordinal(), this.getSetting().getClientName(), this.getSetting().getDescription()));
        this.field_146292_n.add(new LogisticsButton(this, 0, this.field_147003_i + this.field_146999_f - 168 + 18, this.field_147009_r + 9, 32, 16 * ((SortingDirection)this.part.sortingOrder.getObject()).ordinal(), PL2Translate.BUTTON_SORTING_ORDER.t(), ""));
        this.field_146292_n.add(new LogisticsButton(this, 1, this.field_147003_i + this.field_146999_f - 168 + 36, this.field_147009_r + 9, 112, 16 * ((FluidReader.SortingType)this.part.sortingType.getObject()).ordinal(), ((FluidReader.SortingType)this.part.sortingType.getObject()).getClientName(), ""));
    }

    public void onTextFieldChanged(SonarTextField field) {
        super.onTextFieldChanged(field);
        if (field == this.slotField) {
            this.part.posSlot.setObject((Object)field.getIntegerFromText());
            this.part.sendByteBufPacket(4);
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button != null) {
            switch (button.field_146127_k) {
                case -1: {
                    this.part.setting.incrementEnum();
                    this.part.sendByteBufPacket(2);
                    this.reset();
                    break;
                }
                case 0: {
                    this.part.sortingOrder.incrementEnum();
                    this.part.sendByteBufPacket(5);
                    this.initButtons();
                    break;
                }
                case 1: {
                    this.part.sortingType.incrementEnum();
                    this.part.sendByteBufPacket(6);
                    this.initButtons();
                    break;
                }
                case 2: {
                    FlexibleGuiHandler.changeGui((IFlexibleGui)this.part, (int)1, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
                    break;
                }
                case 3: {
                    GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                    this.reset();
                }
            }
        }
    }

    @Override
    public MonitoredList<MonitoredFluidStack> getGridList() {
        String search = this.searchField.func_146179_b();
        if (search == null || search.isEmpty() || search.equals(" ") || search.equals("")) {
            return this.part.getMonitoredList();
        }
        MonitoredList<MonitoredFluidStack> searchList = MonitoredList.newMonitoredList(this.part.getNetworkID());
        for (MonitoredFluidStack stack : (List)this.part.getMonitoredList().clone()) {
            StoredFluidStack fluidStack = stack.getStoredStack();
            if (stack == null || fluidStack.fluid == null || !fluidStack.fluid.getLocalizedName().toLowerCase().contains(this.searchField.func_146179_b().toLowerCase())) continue;
            searchList.add(stack);
        }
        return searchList;
    }

    @Override
    public void onGridClicked(MonitoredFluidStack selection, int pos, int button, boolean empty) {
        if (empty) {
            return;
        }
        if (this.getSetting() == FluidReader.Modes.SELECTED) {
            this.part.selected.setInfo(selection);
            this.part.sendByteBufPacket(1);
        }
        if (this.getSetting() == FluidReader.Modes.POS) {
            List currentList = (List)((ArrayList)this.getGridList()).clone();
            int position = 0;
            for (MonitoredFluidStack stack : currentList) {
                if (stack != null && stack.equals(selection)) {
                    String posString = String.valueOf(position);
                    this.slotField.func_146180_a(posString);
                    this.part.posSlot.setObject((Object)this.slotField.getIntegerFromText());
                    this.part.sendByteBufPacket(4);
                }
                ++position;
            }
        }
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        if (this.getSetting() == FluidReader.Modes.SELECTED) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(playerInv);
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 8, 0, 0, 18, 18);
        }
        super.func_146976_a(var1, var2, var3);
    }

    @Override
    public void preRender() {
        int br = 0x1000100;
        int var11 = 256;
        int var12 = 256;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.8f, (float)204.8f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        if (this.getGridList() != null) {
            GlStateManager.func_179140_f();
            RenderHelper.func_74520_c();
        }
    }

    @Override
    public void postRender() {
        MonitoredFluidStack stack;
        if (this.getSetting() == FluidReader.Modes.SELECTED && this.part.selected.getMonitoredInfo() != null && (stack = this.part.selected.getMonitoredInfo()) != null) {
            StoredFluidStack fluidStack = stack.getStoredStack();
            int br = 0x1000100;
            int var11 = 256;
            int var12 = 256;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluidStack.fluid.getFluid().getStill().toString());
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.func_175175_a(63, 9, sprite, 16, 16);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderGridElement(MonitoredFluidStack selection, int x, int y, int slot) {
        StoredFluidStack fluidStack = selection.getStoredStack();
        if (fluidStack.fluid != null) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluidStack.fluid.getFluid().getStill().toString());
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.func_175175_a(this.xPos + x * this.eWidth, this.yPos + y * this.eHeight, sprite, this.eWidth - 2, this.eHeight - 2);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderElementToolTip(MonitoredFluidStack element, int x, int y) {
        StoredFluidStack fluidStack = element.getStoredStack();
        ArrayList list = Lists.newArrayList();
        list.add(fluidStack.fluid.getFluid().getLocalizedName(fluidStack.fluid));
        if (fluidStack.stored != 0L) {
            list.add(TextFormatting.GRAY + PL2Translate.BUTTON_STORED.t() + ": " + fluidStack.stored + " mB");
        }
        this.drawHoveringText(list, x, y, this.field_146289_q);
    }

    @Override
    public ResourceLocation getBackground() {
        if (this.getSetting() == FluidReader.Modes.SELECTED) {
            return stackBGround;
        }
        return clearBGround;
    }

    @Override
    public void renderStrings(int x, int y) {
    }
}

