/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.helpers.FontHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.client.HelpOverlays;
import sonar.logistics.client.LogisticsButton;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.client.gui.generic.GuiSelectionList;
import sonar.logistics.common.containers.ContainerInfoReader;
import sonar.logistics.common.multiparts.readers.InfoReaderPart;
import sonar.logistics.helpers.InfoRenderer;

public class GuiInfoReader
extends GuiSelectionList<IProvidableInfo> {
    public InfoReaderPart part;
    public EntityPlayer player;
    public GuiHelpOverlay<GuiInfoReader> overlay = HelpOverlays.infoReader;

    public GuiInfoReader(EntityPlayer player, InfoReaderPart tile) {
        super((Container)new ContainerInfoReader(player, tile), tile);
        this.player = player;
        this.part = tile;
        this.field_146999_f = 248;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.overlay.initGui((GuiSonar)this);
        this.field_146292_n.add(new LogisticsButton.CHANNELS(this, 1, this.field_147003_i + 9, this.field_147009_r + 7));
        this.field_146292_n.add(new LogisticsButton.HELP(this, 2, this.field_147003_i + this.field_146999_f - 9 - 16, this.field_147009_r + 7));
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button != null) {
            if (button.field_146127_k == 1) {
                FlexibleGuiHandler.changeGui((IFlexibleGui)this.part, (int)1, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
            }
            if (button.field_146127_k == 2) {
                GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                this.reset();
            }
        }
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.overlay.mouseClicked((GuiSonar)this, x, y, button);
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)PL2Translate.INFO_READER.t(), (int)this.field_146999_f, (int)6, (CustomColour)LogisticsColours.white_text);
        FontHelper.textCentre((String)PL2Translate.INFO_READER_HELP.t(), (int)this.field_146999_f, (int)18, (CustomColour)LogisticsColours.grey_text);
        this.overlay.drawOverlay((GuiSonar)this, x, y);
    }

    @Override
    public void setInfo() {
        this.infoList = !this.part.getChannels().hasChannels() ? MonitoredList.newMonitoredList(this.part.getNetworkID()) : this.part.getMonitoredList().cloneInfo();
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, IProvidableInfo info) {
        if (info.isValid() && !info.isHeader()) {
            this.part.selectedInfo.setInfo(info);
            this.part.sendByteBufPacket(buttonID == 0 ? -9 : -10);
        }
    }

    @Override
    public boolean isCategoryHeader(IProvidableInfo info) {
        return info.isHeader();
    }

    @Override
    public boolean isSelectedInfo(IProvidableInfo info) {
        if (!info.isValid() || info.isHeader()) {
            return false;
        }
        List selectedInfo = this.part.getSelectedInfo();
        for (IProvidableInfo selected : selectedInfo) {
            if (selected == null || selected.isHeader() || !info.isMatchingType(selected) || !info.isMatchingInfo(selected)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPairedInfo(IProvidableInfo info) {
        if (!info.isValid() || info.isHeader()) {
            return false;
        }
        List pairedInfo = this.part.getPairedInfo();
        for (IProvidableInfo selected : pairedInfo) {
            if (selected == null || selected.isHeader() || !info.isMatchingType(selected) || !info.isMatchingInfo(selected)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void renderInfo(IProvidableInfo info, int yPos) {
        InfoRenderer.renderMonitorInfoInGUI(info, yPos + 1, LogisticsColours.white_text.getRGB());
    }

    @Override
    public int getColour(int i, int type) {
        IProvidableInfo info = (IProvidableInfo)this.infoList.get(i + this.start);
        if (info == null || info.isHeader()) {
            return LogisticsColours.layers[1].getRGB();
        }
        List selectedInfo = type == 0 ? this.part.getSelectedInfo() : this.part.getPairedInfo();
        int pos = 0;
        for (IProvidableInfo selected : selectedInfo) {
            if (selected != null && !selected.isHeader() && info.isMatchingType(selected) && info.isMatchingInfo(selected)) {
                return LogisticsColours.infoColours[pos].getRGB();
            }
            ++pos;
        }
        return LogisticsColours.layers[1].getRGB();
    }

    public void func_73869_a(char c, int i) throws IOException {
        super.func_73869_a(c, i);
        this.overlay.onTileChanged((GuiSonar)this);
    }
}

