/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.helpers.FontHelper;
import sonar.core.network.PacketFlexibleCloseGui;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.tiles.readers.IWirelessStorageReader;
import sonar.logistics.api.wireless.ClientDataEmitter;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.client.RenderBlockSelection;
import sonar.logistics.client.gui.generic.GuiSelectionList;
import sonar.logistics.common.containers.ContainerEmitterList;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.network.PacketWirelessStorage;

public class GuiWirelessStorageEmitterList
extends GuiSelectionList<ClientDataEmitter> {
    public EntityPlayer player;
    public ItemStack reader;

    public GuiWirelessStorageEmitterList(ItemStack reader, EntityPlayer player) {
        super(new ContainerEmitterList(player), null);
        this.reader = reader;
        this.field_146999_f = 248;
        this.player = player;
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)PL2Translate.WIRELESS_STORAGE_READER.t(), (int)this.field_146999_f, (int)6, (CustomColour)LogisticsColours.white_text);
        FontHelper.textCentre((String)PL2Translate.WIRELESS_STORAGE_READER_EMITTER.t(), (int)this.field_146999_f, (int)18, (CustomColour)LogisticsColours.grey_text);
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, ClientDataEmitter info) {
        if (buttonID == 1) {
            RenderBlockSelection.addPosition(info.coords.getCoords(), false);
        } else {
            final int identity = info.getIdentity();
            PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 1, new ByteBufWritable(false){

                public void writeToBuf(ByteBuf buf) {
                    buf.writeInt(identity);
                }
            }));
        }
    }

    @Override
    public void setInfo() {
        this.infoList = Lists.newArrayList(PL2.getClientManager().clientEmitters);
    }

    @Override
    public boolean isCategoryHeader(ClientDataEmitter info) {
        return !RenderBlockSelection.positions.isEmpty() && RenderBlockSelection.isPositionRenderered(info.coords.getCoords());
    }

    @Override
    public boolean isSelectedInfo(ClientDataEmitter info) {
        int uuid;
        ItemStack current = this.player.func_184614_ca();
        return current != null && current.func_77942_o() && (uuid = current.func_77978_p().func_74762_e("uuid")) == info.getIdentity();
    }

    @Override
    public void renderInfo(ClientDataEmitter info, int yPos) {
        int colour = LogisticsColours.white_text.getRGB();
        FontHelper.text((String)((String)info.name.getObject()), (int)InfoRenderer.identifierLeft, (int)yPos, (int)colour);
        FontHelper.text((String)info.coords.getCoords().toString(), (int)173, (int)yPos, (int)colour);
    }

    @Override
    public int getColour(int i, int type) {
        return LogisticsColours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(ClientDataEmitter info) {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if ((keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) && SonarCore.instance.guiHandler.lastScreen != null) {
            SonarCore.network.sendToServer((IMessage)new PacketFlexibleCloseGui(this.player.func_180425_c()));
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }
}

