/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.utils.ByteBufWritable;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.tiles.readers.FluidReader;
import sonar.logistics.api.tiles.readers.IWirelessStorageReader;
import sonar.logistics.api.tiles.readers.InventoryReader;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.client.LogisticsButton;
import sonar.logistics.client.gui.generic.GuiSelectionGrid;
import sonar.logistics.common.containers.ContainerStorageViewer;
import sonar.logistics.common.multiparts.wireless.DataEmitterPart;
import sonar.logistics.helpers.ItemHelper;
import sonar.logistics.info.types.MonitoredItemStack;
import sonar.logistics.network.PacketWirelessStorage;

public class GuiWirelessStorageReader
extends GuiSelectionGrid<IInfo> {
    public static final ResourceLocation sorting_icons = new ResourceLocation("practicallogistics2:textures/gui/sorting_icons.png");
    private SonarTextField searchField;
    public EntityPlayer player;
    public int identity;
    public int networkID;
    public ItemStack reader;
    public static boolean items = true;
    public static SyncEnum<SortingDirection> sortingOrder = (SyncEnum)new SyncEnum((Enum[])SortingDirection.values(), 0).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public static SyncEnum<InventoryReader.SortingType> sortItems = (SyncEnum)new SyncEnum((Enum[])InventoryReader.SortingType.values(), 0).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<FluidReader.SortingType> sortfluids = (SyncEnum)new SyncEnum((Enum[])FluidReader.SortingType.values(), 0).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});

    public GuiWirelessStorageReader(ItemStack reader, int identity, int networkID, EntityPlayer player) {
        super(new ContainerStorageViewer(identity, player), null);
        this.reader = reader;
        this.identity = identity;
        this.networkID = networkID;
        this.player = player;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
        this.searchField = new SonarTextField(1, this.field_146289_q, 135, 10, 104, 14);
        this.searchField.func_146203_f(20);
        this.fieldList.add(this.searchField);
    }

    public void initButtons() {
        super.initButtons();
        int start = 8;
        this.field_146292_n.add(new LogisticsButton.CHANNELS(this, 2, this.field_147003_i + start, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton.HELP(this, 5, this.field_147003_i + start + 18, this.field_147009_r + 9));
        this.field_146292_n.add(new LogisticsButton(this, 0, this.field_147003_i + this.field_146999_f - 168 + 18, this.field_147009_r + 9, 32, 16 * ((SortingDirection)sortingOrder.getObject()).ordinal(), PL2Translate.BUTTON_SORTING_ORDER.t(), ""));
        this.field_146292_n.add(new LogisticsButton(this, 1, this.field_147003_i + this.field_146999_f - 168 + 36, this.field_147009_r + 9, 112, 16 * ((InventoryReader.SortingType)sortItems.getObject()).ordinal(), ((InventoryReader.SortingType)sortItems.getObject()).getClientName(), ""));
        this.field_146292_n.add(new LogisticsButton(this, 3, this.field_147003_i + 203, this.field_147009_r + 174, 32, 0, PL2Translate.BUTTON_DUMP_PLAYER.t(), ""));
        this.field_146292_n.add(new LogisticsButton(this, 4, this.field_147003_i + 203 + 18, this.field_147009_r + 174, 32, 16, PL2Translate.BUTTON_DUMP_NETWORK.t(), ""));
    }

    public void func_146284_a(GuiButton button) {
        if (button != null) {
            switch (button.field_146127_k) {
                case 0: {
                    sortingOrder.incrementEnum();
                    this.initButtons();
                    break;
                }
                case 1: {
                    if (items) {
                        sortItems.incrementEnum();
                    } else {
                        this.sortfluids.incrementEnum();
                    }
                    this.initButtons();
                    break;
                }
                case 2: {
                    FlexibleGuiHandler.changeGui((IFlexibleGui)((IFlexibleGui)this.player.func_184614_ca().func_77973_b()), (int)1, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
                    break;
                }
                case 3: {
                    PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 0, new ByteBufWritable(false){

                        public void writeToBuf(ByteBuf buf) {
                            buf.writeBoolean(false);
                            buf.writeInt(3);
                        }
                    }));
                    break;
                }
                case 4: {
                    PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 0, new ByteBufWritable(false){

                        public void writeToBuf(ByteBuf buf) {
                            buf.writeBoolean(false);
                            buf.writeInt(4);
                        }
                    }));
                    break;
                }
                case 5: {
                    GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                    this.reset();
                }
            }
        }
    }

    public void switchState() {
        SonarCore.refreshFlexibleContainer((EntityPlayer)this.player);
    }

    @Override
    public void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        if (k == 1) {
            this.searchField.func_146180_a("");
        }
    }

    @Override
    public MonitoredList<IInfo> getGridList() {
        String search = this.searchField.func_146179_b();
        if (items) {
            MonitoredList<MonitoredItemStack> currentList = PL2.getClientManager().getMonitoredList(this.networkID, new InfoUUID(this.identity, DataEmitterPart.STATIC_ITEM_ID));
            ItemHelper.sortItemList(currentList, (SortingDirection)sortingOrder.getObject(), (InventoryReader.SortingType)sortItems.getObject());
            MonitoredList<IInfo> list = MonitoredList.newMonitoredList(this.networkID);
            list.addAll(currentList);
            if (search == null || search.isEmpty() || search.equals(" ")) {
                return list;
            }
            MonitoredList<IInfo> searchList = MonitoredList.newMonitoredList(this.networkID);
            for (MonitoredItemStack stack : (List)currentList.clone()) {
                StoredItemStack item = stack.getStoredStack();
                if (stack == null || item == null || !item.item.func_82833_r().toLowerCase().contains(search.toLowerCase())) continue;
                searchList.add(stack);
            }
            return searchList;
        }
        return PL2.getClientManager().getMonitoredList(this.networkID, new InfoUUID(this.identity, DataEmitterPart.STATIC_FLUID_ID));
    }

    @Override
    public void onGridClicked(final IInfo info, int pos, int button, boolean empty) {
        if (Keyboard.isKeyDown((int)42)) {
            button = 2;
        }
        final int usedButton = button;
        if (!empty) {
            PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 0, new ByteBufWritable(false){

                public void writeToBuf(ByteBuf buf) {
                    MonitoredItemStack selection = (MonitoredItemStack)info;
                    if (selection != null && selection.getStoredStack().item != null) {
                        buf.writeBoolean(true);
                        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)selection.getStoredStack().item);
                    } else {
                        buf.writeBoolean(false);
                    }
                    buf.writeInt(usedButton);
                }
            }));
        } else {
            PL2.network.sendToServer((IMessage)new PacketWirelessStorage((IWirelessStorageReader)this.reader.func_77973_b(), this.reader, this.player, 0, new ByteBufWritable(false){

                public void writeToBuf(ByteBuf buf) {
                    buf.writeBoolean(false);
                    buf.writeInt(usedButton);
                }
            }));
        }
    }

    @Override
    public void renderStrings(int x, int y) {
    }

    @Override
    public void renderGridElement(IInfo info, int x, int y, int slot) {
        if (info instanceof MonitoredItemStack) {
            MonitoredItemStack selection = (MonitoredItemStack)info;
            RenderHelper.saveBlendState();
            StoredItemStack storedStack = selection.getStoredStack();
            if (storedStack == null) {
                return;
            }
            ItemStack stack = storedStack.item;
            RenderHelper.renderItem((GuiSonar)this, (int)(13 + x * 18), (int)(32 + y * 18), (ItemStack)stack);
            RenderHelper.renderStoredItemStackOverlay((ItemStack)stack, (long)storedStack.stored, (int)(13 + x * 18), (int)(32 + y * 18), null, (boolean)true);
            RenderHelper.restoreBlendState();
        }
    }

    @Override
    public void renderElementToolTip(IInfo info, int x, int y) {
        if (info instanceof MonitoredItemStack) {
            MonitoredItemStack selection = (MonitoredItemStack)info;
            StoredItemStack storedStack = selection.getStoredStack();
            if (storedStack == null) {
                return;
            }
            List list = storedStack.item.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
            list.add(1, PL2Translate.BUTTON_STORED + ": " + storedStack.stored);
            for (int k = 0; k < list.size(); ++k) {
                if (k == 0) {
                    list.set(k, storedStack.item.func_77953_t().field_77937_e + (String)list.get(k));
                    continue;
                }
                list.set(k, TextFormatting.GRAY + (String)list.get(k));
            }
            FontRenderer font = storedStack.item.func_77973_b().getFontRenderer(storedStack.item);
            this.drawHoveringText(list, x, y, font == null ? this.field_146289_q : font);
        }
    }
}

