/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui.generic;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.HelpOverlay;
import sonar.core.helpers.FontHelper;
import sonar.core.network.PacketFlexibleCloseGui;
import sonar.core.utils.CustomColour;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.tiles.IChannelledTile;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.client.RenderBlockSelection;
import sonar.logistics.client.gui.generic.GuiSelectionList;
import sonar.logistics.common.containers.ContainerChannelSelection;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.MonitoredBlockCoords;
import sonar.logistics.info.types.MonitoredEntity;

public class GuiChannelSelection
extends GuiSelectionList<IInfo> {
    public EntityPlayer player;
    public IChannelledTile tile;
    public int channelID;
    public GuiHelpOverlay<GuiChannelSelection> overlay = new GuiHelpOverlay<GuiChannelSelection>(){
        {
            this.overlays.add(new HelpOverlay<GuiChannelSelection>("select channel", 7, 5, 20, 19, Color.RED.getRGB()){

                public boolean isCompletedSuccess(GuiChannelSelection gui) {
                    return false;
                }

                public boolean canBeRendered(GuiChannelSelection gui) {
                    return true;
                }
            });
            this.overlays.add(new HelpOverlay<GuiChannelSelection>("guide.Hammer.name", 4, 26, 231, 137, Color.RED.getRGB()){

                public boolean isCompletedSuccess(GuiChannelSelection gui) {
                    return false;
                }

                public boolean canBeRendered(GuiChannelSelection gui) {
                    return true;
                }
            });
        }
    };

    public GuiChannelSelection(EntityPlayer player, IChannelledTile tile, int channelID) {
        super((Container)new ContainerChannelSelection(tile), tile);
        this.player = player;
        this.tile = tile;
        this.channelID = channelID;
        this.field_146999_f = 248;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.overlay.initGui((GuiSonar)this);
    }

    @Override
    public void setInfo() {
        this.infoList = (List)PL2.getClientManager().channelMap.getOrDefault(this.tile.getNetworkID(), MonitoredList.newMonitoredList(this.tile.getNetworkID())).clone();
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.overlay.mouseClicked((GuiSonar)this, x, y, button);
    }

    @Override
    public void selectionPressed(GuiButton button, int infoPos, int buttonID, IInfo info) {
        if (buttonID == 0) {
            this.tile.sendCoordsToServer(info, this.channelID);
        } else if (info instanceof MonitoredBlockCoords) {
            RenderBlockSelection.addPosition(((MonitoredBlockCoords)info).getCoords(), false);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if ((keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) && this.tile instanceof IFlexibleGui && SonarCore.instance.guiHandler.lastScreen != null) {
            SonarCore.network.sendToServer((IMessage)new PacketFlexibleCloseGui(this.tile.getCoords().getBlockPos()));
        } else {
            super.func_73869_a(typedChar, keyCode);
            this.overlay.onTileChanged((GuiSonar)this);
        }
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        FontHelper.textCentre((String)PL2Translate.CHANNELS_SELECTION.t(), (int)this.field_146999_f, (int)6, (CustomColour)LogisticsColours.white_text);
        FontHelper.textCentre((String)PL2Translate.CHANNELS_SELECTION_HELP.t(), (int)this.field_146999_f, (int)18, (CustomColour)LogisticsColours.grey_text);
        this.overlay.drawOverlay((GuiSonar)this, x, y);
    }

    @Override
    public void renderInfo(IInfo info, int yPos) {
        InfoRenderer.renderMonitorInfoInGUI(info, yPos + 1, LogisticsColours.white_text.getRGB());
    }

    @Override
    public int getColour(int i, int type) {
        return LogisticsColours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isCategoryHeader(IInfo info) {
        return info instanceof MonitoredBlockCoords && !RenderBlockSelection.positions.isEmpty() && RenderBlockSelection.isPositionRenderered(((MonitoredBlockCoords)info).getCoords());
    }

    @Override
    public boolean isSelectedInfo(IInfo info) {
        if (info instanceof MonitoredBlockCoords && info.isValid() && !info.isHeader() && this.tile.getChannels().coordList.contains(((MonitoredBlockCoords)info).getCoords())) {
            return true;
        }
        return info instanceof MonitoredEntity && info.isValid() && !info.isHeader() && this.tile.getChannels().uuidList.contains(((MonitoredEntity)info).getUUID());
    }

    @Override
    public boolean isPairedInfo(IInfo info) {
        return false;
    }
}

