/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.client.gui.generic;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.SonarTextField;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.network.sync.ObjectType;
import sonar.core.utils.CustomColour;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.info.IComparableInfo;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.tiles.readers.INetworkReader;
import sonar.logistics.api.tiles.signaller.ComparableObject;
import sonar.logistics.api.tiles.signaller.EmitterStatement;
import sonar.logistics.api.tiles.signaller.InputTypes;
import sonar.logistics.api.tiles.signaller.LogicOperator;
import sonar.logistics.api.tiles.signaller.SignallerModes;
import sonar.logistics.api.utils.ListPacket;
import sonar.logistics.client.LogisticsButton;
import sonar.logistics.client.LogisticsColours;
import sonar.logistics.client.RenderBlockSelection;
import sonar.logistics.client.gui.generic.GuiSelectionList;
import sonar.logistics.common.multiparts.misc.RedstoneSignallerPart;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.MonitoredBlockCoords;
import sonar.logistics.info.types.MonitoredItemStack;
import sonar.logistics.logic.comparators.ILogicComparator;
import sonar.logistics.network.PacketEmitterStatement;

public class GuiStatementList
extends GuiSelectionList<Object> {
    public RedstoneSignallerPart tile;
    public GuiState state = GuiState.LIST;
    public int coolDown = 0;
    public EmitterStatement currentFilter;
    public EmitterStatement lastFilter;
    public int infoPos;
    public boolean currentBool = false;
    public SonarTextField inputField;

    public GuiStatementList(EntityPlayer player, RedstoneSignallerPart tile) {
        super((Container)new ContainerMultipartSync((SonarMultipart)tile), tile);
        this.tile = tile;
        this.field_146999_f = 248;
        this.field_147000_g += 22;
    }

    @Override
    public void func_73866_w_() {
        this.listHeight = GuiState.LIST == this.state ? 24 : 12;
        super.func_73866_w_();
        switch (this.state) {
            case LIST: {
                int start = 42;
                this.field_146292_n.add(new LogisticsButton(this, 0, this.field_147003_i + start, this.field_147009_r + 6, 48, 0 + 16 * ((SignallerModes)this.tile.emitterMode().getObject()).ordinal(), "Emit If: " + ((SignallerModes)this.tile.emitterMode().getObject()).name(), "button.EmitterMode"));
                this.field_146292_n.add(new LogisticsButton(this, 1, this.field_147003_i + start + 20, this.field_147009_r + 6, 32, 128, "New Statement", "button.NewStatement"));
                this.field_146292_n.add(new LogisticsButton(this, 2, this.field_147003_i + start + 40, this.field_147009_r + 6, 32, 0, PL2Translate.BUTTON_MOVE_UP.t(), "button.MoveUpStatement"));
                this.field_146292_n.add(new LogisticsButton(this, 3, this.field_147003_i + start + 60, this.field_147009_r + 6, 32, 16, PL2Translate.BUTTON_MOVE_DOWN.t(), "button.MoveDownStatement"));
                this.field_146292_n.add(new LogisticsButton(this, 4, this.field_147003_i + start + 80, this.field_147009_r + 6, 32, 32, PL2Translate.BUTTON_DELETE.t(), "button.DeleteStatement"));
                this.field_146292_n.add(new LogisticsButton(this, 5, this.field_147003_i + start + 100, this.field_147009_r + 6, 32, 96, PL2Translate.BUTTON_CLEAR_ALL.t(), "button.ClearAllStatements"));
                this.field_146292_n.add(new LogisticsButton(this, 6, this.field_147003_i + start + 120, this.field_147009_r + 6, 32, 144, "Refresh", "button.RedstoneSignallerRefresh"));
                this.field_146292_n.add(new LogisticsButton.HELP(this, 7, this.field_147003_i + start + 140, this.field_147009_r + 6));
                break;
            }
            case STATEMENT: {
                this.field_146292_n.add(new GuiButton(0, this.field_147003_i + this.field_146999_f / 2 - 60, this.field_147009_r + 116, 120, 20, "Input Type: " + (Object)((Object)this.currentFilter.getInputType())));
                this.field_146292_n.add(new LogisticsButton(this, 1, this.field_147003_i + 6, this.field_147009_r + 16, 32, 48, "Info Source", "button.InfoSignallerSource"));
                this.field_146292_n.add(new LogisticsButton(this, 3, this.field_147003_i + 6, this.field_147009_r + 16 + 20, 32, 80, "Object Selection", "button.ObjectSelectionSource"));
                if (this.currentFilter.getInputType().usesInfo()) {
                    this.field_146292_n.add(new LogisticsButton(this, 2, this.field_147003_i + 6, this.field_147009_r + 72, 32, 48, "Info Source", "button.InfoSignallerSource"));
                    this.field_146292_n.add(new LogisticsButton(this, 4, this.field_147003_i + 6, this.field_147009_r + 92, 32, 80, "Object Selection", "button.ObjectSelectionSource"));
                } else if (this.currentFilter.getInputType() == InputTypes.BOOLEAN) {
                    this.field_146292_n.add(new GuiButton(8, this.field_147003_i + this.field_146999_f / 2 - 60, this.field_147009_r + 80, 120, 20, "" + this.currentBool));
                } else {
                    Keyboard.enableRepeatEvents((boolean)true);
                    this.inputField = new SonarTextField(0, this.field_146289_q, 8, 96, this.field_146999_f - 16, 12);
                    this.inputField.setDigitsOnly(this.currentFilter.getInputType() == InputTypes.NUMBER);
                    this.inputField.func_146203_f(20);
                    this.inputField.func_146180_a(this.currentFilter.obj.get() == null ? "" : this.currentFilter.obj.get().toString());
                    this.fieldList.add(this.inputField);
                }
                this.field_146292_n.add(new GuiButton(5, this.field_147003_i + this.field_146999_f / 2 - 25, this.field_147009_r + 141, 50, 20, ((LogicOperator)this.currentFilter.operator.getObject()).operation));
                this.field_146292_n.add(new GuiButton(6, this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 164, this.field_146999_f / 2 - 4, 20, "SAVE"));
                this.field_146292_n.add(new GuiButton(7, this.field_147003_i + 4, this.field_147009_r + 164, this.field_146999_f / 2 - 4, 20, "RESET"));
                break;
            }
        }
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        switch (this.state) {
            case LIST: {
                switch (button.field_146127_k) {
                    case 0: {
                        this.tile.mode.incrementEnum();
                        this.tile.sendByteBufPacket(1);
                        this.reset();
                        break;
                    }
                    case 1: {
                        EmitterStatement statement;
                        this.lastFilter = statement = new EmitterStatement();
                        this.currentFilter = statement;
                        this.changeState(GuiState.STATEMENT);
                        break;
                    }
                    case 2: {
                        if (this.currentFilter == null) break;
                        PL2.network.sendToServer((IMessage)new PacketEmitterStatement(this.tile.getUUID(), this.tile.getCoords().getBlockPos(), ListPacket.MOVE_UP, this.currentFilter));
                        break;
                    }
                    case 3: {
                        if (this.currentFilter == null) break;
                        PL2.network.sendToServer((IMessage)new PacketEmitterStatement(this.tile.getUUID(), this.tile.getCoords().getBlockPos(), ListPacket.MOVE_DOWN, this.currentFilter));
                        break;
                    }
                    case 4: {
                        if (this.currentFilter == null) break;
                        PL2.network.sendToServer((IMessage)new PacketEmitterStatement(this.tile.getUUID(), this.tile.getCoords().getBlockPos(), ListPacket.REMOVE, this.currentFilter));
                        break;
                    }
                    case 5: {
                        PL2.network.sendToServer((IMessage)new PacketEmitterStatement(this.tile.getUUID(), this.tile.getCoords().getBlockPos(), ListPacket.CLEAR));
                        break;
                    }
                    case 6: {
                        this.tile.requestSyncPacket();
                        break;
                    }
                    case 7: {
                        GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                        this.reset();
                    }
                }
                break;
            }
            case STATEMENT: {
                switch (button.field_146127_k) {
                    case 0: {
                        this.currentFilter.incrementInputType();
                        this.inputField.func_146180_a("");
                        this.currentFilter.obj.set((Object)"", ObjectType.STRING);
                        this.currentFilter.comparatorID.setObject((Object)PL2.getComparatorRegistry().getObjectID(this.currentFilter.getInputType().comparatorID));
                        this.currentFilter.comparator = (ILogicComparator)PL2.getComparatorRegistry().getRegisteredObject(this.currentFilter.getInputType().comparatorID);
                        if (!this.currentFilter.validOperators().contains((Object)this.currentFilter.getOperator())) {
                            this.currentFilter.operator.setObject((Enum)this.currentFilter.validOperators().get(0));
                        }
                        if (this.currentFilter.getInputType() == InputTypes.BOOLEAN) {
                            this.currentBool = false;
                            this.currentFilter.obj.set((Object)false, ObjectType.BOOLEAN);
                        }
                        this.reset();
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.changeState(GuiState.CHANNELS);
                        this.infoPos = button.field_146127_k - 1;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.changeState(GuiState.STRING);
                        this.infoPos = button.field_146127_k - 3;
                        break;
                    }
                    case 5: {
                        this.currentFilter.incrementOperator();
                        this.reset();
                        break;
                    }
                    case 6: {
                        PL2.network.sendToServer((IMessage)new PacketEmitterStatement(this.tile.getUUID(), this.tile.getCoords().getBlockPos(), ListPacket.ADD, this.currentFilter));
                        this.changeState(GuiState.LIST);
                        break;
                    }
                    case 7: {
                        this.changeState(GuiState.LIST);
                        break;
                    }
                    case 8: {
                        this.currentBool = !this.currentBool;
                        this.currentFilter.obj.set((Object)this.currentBool, ObjectType.BOOLEAN);
                        this.reset();
                    }
                }
                break;
            }
        }
    }

    public void changeState(GuiState state) {
        if (state != GuiState.LIST || this.currentFilter != null) {
            // empty if block
        }
        this.state = state;
        this.enableListRendering = state.hasScroller;
        if (this.scroller != null) {
            this.scroller.renderScroller = state.hasScroller;
        }
        this.coolDown = state != GuiState.LIST ? 15 : 0;
        this.reset();
    }

    @Override
    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        if (this.coolDown != 0) {
            --this.coolDown;
        }
    }

    @Override
    public void func_146979_b(int x, int y) {
        switch (this.state) {
            case CHANNELS: {
                FontHelper.textCentre((String)FontHelper.translate((String)"Info Selection"), (int)this.field_146999_f, (int)6, (CustomColour)LogisticsColours.white_text);
                FontHelper.textCentre((String)String.format("Select the Info you wish to check against", new Object[0]), (int)this.field_146999_f, (int)18, (CustomColour)LogisticsColours.grey_text);
                break;
            }
            case LIST: {
                break;
            }
            case STATEMENT: {
                ComparableObject obj;
                Object monitorInfo;
                String obj1;
                String info1;
                InfoUUID uuid1 = (InfoUUID)this.currentFilter.uuid1.getObject();
                InfoUUID uuid2 = (InfoUUID)this.currentFilter.uuid2.getObject();
                String info2 = info1 = "<- Select the info source";
                String obj2 = obj1 = "<- Select the object to compare";
                boolean has1 = false;
                boolean has2 = false;
                if (uuid1 != null && (monitorInfo = PL2.getClientManager().info.get(uuid1).copy()) != null && monitorInfo instanceof IComparableInfo) {
                    info1 = monitorInfo.getID().toUpperCase() + " - " + monitorInfo.toString();
                    obj = ComparableObject.getComparableObject(((IComparableInfo)monitorInfo).getComparableObjects(Lists.newArrayList()), (String)this.currentFilter.key1.getObject());
                    if (obj != null) {
                        has1 = true;
                        obj1 = (String)this.currentFilter.key1.getObject() + " - " + obj.object.toString();
                    }
                }
                if (this.currentFilter.getInputType().usesInfo()) {
                    if (uuid2 != null && (monitorInfo = PL2.getClientManager().info.get(uuid2).copy()) != null && monitorInfo instanceof IComparableInfo) {
                        info2 = monitorInfo.getID().toUpperCase() + " - " + monitorInfo.toString();
                        obj = ComparableObject.getComparableObject(((IComparableInfo)monitorInfo).getComparableObjects(Lists.newArrayList()), (String)this.currentFilter.key2.getObject());
                        if (obj != null) {
                            has2 = true;
                            obj2 = (String)this.currentFilter.key2.getObject() + " - " + obj.object.toString();
                        }
                    }
                    FontHelper.text((String)info2, (int)26, (int)76, (int)LogisticsColours.white_text.getRGB());
                    FontHelper.text((String)obj2, (int)26, (int)96, (int)LogisticsColours.white_text.getRGB());
                } else if (this.currentFilter.getInputType() == InputTypes.BOOLEAN) {
                    has2 = true;
                    obj2 = "" + this.currentBool;
                } else {
                    FontHelper.text((String)"Input Field", (int)12, (int)80, (int)LogisticsColours.white_text.getRGB());
                    if (!this.inputField.func_146179_b().isEmpty()) {
                        has2 = true;
                        obj2 = this.inputField.func_146179_b();
                    }
                }
                FontHelper.textOffsetCentre((String)(has1 ? obj1 : "Info 1"), (int)48, (int)148, (CustomColour)LogisticsColours.white_text);
                FontHelper.textOffsetCentre((String)(has2 ? obj2 : "Info 2"), (int)(this.field_146999_f - 48), (int)148, (CustomColour)LogisticsColours.white_text);
                FontHelper.text((String)info1, (int)26, (int)20, (int)LogisticsColours.white_text.getRGB());
                FontHelper.text((String)obj1, (int)26, (int)40, (int)LogisticsColours.white_text.getRGB());
                FontHelper.textCentre((String)"Info 1", (int)this.field_146999_f, (int)6, (CustomColour)LogisticsColours.white_text);
                FontHelper.textCentre((String)"Info 2", (int)this.field_146999_f, (int)60, (CustomColour)LogisticsColours.white_text);
                break;
            }
            case STRING: {
                IInfo monitorInfo;
                InfoUUID uuid1 = (InfoUUID)(this.infoPos == 0 ? this.currentFilter.uuid1.getObject() : this.currentFilter.uuid2.getObject());
                if (uuid1 == null || (monitorInfo = PL2.getClientManager().info.get(uuid1)) == null) break;
                FontHelper.textCentre((String)("Info Type: " + monitorInfo.getID().toUpperCase()), (int)this.field_146999_f, (int)6, (int)LogisticsColours.white_text.getRGB());
                GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
                FontHelper.textCentre((String)monitorInfo.toString(), (int)((int)((double)this.field_146999_f * 1.3333333333333333)), (int)24, (int)LogisticsColours.white_text.getRGB());
                GlStateManager.func_179139_a((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
                break;
            }
        }
        super.func_146979_b(x, y);
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        if (this.state == GuiState.STATEMENT) {
            GuiStatementList.drawTransparentRect((int)(this.field_147003_i + 4), (int)(this.field_147009_r + 4), (int)(this.field_147003_i + this.field_146999_f - 4), (int)(this.field_147009_r + 56), (int)LogisticsColours.layers[2].getRGB());
            GuiStatementList.drawTransparentRect((int)(this.field_147003_i + 4), (int)(this.field_147009_r + 140), (int)(this.field_147003_i + this.field_146999_f - 4), (int)(this.field_147009_r + 162), (int)LogisticsColours.layers[1].getRGB());
            GuiStatementList.drawTransparentRect((int)(this.field_147003_i + 4), (int)(this.field_147009_r + 58), (int)(this.field_147003_i + this.field_146999_f - 4), (int)(this.field_147009_r + 138), (int)LogisticsColours.layers[2].getRGB());
        }
        RenderHelper.restoreBlendState();
    }

    @Override
    public int getColour(int i, int type) {
        return LogisticsColours.getDefaultSelection().getRGB();
    }

    @Override
    public boolean isPairedInfo(Object info) {
        return info instanceof INetworkReader && !RenderBlockSelection.positions.isEmpty() && RenderBlockSelection.isPositionRenderered(((INetworkReader)info).getCoords());
    }

    @Override
    public boolean isSelectedInfo(Object info) {
        switch (this.state) {
            case CHANNELS: {
                if (info == null || !(info instanceof InfoUUID) || this.currentFilter == null) break;
                if (this.infoPos == 0) {
                    return this.currentFilter.uuid1.getObject() != null && this.currentFilter.uuid1.getObject().equals(info);
                }
                return this.currentFilter.uuid2.getObject() != null && this.currentFilter.uuid2.getObject().equals(info);
            }
            case LIST: {
                break;
            }
            case STATEMENT: {
                break;
            }
            case STRING: {
                if (info == null || !(info instanceof ComparableObject) || this.currentFilter == null) break;
                if (this.infoPos == 0) {
                    return this.currentFilter.key1.getObject() != null && ((String)this.currentFilter.key1.getObject()).equals(((ComparableObject)info).string);
                }
                return this.currentFilter.key2.getObject() != null && ((String)this.currentFilter.key2.getObject()).equals(((ComparableObject)info).string);
            }
        }
        return false;
    }

    @Override
    public boolean isCategoryHeader(Object info) {
        if (info instanceof EmitterStatement) {
            return info == this.currentFilter;
        }
        return info instanceof IInfoProvider;
    }

    @Override
    public void renderInfo(Object info, int yPos) {
        switch (this.state) {
            case CHANNELS: {
                if (info instanceof InfoUUID) {
                    IInfo monitorInfo = PL2.getClientManager().info.get((InfoUUID)info);
                    if (monitorInfo != null) {
                        InfoRenderer.renderMonitorInfoInGUI(monitorInfo, yPos + 1, LogisticsColours.white_text.getRGB());
                        break;
                    }
                    FontHelper.text((String)"-", (int)InfoRenderer.identifierLeft, (int)yPos, (int)LogisticsColours.white_text.getRGB());
                    break;
                }
                if (!(info instanceof IInfoProvider)) break;
                IInfoProvider monitor = (IInfoProvider)info;
                InfoRenderer.renderMonitorInfoInGUI(new MonitoredBlockCoords(monitor.getCoords(), monitor.getDisplayName()), yPos + 1, LogisticsColours.white_text.getRGB());
                break;
            }
            case LIST: {
                Pair<String, String> infoStrings;
                if (!(info instanceof EmitterStatement)) break;
                EmitterStatement statement = (EmitterStatement)info;
                String infoType1 = "INFO";
                String infoType2 = "INFO";
                String infoObj1 = "NULL";
                String infoObj2 = "NULL";
                if (statement.uuid1.getObject() != null) {
                    infoStrings = this.getInfoTypeAndObjectStrings((InfoUUID)statement.uuid1.getObject(), (String)statement.key1.getObject());
                    infoType1 = (String)infoStrings.a;
                    infoObj1 = (String)infoStrings.b;
                }
                if (statement.getInputType().usesInfo()) {
                    if (statement.uuid2.getObject() != null) {
                        infoStrings = this.getInfoTypeAndObjectStrings((InfoUUID)statement.uuid2.getObject(), (String)statement.key2.getObject());
                        infoType2 = (String)infoStrings.a;
                        infoObj2 = (String)infoStrings.b;
                    }
                } else {
                    if (statement.getInputType() != null) {
                        infoType2 = statement.getInputType().name();
                    }
                    if (statement.obj.get() != null) {
                        infoObj2 = statement.obj.get().toString();
                    }
                }
                FontHelper.text((String)(infoType1 + ": " + TextFormatting.WHITE + TextFormatting.ITALIC + infoObj1 + " " + TextFormatting.DARK_AQUA + ((LogicOperator)statement.operator.getObject()).operation + TextFormatting.RESET + " " + infoType2 + ": " + TextFormatting.WHITE + TextFormatting.ITALIC + infoObj2), (int)InfoRenderer.identifierLeft, (int)yPos, (int)LogisticsColours.white_text.getRGB());
                FontHelper.text((String)("Current State: " + ((Boolean)statement.wasTrue.getObject() != false ? TextFormatting.GREEN : TextFormatting.RED) + statement.wasTrue.getObject()), (int)InfoRenderer.identifierLeft, (int)(yPos + 14), (int)LogisticsColours.white_text.getRGB());
                break;
            }
            case STATEMENT: {
                break;
            }
            case STRING: {
                if (!(info instanceof ComparableObject)) break;
                ComparableObject comparable = (ComparableObject)info;
                FontHelper.text((String)comparable.string, (int)InfoRenderer.identifierLeft, (int)yPos, (int)LogisticsColours.white_text.getRGB());
                if (comparable.object != null) {
                    if (comparable.object instanceof Item) {
                        FontHelper.text((String)((MonitoredItemStack)comparable.source).getItemStack().func_82833_r(), (int)InfoRenderer.objectLeft, (int)yPos, (int)LogisticsColours.white_text.getRGB());
                    } else {
                        FontHelper.text((String)comparable.object.toString(), (int)InfoRenderer.objectLeft, (int)yPos, (int)LogisticsColours.white_text.getRGB());
                    }
                    FontHelper.text((String)ObjectType.getInfoType((Object)comparable.object).toString().toLowerCase(), (int)InfoRenderer.kindLeft, (int)yPos, (int)LogisticsColours.white_text.getRGB());
                    break;
                }
                FontHelper.text((String)"ERROR", (int)InfoRenderer.objectLeft, (int)yPos, (int)LogisticsColours.white_text.getRGB());
                break;
            }
        }
    }

    public Pair<String, String> getInfoTypeAndObjectStrings(InfoUUID id, String key) {
        List<ComparableObject> infoList;
        ComparableObject obj;
        String infoType = "INFO";
        String infoObj = "NULL";
        IInfo monitorInfo = PL2.getClientManager().info.get(id);
        if (monitorInfo instanceof INameableInfo) {
            infoType = ((INameableInfo)monitorInfo).getClientIdentifier();
        } else {
            String string = infoType = monitorInfo != null ? monitorInfo.toString() : "INFO 1";
        }
        if (monitorInfo instanceof IComparableInfo && key != null && (obj = ComparableObject.getComparableObject(infoList = ((IComparableInfo)monitorInfo).getComparableObjects(Lists.newArrayList()), key)) != null && obj.object != null) {
            infoObj = obj.object.toString();
        }
        return new Pair((Object)infoType, (Object)infoObj);
    }

    @Override
    public void selectionPressed(GuiButton button, int pos, int buttonID, Object info) {
        switch (this.state) {
            case LIST: {
                if (!(info instanceof EmitterStatement)) break;
                EmitterStatement statement = (EmitterStatement)info;
                if (buttonID == 1) {
                    this.currentFilter = statement;
                    this.lastFilter = statement;
                    this.changeState(GuiState.STATEMENT);
                    break;
                }
                this.currentFilter = info != this.currentFilter ? statement : null;
                break;
            }
            case STATEMENT: {
                break;
            }
            case CHANNELS: {
                if (buttonID == 0 && info instanceof InfoUUID) {
                    if (this.infoPos == 0) {
                        this.currentFilter.uuid1.setObject((INBTSyncable)((InfoUUID)info));
                        break;
                    }
                    this.currentFilter.uuid2.setObject((INBTSyncable)((InfoUUID)info));
                    break;
                }
                if (!(info instanceof INetworkReader)) break;
                RenderBlockSelection.addPosition(((INetworkReader)info).getCoords(), false);
                break;
            }
            case STRING: {
                if (!(info instanceof ComparableObject)) break;
                ComparableObject obj = (ComparableObject)info;
                (this.infoPos == 0 ? this.currentFilter.key1 : this.currentFilter.key2).setObject((Object)obj.string);
                break;
            }
        }
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        if (this.coolDown != 0) {
            return;
        }
        super.func_73864_a(x, y, button);
    }

    @Override
    public void setInfo() {
        switch (this.state) {
            case LIST: {
                this.infoList = Lists.newArrayList((Iterable)this.tile.getStatements().getObjects());
                break;
            }
            case STATEMENT: {
                break;
            }
            case CHANNELS: {
                this.infoList = Lists.newArrayList((Iterable)PL2.getClientManager().sortedLogicMonitors.getOrDefault(this.tile.getIdentity(), Lists.newArrayList()));
                break;
            }
            case STRING: {
                IInfo monitorInfo;
                InfoUUID uuid = (InfoUUID)(this.infoPos == 0 ? this.currentFilter.uuid1.getObject() : this.currentFilter.uuid2.getObject());
                if (uuid != null && (monitorInfo = PL2.getClientManager().info.get(uuid)) != null && monitorInfo instanceof IComparableInfo) {
                    IComparableInfo comparable = (IComparableInfo)monitorInfo;
                    ArrayList<ComparableObject> objects = new ArrayList<ComparableObject>();
                    comparable.getComparableObjects(objects);
                    this.infoList = objects;
                    break;
                }
                this.infoList = Lists.newArrayList();
                break;
            }
        }
    }

    public void onTextFieldChanged(SonarTextField field) {
        super.onTextFieldChanged(field);
        if (field == this.inputField) {
            switch (this.currentFilter.getInputType()) {
                case INFO: {
                    break;
                }
                case NUMBER: {
                    this.currentFilter.obj.set((Object)(field.func_146179_b().isEmpty() ? 0.0 : Double.valueOf(field.func_146179_b())), ObjectType.DOUBLE);
                    break;
                }
                case STRING: {
                    this.currentFilter.obj.set((Object)field.func_146179_b(), ObjectType.STRING);
                    break;
                }
            }
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.getFocusedField() == null && this.state != GuiState.LIST && (i == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(i))) {
            if (this.state == GuiState.CHANNELS || this.state == GuiState.STRING) {
                this.changeState(GuiState.STATEMENT);
                return;
            }
            this.changeState(GuiState.LIST);
            return;
        }
        super.func_73869_a(c, i);
    }

    public static enum GuiState {
        LIST(true),
        STATEMENT(false),
        CHANNELS(true),
        STRING(true);

        boolean hasScroller;

        private GuiState(boolean hasScroller) {
            this.hasScroller = hasScroller;
        }
    }
}

