/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.containers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import sonar.core.api.IFlexibleContainer;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.InventoryHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.inventory.slots.SlotList;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.tiles.readers.InventoryReader;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.common.multiparts.readers.InventoryReaderPart;
import sonar.logistics.connections.channels.ItemNetworkChannels;

public class ContainerInventoryReader
extends ContainerMultipartSync
implements IFlexibleContainer<InventoryReader.Modes> {
    private static final int INV_START = 1;
    private static final int INV_END = 27;
    private static final int HOTBAR_START = 28;
    private static final int HOTBAR_END = 36;
    public boolean stackMode = false;
    public ItemStack lastStack = null;
    public InventoryReaderPart part;
    public EntityPlayer player;

    public ContainerInventoryReader(InventoryReaderPart part, EntityPlayer player) {
        super((SonarMultipart)part);
        this.part = part;
        this.player = player;
        this.refreshState();
    }

    public void refreshState() {
        int i;
        InventoryReader.Modes state = this.getCurrentState();
        this.stackMode = state == InventoryReader.Modes.STACK;
        this.field_75153_a.clear();
        this.field_75151_b.clear();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, j + i * 9 + 9, 41 + j * 18, 174 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, i, 41 + i * 18, 232));
        }
        if (this.stackMode) {
            this.func_75146_a((Slot)new SlotList((IInventory)this.part.inventory, 0, 63, 9));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int id) {
        ItemStack itemstack = InventoryHelper.EMPTY;
        Slot slot = (Slot)this.field_75151_b.get(id);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (id < 36) {
                if (!this.part.getWorld().field_72995_K) {
                    ILogisticsNetwork network = this.part.getNetwork();
                    StoredItemStack stack = new StoredItemStack(itemstack1);
                    if (this.lastStack != null && ItemStack.func_77970_a((ItemStack)itemstack1, (ItemStack)this.lastStack) && this.lastStack.func_77969_a(itemstack1)) {
                        PL2API.getItemHelper().addItemsFromPlayer(stack, player, network, ActionType.PERFORM);
                    } else {
                        StoredItemStack perform = PL2API.getItemHelper().transferItems(network, stack, NodeTransferMode.ADD, ActionType.PERFORM, null);
                        this.lastStack = itemstack1;
                        itemstack1.field_77994_a = (int)(perform == null || perform.stored == 0L ? 0L : perform.getStackSize());
                        player.field_71071_by.func_70296_d();
                    }
                    ItemNetworkChannels channels = network.getNetworkChannels(ItemNetworkChannels.class);
                    if (channels != null) {
                        channels.sendLocalRapidUpdate(this.part, player);
                    }
                    this.func_75142_b();
                }
            } else if (id < 27 ? !this.func_75135_a(itemstack1, 27, 36, false) : (id >= 27 && id < 36 ? !this.func_75135_a(itemstack1, 0, 27, false) : !this.func_75135_a(itemstack1, 0, 36, false))) {
                return InventoryHelper.EMPTY;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(InventoryHelper.EMPTY);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return InventoryHelper.EMPTY;
            }
            slot.func_82870_a(player, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.func_130014_f_().field_72995_K) {
            this.part.getListenerList().removeListener(player, true, new Enum[]{ListenerType.INFO});
        }
    }

    public ItemStack func_184996_a(int slotID, int drag, ClickType click, EntityPlayer player) {
        if (slotID < this.field_75151_b.size()) {
            Slot targetSlot;
            Slot slot = targetSlot = slotID < 0 ? null : (Slot)this.field_75151_b.get(slotID);
            if (targetSlot instanceof SlotList) {
                targetSlot.func_75215_d(drag == 2 ? null : (player.field_71071_by.func_70445_o() == null ? null : player.field_71071_by.func_70445_o().func_77946_l()));
                return player.field_71071_by.func_70445_o();
            }
            return super.func_184996_a(slotID, drag, click, player);
        }
        return null;
    }

    public InventoryReader.Modes getCurrentState() {
        return (InventoryReader.Modes)this.part.setting.getObject();
    }
}

