/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.hammer;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.core.SonarCore;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.inventory.SonarInventory;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.utils.IGuiTile;
import sonar.logistics.client.gui.GuiHammer;
import sonar.logistics.common.containers.ContainerHammer;
import sonar.logistics.common.hammer.HammerRecipes;

public class TileEntityHammer
extends TileEntityInventory
implements ISidedInventory,
IByteBufTile,
IGuiTile {
    public SyncTagType.INT progress = new SyncTagType.INT(0);
    public SyncTagType.INT coolDown = new SyncTagType.INT(1);
    public static int speed = 100;

    public TileEntityHammer() {
        this.inv = new SonarInventory((TileEntity)this, 2);
        this.syncList.addParts(new IDirtyPart[]{this.progress, this.coolDown, this.inv});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().func_175687_A(this.field_174879_c) == 15) {
            return;
        }
        if ((Integer)this.coolDown.getObject() != 0) {
            this.coolDown.increaseBy(-1);
        } else if (this.canProcess()) {
            if ((Integer)this.progress.getObject() < speed) {
                if ((Integer)this.progress.getObject() == 0) {
                    SonarCore.sendPacketAround((TileEntity)this, (int)64, (int)2);
                }
                this.progress.increaseBy(1);
            } else {
                this.coolDown.setObject((Object)(speed * 2));
                this.progress.setObject((Object)0);
                if (!this.func_145831_w().field_72995_K) {
                    this.finishProcess();
                    SonarCore.sendPacketAround((TileEntity)this, (int)64, (int)2);
                }
            }
        } else if ((Integer)this.progress.getObject() != 0) {
            this.progress.setObject((Object)0);
        }
    }

    public boolean canProcess() {
        if (this.slots()[0] == null) {
            return false;
        }
        ISonarRecipe recipe = HammerRecipes.instance().getRecipeFromInputs(null, new Object[]{this.slots()[0]});
        if (recipe == null) {
            return false;
        }
        ItemStack outputStack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)0);
        if (outputStack == null) {
            return false;
        }
        if (this.slots()[1] != null) {
            if (!this.slots()[1].func_77969_a(outputStack)) {
                return false;
            }
            if (this.slots()[1].field_77994_a + outputStack.field_77994_a > this.slots()[1].func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    public void finishProcess() {
        ISonarRecipe recipe = HammerRecipes.instance().getRecipeFromInputs(null, new Object[]{this.slots()[0]});
        if (recipe == null) {
            return;
        }
        ItemStack outputStack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)0);
        if (outputStack != null && outputStack != null) {
            if (this.slots()[1] == null) {
                this.slots()[1] = outputStack.func_77946_l();
            } else if (this.slots()[1].func_77969_a(outputStack)) {
                this.slots()[1].field_77994_a += outputStack.field_77994_a;
            }
            this.slots()[0].field_77994_a -= ((ISonarRecipeObject)recipe.inputs().get(0)).getStackSize();
            if (this.slots()[0].field_77994_a <= 0) {
                this.slots()[0] = null;
            }
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && HammerRecipes.instance().isValidInput(stack);
    }

    public boolean maxRender() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slot, ItemStack item, EnumFacing side) {
        return slot == 0;
    }

    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return slot == 1;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        super.func_70299_a(i, itemstack);
        if (i == 1) {
            this.markBlockForUpdate();
            SonarCore.sendFullSyncAround((TileEntity)this, (int)64);
        }
    }

    public int getSpeed() {
        return speed;
    }

    public int getProgress() {
        return (Integer)this.progress.getObject();
    }

    public int getCoolDown() {
        return (Integer)this.coolDown.getObject();
    }

    public int getCoolDownSpeed() {
        return speed * 2;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.progress.writeToBuf(buf);
                break;
            }
            case 1: {
                this.coolDown.writeToBuf(buf);
                break;
            }
            case 2: {
                this.inv.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.progress.readFromBuf(buf);
                break;
            }
            case 1: {
                this.coolDown.readFromBuf(buf);
                break;
            }
            case 2: {
                this.inv.readFromBuf(buf);
            }
        }
    }

    public Object getGuiContainer(EntityPlayer player) {
        return new ContainerHammer(player, this);
    }

    public Object getGuiScreen(EntityPlayer player) {
        return new GuiHammer(player, this);
    }
}

