/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.items;

import java.util.List;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.logistics.PL2;
import sonar.logistics.api.operator.IOperatorTile;
import sonar.logistics.api.operator.IOperatorTool;
import sonar.logistics.api.operator.OperatorMode;
import sonar.logistics.api.tiles.IChannelledTile;
import sonar.logistics.client.gui.generic.GuiChannelSelection;
import sonar.logistics.common.containers.ContainerChannelSelection;

public class ItemOperator
extends SonarItem
implements IOperatorTool,
IFlexibleGui<ItemStack> {
    @Override
    public OperatorMode getOperatorMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return OperatorMode.values()[stack.func_77978_p().func_74762_e("mode")];
        }
        return OperatorMode.DEFAULT;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
        if (container != null) {
            Vec3d end;
            Vec3d start = RayTraceUtils.getStart((EntityPlayer)player);
            RayTraceUtils.AdvancedRayTraceResultPart result = SonarMultipartHelper.collisionRayTrace((IMultipartContainer)container, (Vec3d)start, (Vec3d)(end = RayTraceUtils.getEnd((EntityPlayer)player)));
            if (result == null) {
                return EnumActionResult.PASS;
            }
            IMultipart part = ((PartMOP)result.hit).partHit;
            OperatorMode mode = this.getOperatorMode(stack);
            switch (mode) {
                case ANALYSE: {
                    break;
                }
                case DEFAULT: {
                    if (player.func_70093_af() || part == null || !(part instanceof IOperatorTile)) break;
                    boolean operation = ((IOperatorTile)part).performOperation(result, mode, player, hand, facing, hitX, hitY, hitZ);
                    return operation ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
                }
                case CHANNELS: {
                    if (part == null || !(part instanceof IChannelledTile)) break;
                    if (!world.field_72995_K) {
                        IChannelledTile tile = (IChannelledTile)part;
                        tile.getNetwork().sendConnectionsPacket(player);
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74757_a(FlexibleGuiHandler.ITEM, true);
                        tag.func_74768_a(FlexibleGuiHandler.ID, 0);
                        tag.func_74768_a("hash", tile.getIdentity());
                        tag.func_74768_a("x", tile.getCoords().getX());
                        tag.func_74768_a("y", tile.getCoords().getY());
                        tag.func_74768_a("z", tile.getCoords().getZ());
                        SonarCore.instance.guiHandler.openGui(false, player, world, pos, 0, tag);
                    }
                    return EnumActionResult.SUCCESS;
                }
                case INFO: {
                    break;
                }
                case ROTATE: {
                    return part != null && part.rotatePart(facing) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        OperatorMode mode;
        if (player.func_70093_af()) {
            stack = this.changeOperatorMode(stack);
            FontHelper.sendMessage((String)("Mode: " + (Object)((Object)this.getOperatorMode(stack))), (World)world, (EntityPlayer)player);
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (world.field_72995_K && (mode = this.getOperatorMode(stack)) == OperatorMode.INFO) {
            boolean isUsing = !PL2.proxy.isUsingOperator();
            PL2.proxy.setUsingOperator(isUsing);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("Display Info: " + TextFormatting.AQUA + isUsing, new Object[0]));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public ItemStack changeOperatorMode(ItemStack stack) {
        OperatorMode mode = (OperatorMode)SonarHelper.incrementEnum((Enum)this.getOperatorMode(stack), (Enum[])OperatorMode.values());
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        tag.func_74768_a("mode", mode.ordinal());
        stack.func_77982_d(tag);
        boolean isUsing = mode == OperatorMode.INFO;
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        list.add("Mode: " + (Object)((Object)this.getOperatorMode(stack)));
    }

    public Object getServerElement(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                int hash = tag.func_74762_e("hash");
                BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
                for (IMultipart part : container.getParts()) {
                    IChannelledTile tile;
                    if (part == null || !(part instanceof IChannelledTile) || (tile = (IChannelledTile)part).getIdentity() != hash) continue;
                    return new ContainerChannelSelection(tile);
                }
                break;
            }
        }
        return null;
    }

    public Object getClientElement(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                int hash = tag.func_74762_e("hash");
                BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, (BlockPos)pos);
                for (IMultipart part : container.getParts()) {
                    IChannelledTile tile;
                    if (part == null || !(part instanceof IChannelledTile) || (tile = (IChannelledTile)part).getIdentity() != hash) continue;
                    return new GuiChannelSelection(player, tile, 0);
                }
                break;
            }
        }
        return null;
    }

    public void onGuiOpened(ItemStack obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
    }
}

