/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.utils.BlockCoords;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.operator.IOperatorTile;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.cable.NetworkConnectionType;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.tiles.readers.INetworkReader;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.client.gui.GuiDisplayScreen;
import sonar.logistics.common.multiparts.LogisticsPart;
import sonar.logistics.helpers.LogisticsHelper;
import sonar.logistics.helpers.PacketHelper;

public abstract class AbstractDisplayPart
extends LogisticsPart
implements IByteBufTile,
INormallyOccludingPart,
IDisplay,
IOperatorTile,
IFlexibleGui<AbstractDisplayPart> {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK, TileMessage.NO_READER_SELECTED};
    public SyncTagType.BOOLEAN defaultData = new SyncTagType.BOOLEAN(2);
    public INetworkReader monitor = null;
    public EnumFacing rotation;
    public EnumFacing face;
    public BlockCoords lastSelected = null;
    public int currentSelected = -1;

    public AbstractDisplayPart() {
        this.syncList.addPart((IDirtyPart)this.defaultData);
    }

    public AbstractDisplayPart(EnumFacing face, EnumFacing rotation) {
        this.syncList.addPart((IDirtyPart)this.defaultData);
        this.rotation = rotation;
        this.face = face;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        if (this.canOpenGui(player) && this.isServer()) {
            if (hit.field_178784_b != this.face) {
                this.openFlexibleGui(player, 0);
            } else {
                return this.container().onClicked(this, player.func_70093_af() ? BlockInteractionType.SHIFT_RIGHT : BlockInteractionType.RIGHT, this.getWorld(), player, hand, stack, hit);
            }
        }
        return false;
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.updateDefaultInfo();
    }

    public void updateDefaultInfo() {
        ILogicListenable v;
        List<ILogicListenable> providers;
        if (this.isServer() && !((Boolean)this.defaultData.getObject()).booleanValue() && !(providers = LogisticsHelper.getLocalProviders(Lists.newArrayList(), this)).isEmpty() && (v = providers.get(0)) instanceof IInfoProvider) {
            IInfoProvider monitor = (IInfoProvider)v;
            if (this.container() != null && monitor != null && monitor.getIdentity() != -1) {
                for (int i = 0; i < Math.min(monitor.getMaxInfo(), this.maxInfo()); ++i) {
                    if (this.container().getInfoUUID(i) != null || !this.container().getDisplayInfo((int)i).formatList.getObjects().isEmpty()) continue;
                    this.container().setUUID(new InfoUUID(monitor.getIdentity(), i), i);
                }
                this.defaultData.setObject((Object)true);
                this.sendSyncPacket();
            }
        }
    }

    public abstract void incrementLayout();

    @Override
    public NetworkConnectionType canConnect(EnumFacing dir) {
        return dir != this.face ? NetworkConnectionType.NETWORK : NetworkConnectionType.NONE;
    }

    @Override
    public EnumFacing getCableFace() {
        return this.face;
    }

    @Override
    public EnumFacing getRotation() {
        return this.rotation;
    }

    @Override
    public void validate() {
        super.validate();
        PL2.getInfoManager(this.isClient()).addDisplay(this);
        if (this.isClient()) {
            this.requestSyncPacket();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        PL2.getInfoManager(this.isClient()).removeDisplay(this);
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        this.addSelectionBoxes(list);
    }

    public void harvest(EntityPlayer player, PartMOP hit) {
        if (hit.field_178784_b == this.face) {
            this.container().onClicked(this, player.func_70093_af() ? BlockInteractionType.SHIFT_LEFT : BlockInteractionType.LEFT, this.getWorld(), player, player.func_184600_cs(), player.func_184607_cu(), hit);
            return;
        }
        super.harvest(player, hit);
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)PL2Properties.ORIENTATION, (Comparable)this.face).func_177226_a((IProperty)PL2Properties.ROTATION, (Comparable)this.rotation);
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PL2Properties.ORIENTATION, PL2Properties.ROTATION});
    }

    public NBTTagCompound writeData(NBTTagCompound tag, NBTHelper.SyncType type) {
        super.writeData(tag, type);
        tag.func_74774_a("rotation", (byte)this.rotation.ordinal());
        tag.func_74774_a("face", (byte)this.face.ordinal());
        return tag;
    }

    public void readData(NBTTagCompound tag, NBTHelper.SyncType type) {
        super.readData(tag, type);
        this.rotation = EnumFacing.field_82609_l[tag.func_74771_c("rotation")];
        this.face = EnumFacing.field_82609_l[tag.func_74771_c("face")];
    }

    public void markChanged(IDirtyPart part) {
        super.markChanged(part);
        List viewers = this.getListenerList().getListeners(new Enum[]{ListenerType.INFO});
        for (PlayerListener listener : viewers) {
            SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)listener.player);
        }
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        buf.writeByte((int)((byte)this.rotation.ordinal()));
        buf.writeByte((int)((byte)this.face.ordinal()));
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                buf.writeInt(this.currentSelected);
                this.container().getInfoUUID(this.currentSelected).writeToBuf(buf);
                break;
            }
            case 1: {
                buf.writeInt(this.currentSelected);
                this.container().getDisplayInfo((int)this.currentSelected).formatList.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.currentSelected = buf.readInt();
                InfoUUID uuid = InfoUUID.getUUID(buf);
                this.container().setUUID(uuid, this.currentSelected);
                if (!this.isServer()) break;
                PL2.getServerManager().updateViewingMonitors = true;
                this.sendSyncPacket();
                break;
            }
            case 1: {
                this.currentSelected = buf.readInt();
                this.container().getDisplayInfo((int)this.currentSelected).formatList.readFromBuf(buf);
                this.sendSyncPacket();
                break;
            }
            case 2: {
                this.incrementLayout();
            }
        }
    }

    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        this.rotation = EnumFacing.field_82609_l[buf.readByte()];
        this.face = EnumFacing.field_82609_l[buf.readByte()];
    }

    public PartMOP getPartHit(EntityPlayer player) {
        Vec3d end;
        Vec3d start = RayTraceUtils.getStart((EntityPlayer)player);
        RayTraceUtils.AdvancedRayTraceResultPart result = this.collisionRayTrace(start, end = RayTraceUtils.getEnd((EntityPlayer)player));
        return result == null ? null : (PartMOP)result.hit;
    }

    public Object getServerElement(AbstractDisplayPart obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerMultipartSync((SonarMultipart)obj) : null;
    }

    public Object getClientElement(AbstractDisplayPart obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiDisplayScreen(obj) : null;
    }

    public void onGuiOpened(AbstractDisplayPart obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                PacketHelper.sendLocalProvidersFromScreen(this, player);
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public String getDisplayName() {
        return PL2Translate.DISPLAY_SCREEN.t();
    }
}

