/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IMultipart;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUUID;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.networks.INetworkListHandler;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.readers.ChannelList;
import sonar.logistics.api.tiles.readers.INetworkReader;
import sonar.logistics.api.utils.ChannelType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.common.multiparts.SidedPart;
import sonar.logistics.info.types.MonitoredBlockCoords;
import sonar.logistics.info.types.MonitoredEntity;
import sonar.logistics.network.sync.SyncMonitoredType;

public abstract class AbstractReaderPart<T extends IInfo>
extends SidedPart
implements INetworkReader<T>,
IByteBufTile,
IFlexibleGui {
    public static final int ADD = -9;
    public static final int PAIRED = -10;
    public static final int ALL = 100;
    public static final PropertyBool hasDisplay = PropertyBool.func_177716_a((String)"display");
    public final ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, ListenerType.ALL.size());
    public final ChannelList list = new ChannelList(this.getIdentity(), this.channelType(), -2);
    protected List<INetworkListHandler> validHandlers = null;
    public SyncMonitoredType<T> selectedInfo = new SyncMonitoredType(-5);
    public SyncTagType.BOOLEAN hasMonitor = new SyncTagType.BOOLEAN(-4);
    public int lastPos = -1;
    public SyncUUID lastSelectedUUID = new SyncUUID(-10);
    public SyncCoords lastSelected = new SyncCoords(-11);

    public AbstractReaderPart() {
        this.syncList.addParts(new IDirtyPart[]{this.list, this.hasMonitor});
    }

    public abstract List<INetworkListHandler> addValidHandlers(List<INetworkListHandler> var1);

    @Override
    public MonitoredList<T> getUpdatedList(InfoUUID uuid, Map<NodeConnection, MonitoredList<T>> channels, List<NodeConnection> usedChannels) {
        MonitoredList updateList = MonitoredList.newMonitoredList(this.getNetworkID());
        ChannelList readerChannels = this.getChannels();
        for (Map.Entry<NodeConnection, MonitoredList<T>> entry : channels.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty() || !readerChannels.isMonitored(entry.getKey())) continue;
            for (IInfo coordInfo : entry.getValue()) {
                if (!this.canMonitorInfo(coordInfo, uuid, channels, usedChannels)) continue;
                updateList.addInfoToList(coordInfo.copy(), entry.getValue());
            }
            updateList.sizing.add(entry.getValue().sizing);
            usedChannels.add(entry.getKey());
            if (this.channelType() != ChannelType.SINGLE) continue;
            break;
        }
        return updateList;
    }

    public boolean canMonitorInfo(T info, InfoUUID uuid, Map<NodeConnection, MonitoredList<T>> channels, List<NodeConnection> usedChannels) {
        return true;
    }

    @Override
    public List<INetworkListHandler> getValidHandlers() {
        if (this.validHandlers == null) {
            this.validHandlers = this.addValidHandlers(Lists.newArrayList());
        }
        return this.validHandlers;
    }

    public MonitoredList<T> getMonitoredList() {
        InfoUUID id = new InfoUUID(this.getIdentity(), 0);
        return this.getNetworkID() == -1 ? MonitoredList.newMonitoredList(this.getNetworkID()) : PL2.getClientManager().getMonitoredList(this.getNetworkID(), id);
    }

    @Override
    public int getMaxInfo() {
        return 4;
    }

    @Override
    public ChannelList getChannels() {
        return this.list;
    }

    @Override
    public void sendCoordsToServer(IInfo info, int channelID) {
        if (info instanceof MonitoredBlockCoords) {
            this.lastSelected.setCoords(((MonitoredBlockCoords)info).getCoords());
            this.sendByteBufPacket(-3);
        }
        if (info instanceof MonitoredEntity) {
            this.lastSelectedUUID.setObject(((MonitoredEntity)info).getUUID());
            this.sendByteBufPacket(-4);
        }
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    @Override
    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
        SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((PlayerListener)tally.listener).player);
    }

    @Override
    public void addInfo(List<String> info) {
        super.addInfo(info);
        info.add("Channels Configured: " + !this.list.hasChannels());
        info.add("Max Info: " + this.getMaxInfo());
    }

    @Override
    public void validate() {
        super.validate();
        if (this.isServer()) {
            this.hasMonitor.setObject((Object)(PL2API.getCableHelper().getDisplayScreen(this.getCoords(), this.getCableFace()) != null ? 1 : 0));
        }
    }

    @Override
    public boolean rotatePart(EnumFacing axis) {
        if (super.rotatePart(axis)) {
            this.hasMonitor.setObject((Object)(PL2API.getCableHelper().getDisplayScreen(this.getCoords(), this.getCableFace()) != null ? 1 : 0));
            this.sendUpdatePacket(true);
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)PL2Properties.ORIENTATION, (Comparable)this.getCableFace()).func_177226_a((IProperty)hasDisplay, (Comparable)this.hasMonitor.getObject());
    }

    @Override
    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PL2Properties.ORIENTATION, hasDisplay});
    }

    public void onPartChanged(IMultipart changedPart) {
        if (!this.getWorld().field_72995_K && changedPart instanceof AbstractDisplayPart) {
            AbstractDisplayPart screen = (AbstractDisplayPart)changedPart;
            if (screen.face == this.getCableFace()) {
                this.hasMonitor.setObject((Object)(!screen.wasRemoved() ? 1 : 0));
                this.sendUpdatePacket(true);
            }
        }
    }

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        this.hasMonitor.writeToBuf((ByteBuf)buf);
    }

    @Override
    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        this.hasMonitor.readFromBuf((ByteBuf)buf);
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -4: {
                this.lastSelectedUUID.writeToBuf(buf);
                break;
            }
            case -3: {
                this.lastSelected.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -4: {
                this.lastSelectedUUID.readFromBuf(buf);
                this.list.give(this.lastSelectedUUID.getUUID());
                this.sendByteBufPacket(1);
                break;
            }
            case -3: {
                this.lastSelected.readFromBuf(buf);
                this.list.give(this.lastSelected.getCoords());
                this.sendByteBufPacket(1);
            }
        }
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 1: {
                this.getNetwork().sendConnectionsPacket(player);
            }
        }
    }
}

