/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts;

import com.google.common.collect.Lists;
import java.util.List;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.PL2;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.networks.EmptyLogisticsNetwork;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkListener;
import sonar.logistics.api.operator.IOperatorProvider;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.INetworkTile;
import sonar.logistics.api.tiles.cable.IDataCable;
import sonar.logistics.api.utils.CacheType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.common.multiparts.readers.InfoReaderPart;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.helpers.LogisticsHelper;
import sonar.logistics.network.PacketChannels;
import sonar.logistics.network.sync.SyncTileMessages;

public abstract class LogisticsPart
extends SonarMultipart
implements INetworkTile,
INetworkListener,
IOperatorProvider {
    public static final TileMessage[] defaultValidStates = new TileMessage[]{TileMessage.NO_NETWORK};
    public ILogisticsNetwork network = EmptyLogisticsNetwork.INSTANCE;
    public SyncTagType.INT identity = (SyncTagType.INT)new SyncTagType.INT(100).setDefault((Object)-1);
    public SyncTileMessages states = new SyncTileMessages(this, 101);
    public SyncTagType.INT networkID = (SyncTagType.INT)new SyncTagType.INT(0).setDefault((Object)-1);

    public LogisticsPart() {
        this.syncList.addParts(new IDirtyPart[]{this.networkID, this.identity, this.states});
        this.states.markAllMessages(true);
    }

    public LogisticsPart(AxisAlignedBB collisionBox) {
        super(collisionBox);
        this.syncList.addParts(new IDirtyPart[]{this.networkID, this.identity, this.states});
        this.states.markAllMessages(true);
    }

    public abstract EnumFacing getCableFace();

    public abstract PL2Multiparts getMultipart();

    public ItemStack getItemStack() {
        return this.getMultipart().getItem();
    }

    public String getDisplayName() {
        return this.getMultipart().getDisplayName();
    }

    public void sendNetworkCoordMap(EntityPlayer player) {
        if (this.isClient() || !this.network.isValid() || this.getNetworkID() == -1) {
            return;
        }
        MonitoredList<IInfo> coords = this.network.createConnectionsList(CacheType.ALL);
        NBTTagCompound coordTag = InfoHelper.writeMonitoredList(new NBTTagCompound(), coords.isEmpty(), coords.copyInfo(), NBTHelper.SyncType.DEFAULT_SYNC);
        if (!coordTag.func_82582_d()) {
            PL2.network.sendTo((IMessage)new PacketChannels(this.getNetworkID(), coordTag), (EntityPlayerMP)player);
        }
    }

    public boolean hasStandardGui() {
        return false;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, PartMOP hit) {
        if (this.hasStandardGui() && this.canOpenGui(player)) {
            if (this.isServer()) {
                this.openFlexibleGui(player, 0);
            }
            return true;
        }
        return false;
    }

    public boolean canOpenGui(EntityPlayer player) {
        return !LogisticsHelper.isPlayerUsingOperator(player);
    }

    @Override
    public int getIdentity() {
        if ((Integer)this.identity.getObject() == -1 || (Integer)this.identity.getObject() == 0) {
            this.identity.setObject((Object)this.getUUID().hashCode());
        }
        return (Integer)this.identity.getObject();
    }

    public void validate() {
        IDataCable cable;
        super.validate();
        if (!this.getWorld().field_72995_K && (cable = PL2API.getCableHelper().getCableFromCoords(this.getCoords())) != null) {
            cable.onConnectionAdded(this, this.getCableFace());
        }
        if (this instanceof ILogicListenable) {
            PL2.getInfoManager(this.getWorld().field_72995_K).addIdentityTile((ILogicListenable)((Object)this));
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this instanceof ILogicListenable) {
            PL2.getInfoManager(this.getWorld().field_72995_K).removeIdentityTile((ILogicListenable)((Object)this));
        }
    }

    public void onRemoved() {
        super.onRemoved();
        this.onUnloaded();
    }

    public void onUnloaded() {
        IDataCable cable;
        super.onUnloaded();
        if (!this.getWorld().field_72995_K && (cable = PL2API.getCableHelper().getCableFromCoords(this.getCoords())) != null) {
            cable.onConnectionRemoved(this, this.getCableFace());
        }
    }

    public boolean isValid() {
        return !this.wasRemoved;
    }

    @Override
    public void onNetworkConnect(ILogisticsNetwork network) {
        if (!this.network.isValid() || ((Integer)this.networkID.getObject()).intValue() != network.getNetworkID()) {
            this.network = network;
            this.networkID.setObject((Object)network.getNetworkID());
            this.states.markTileMessage(TileMessage.NO_NETWORK, false);
        }
    }

    @Override
    public void onNetworkDisconnect(ILogisticsNetwork network) {
        if (((Integer)this.networkID.getObject()).intValue() == network.getNetworkID()) {
            this.network = EmptyLogisticsNetwork.INSTANCE;
            this.networkID.setObject((Object)-1);
            this.states.markTileMessage(TileMessage.NO_NETWORK, true);
        } else {
            PL2.logger.info("%s : attempted to disconnect from the wrong network with ID: %s expected %s", new Object[]{this, network.getNetworkID(), this.networkID.getObject()});
        }
    }

    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
    }

    public void onListenerRemoved(ListenerTally<PlayerListener> tally) {
    }

    public void onSubListenableAdded(ISonarListenable<PlayerListener> listen) {
    }

    public void onSubListenableRemoved(ISonarListenable<PlayerListener> listen) {
    }

    @Override
    public ILogisticsNetwork getNetwork() {
        return this.network;
    }

    @Override
    public int getNetworkID() {
        return (Integer)this.networkID.getObject();
    }

    @Override
    public void updateOperatorInfo() {
        this.requestSyncPacket();
    }

    @Override
    public void addInfo(List<String> info) {
        info.add(TextFormatting.UNDERLINE + this.getMultipart().getDisplayName());
        info.add("Network ID: " + this.networkID.getObject());
        info.add("Has channels: " + (this instanceof InfoReaderPart));
        info.add("IDENTITY: " + this.getIdentity());
    }

    public List<ItemStack> getDrops() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.getItemStack()});
    }

    @Override
    public TileMessage[] getValidMessages() {
        return defaultValidStates;
    }
}

