/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.network.sync.SyncEnum;
import sonar.core.utils.Pair;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.tiles.cable.NetworkConnectionType;
import sonar.logistics.common.multiparts.LogisticsPart;

public abstract class SidedPart
extends LogisticsPart
implements ISlottedPart {
    public SyncEnum<EnumFacing> face = new SyncEnum((Enum[])EnumFacing.values(), -1);

    public SidedPart() {
        this.syncList.addPart(this.face);
    }

    public SidedPart setCableFace(EnumFacing face) {
        this.face.setObject((Enum)face);
        return this;
    }

    @Override
    public EnumFacing getCableFace() {
        return (EnumFacing)this.face.getObject();
    }

    @Override
    public NetworkConnectionType canConnect(EnumFacing dir) {
        return dir != this.face.getObject() ? NetworkConnectionType.NETWORK : NetworkConnectionType.NONE;
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.getFaceSlot((EnumFacing)((EnumFacing)this.face.getObject())));
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        ArrayList boxes = Lists.newArrayList();
        this.addSelectionBoxes(boxes);
        boxes.forEach(box -> {
            if (box.func_72326_a(mask)) {
                list.add((AxisAlignedBB)box);
            }
        });
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(PL2Properties.getStandardBox((EnumFacing)this.face.getObject(), this.getMultipart()));
    }

    public EnumFacing[] getValidRotations() {
        return EnumFacing.field_82609_l;
    }

    public boolean rotatePart(EnumFacing axis) {
        Pair rotate = this.rotatePart((EnumFacing)this.face.getObject(), axis);
        if (((Boolean)rotate.a).booleanValue() && this.isServer()) {
            UUID uuid = this.getUUID();
            BlockPos pos = this.getPos();
            World world = this.getWorld();
            this.getContainer().removePart((IMultipart)this);
            this.face.setObject((Enum)rotate.b);
            this.isValid = false;
            MultipartHelper.addPart((World)world, (BlockPos)pos, (IMultipart)this, (UUID)uuid);
            this.sendUpdatePacket(true);
        }
        return (Boolean)rotate.a;
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)PL2Properties.ORIENTATION, (Comparable)((Object)this.face.getObject()));
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PL2Properties.ORIENTATION});
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        this.face.writeToBuf((ByteBuf)buf);
    }

    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        this.face.readFromBuf((ByteBuf)buf);
    }
}

