/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.displays;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.ISlotOccludingPart;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.utils.LabelledAxisAlignedBB;
import sonar.logistics.PL2;
import sonar.logistics.PL2Items;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkListener;
import sonar.logistics.api.operator.IOperatorProvider;
import sonar.logistics.api.operator.IOperatorTile;
import sonar.logistics.api.operator.OperatorMode;
import sonar.logistics.api.tiles.INetworkTile;
import sonar.logistics.api.tiles.cable.CableRenderType;
import sonar.logistics.api.tiles.cable.ConnectableType;
import sonar.logistics.api.tiles.cable.IDataCable;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.helpers.CableHelper;

public class DataCablePart
extends SonarMultipart
implements ISlotOccludingPart,
IDataCable,
IOperatorTile,
IOperatorProvider {
    public boolean[] isBlocked = new boolean[6];
    public int registryID = -1;

    public ILogisticsNetwork getNetwork() {
        return PL2API.getCableHelper().getNetwork(this.registryID);
    }

    public void validate() {
        if (this.isServer()) {
            this.addConnection();
        }
    }

    public void invalidate() {
        if (this.isServer()) {
            this.removeConnection();
        }
    }

    @Override
    public void addConnection() {
        PL2.getCableManager().addCable(this);
    }

    @Override
    public void removeConnection() {
        PL2.getCableManager().removeCable(this);
    }

    @Override
    public void onLocalProviderAdded(IInfoProvider tile, EnumFacing face) {
        if (this.canConnectOnSide(tile.getNetworkID(), face, false)) {
            this.getNetwork().addLocalInfoProvider(tile);
        }
    }

    @Override
    public void onLocalProviderRemoved(IInfoProvider tile, EnumFacing face) {
        if (this.canConnectOnSide(tile.getNetworkID(), face, false)) {
            this.getNetwork().removeLocalInfoProvider(tile);
        }
    }

    @Override
    public void onConnectionAdded(INetworkTile tile, EnumFacing face) {
        if (this.canConnectOnSide(tile.getNetworkID(), face, true)) {
            this.getNetwork().addConnection(tile);
        }
    }

    @Override
    public void onConnectionRemoved(INetworkTile tile, EnumFacing face) {
        if (this.canConnectOnSide(tile.getNetworkID(), face, true)) {
            this.getNetwork().removeConnection(tile);
        }
    }

    @Override
    public void addConnections(ILogisticsNetwork network) {
        CableHelper.getConnectedTiles(this).forEach(t -> network.addConnection((INetworkListener)t));
        CableHelper.getLocalMonitors(this).forEach(m -> network.addLocalInfoProvider((IInfoProvider)m));
    }

    @Override
    public void removeConnections(ILogisticsNetwork network) {
        CableHelper.getConnectedTiles(this).forEach(t -> network.removeConnection((INetworkListener)t));
        CableHelper.getLocalMonitors(this).forEach(m -> network.removeLocalInfoProvider((IInfoProvider)m));
    }

    public void onNeighborTileChange(EnumFacing facing) {
        super.onNeighborTileChange(facing);
        if (this.isServer()) {
            ILogisticsNetwork network = this.getNetwork();
            CableHelper.getLocalMonitors(this).forEach(m -> network.addLocalInfoProvider((IInfoProvider)m));
        }
    }

    @Override
    public ConnectableType canRenderConnection(EnumFacing dir) {
        return (ConnectableType)((Object)CableHelper.getConnectionType(this, (World)this.getContainer().getWorldIn(), (BlockPos)this.getContainer().getPosIn(), (EnumFacing)dir, (ConnectableType)this.getConnectableType()).a);
    }

    @Override
    public boolean canConnectOnSide(int connectingID, EnumFacing dir, boolean internal) {
        return !this.isBlocked[dir.ordinal()] ? (internal ? true : this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)dir)) == null) : false;
    }

    @Override
    public int getRegistryID() {
        return this.registryID;
    }

    @Override
    public void setRegistryID(int id) {
        this.registryID = id;
    }

    @Override
    public ConnectableType getConnectableType() {
        return ConnectableType.CONNECTABLE;
    }

    @Override
    public void updateOperatorInfo() {
        this.requestSyncPacket();
    }

    @Override
    public void addInfo(List<String> info) {
        info.add(TextFormatting.UNDERLINE + PL2Multiparts.DATA_CABLE.getDisplayName());
        info.add("Network ID: " + this.registryID);
    }

    @Override
    public boolean performOperation(RayTraceUtils.AdvancedRayTraceResultPart rayTrace, OperatorMode mode, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (mode == OperatorMode.DEFAULT) {
            ArrayList bounds = Lists.newArrayList();
            this.addSelectionBoxes(bounds);
            for (AxisAlignedBB bound : bounds) {
                if (!(bound instanceof LabelledAxisAlignedBB) || !bound.equals((Object)rayTrace.bounds)) continue;
                if (this.isClient()) {
                    return true;
                }
                String label = ((LabelledAxisAlignedBB)bound).label;
                EnumFacing face = null;
                face = !label.equals("c") ? EnumFacing.valueOf((String)label.toUpperCase()) : facing;
                this.isBlocked[face.ordinal()] = !this.isBlocked[face.ordinal()];
                IDataCable cable = PL2API.getCableHelper().getCableFromCoords(BlockCoords.translateCoords((BlockCoords)this.getCoords(), (EnumFacing)face));
                this.removeConnection();
                this.addConnection();
                if (cable != null && cable instanceof DataCablePart) {
                    DataCablePart part = (DataCablePart)cable;
                    part.isBlocked[face.func_176734_d().ordinal()] = this.isBlocked[face.ordinal()];
                    part.sendUpdatePacket(true);
                    part.markDirty();
                    part.removeConnection();
                    part.addConnection();
                }
                this.sendUpdatePacket(true);
                this.markDirty();
                return true;
            }
        }
        return false;
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.CENTER);
    }

    public EnumSet<PartSlot> getOccludedSlots() {
        EnumSet<PartSlot> set = EnumSet.noneOf(PartSlot.class);
        for (PartSlot slot : PartSlot.FACES) {
            EnumFacing face = slot.f1;
            if (!CableHelper.checkBlockInDirection(this, face).canConnect()) continue;
            set.add(slot);
        }
        return set;
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        ArrayList boxes = Lists.newArrayList();
        this.addSelectionBoxes(boxes);
        boxes.forEach(box -> {
            if (box.func_72326_a(mask)) {
                list.add((AxisAlignedBB)box);
            }
        });
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        double p = 0.0625;
        list.add((AxisAlignedBB)new LabelledAxisAlignedBB(6.0 * p, 6.0 * p, 6.0 * p, 1.0 - 6.0 * p, 1.0 - 6.0 * p, 1.0 - 6.0 * p).labelAxis("c"));
        for (EnumFacing face : EnumFacing.values()) {
            CableRenderType connect = CableHelper.checkBlockInDirection(this, face);
            if (!connect.canConnect()) continue;
            list.add(PL2Properties.getCableBox(connect, face));
        }
    }

    public IBlockState getActualState(IBlockState state) {
        for (PL2Properties.PropertyCableFace p : PL2Properties.PROPS) {
            state = state.func_177226_a((IProperty)p, (Comparable)((Object)CableHelper.checkBlockInDirection(this, p.face)));
        }
        return state;
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, (IProperty[])PL2Properties.PROPS);
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.isBlocked = new boolean[6];
        NBTTagCompound tag = nbt.func_74775_l("isBlocked");
        for (int i = 0; i < this.isBlocked.length; ++i) {
            this.isBlocked[i] = tag.func_74767_n("" + i);
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) {
            this.registryID = nbt.func_74762_e("id");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < this.isBlocked.length; ++i) {
            tag.func_74757_a("" + i, this.isBlocked[i]);
        }
        nbt.func_74782_a("isBlocked", (NBTBase)tag);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) {
            nbt.func_74768_a("id", this.registryID);
        }
        return super.writeData(nbt, type);
    }

    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        for (int i = 0; i < this.isBlocked.length; ++i) {
            buf.writeBoolean(this.isBlocked[i]);
        }
    }

    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        for (int i = 0; i < this.isBlocked.length; ++i) {
            this.isBlocked[i] = buf.readBoolean();
        }
    }

    public ItemStack getItemStack() {
        return new ItemStack(PL2Items.cable);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataCablePart) {
            return ((DataCablePart)obj).getCoords().equals((Object)this.getCoords());
        }
        return true;
    }
}

