/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.displays;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.SyncEnum;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.info.render.IInfoContainer;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.operator.OperatorMode;
import sonar.logistics.api.tiles.displays.DisplayLayout;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.common.multiparts.AbstractDisplayPart;

public class DisplayScreenPart
extends AbstractDisplayPart {
    public SyncEnum<DisplayLayout> layout = new SyncEnum((Enum[])DisplayLayout.values(), 1);
    public ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, ListenerType.ALL.size());
    public InfoContainer container = new InfoContainer(this);

    public DisplayScreenPart() {
    }

    public DisplayScreenPart(EnumFacing dir, EnumFacing rotation) {
        super(dir, rotation);
    }

    @Override
    public boolean performOperation(RayTraceUtils.AdvancedRayTraceResultPart rayTrace, OperatorMode mode, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.getWorld().field_72995_K) {
            this.incrementLayout();
            FontHelper.sendMessage((String)("Screen Layout: " + this.layout.getObject()), (World)this.getWorld(), (EntityPlayer)player);
        }
        return true;
    }

    @Override
    public IInfoContainer container() {
        return this.container;
    }

    @Override
    public DisplayLayout getLayout() {
        return (DisplayLayout)this.layout.getObject();
    }

    @Override
    public DisplayType getDisplayType() {
        return DisplayType.SMALL;
    }

    @Override
    public int maxInfo() {
        return 2;
    }

    @Override
    public void incrementLayout() {
        this.layout.incrementEnum();
        while (((DisplayLayout)this.layout.getObject()).maxInfo > this.maxInfo()) {
            this.layout.incrementEnum();
        }
        this.sendSyncPacket();
        this.sendUpdatePacket(true);
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        double p = 0.0625;
        double height = p * 16.0;
        double width = 0.0;
        double length = p * 1.0;
        switch (this.face) {
            case EAST: {
                list.add(new AxisAlignedBB(1.0, p * 4.0, width / 2.0, 1.0 - length, 1.0 - p * 4.0, 1.0 - width / 2.0));
                break;
            }
            case NORTH: {
                list.add(new AxisAlignedBB(width / 2.0, p * 4.0, length, 1.0 - width / 2.0, 1.0 - p * 4.0, 0.0));
                break;
            }
            case SOUTH: {
                list.add(new AxisAlignedBB(width / 2.0, p * 4.0, 1.0, 1.0 - width / 2.0, 1.0 - p * 4.0, 1.0 - length));
                break;
            }
            case WEST: {
                list.add(new AxisAlignedBB(length, p * 4.0, width / 2.0, 0.0, 1.0 - p * 4.0, 1.0 - width / 2.0));
                break;
            }
            case DOWN: {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0));
                break;
            }
            case UP: {
                list.add(new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 0.9375, 1.0));
                break;
            }
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound tag, NBTHelper.SyncType type) {
        super.writeData(tag, type);
        this.container().writeData(tag, type);
        this.layout.writeData(tag, type);
        return tag;
    }

    @Override
    public void readData(NBTTagCompound tag, NBTHelper.SyncType type) {
        super.readData(tag, type);
        this.container().readData(tag, type);
        this.layout.readData(tag, type);
    }

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.container().writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
        this.layout.writeToBuf((ByteBuf)buf);
    }

    @Override
    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        this.container().readData(ByteBufUtils.readTag((ByteBuf)buf), NBTHelper.SyncType.SAVE);
        this.layout.readFromBuf((ByteBuf)buf);
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.DISPLAY_SCREEN;
    }
}

