/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.displays;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import sonar.logistics.PL2Items;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.common.multiparts.displays.DisplayScreenPart;

public class HolographicDisplayPart
extends DisplayScreenPart {
    public HolographicDisplayPart() {
    }

    public HolographicDisplayPart(EnumFacing dir, EnumFacing rotation) {
        super(dir, rotation);
    }

    @Override
    public DisplayType getDisplayType() {
        return DisplayType.HOLOGRAPHIC;
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        double p = 0.0625;
        double height = p * 16.0;
        double width = 0.0;
        double length = p * 1.0;
        switch (this.face) {
            case EAST: {
                list.add(new AxisAlignedBB(1.0, p * 4.0, width / 2.0, 1.0 - length, 1.0 - p * 4.0, 1.0 - width / 2.0));
                break;
            }
            case NORTH: {
                list.add(new AxisAlignedBB(width / 2.0, p * 4.0, length, 1.0 - width / 2.0, 1.0 - p * 4.0, 0.0));
                break;
            }
            case SOUTH: {
                list.add(new AxisAlignedBB(width / 2.0, p * 4.0, 1.0, 1.0 - width / 2.0, 1.0 - p * 4.0, 1.0 - length));
                break;
            }
            case WEST: {
                list.add(new AxisAlignedBB(length, p * 4.0, width / 2.0, 0.0, 1.0 - p * 4.0, 1.0 - width / 2.0));
                break;
            }
            case DOWN: {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0));
                break;
            }
            case UP: {
                list.add(new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 0.9375, 1.0));
                break;
            }
        }
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack(PL2Items.holographic_display);
    }
}

