/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.displays;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.api.utils.BlockCoords;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.PL2;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.PL2API;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.operator.IOperatorTool;
import sonar.logistics.api.operator.OperatorMode;
import sonar.logistics.api.tiles.cable.ConnectableType;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.DisplayConnections;
import sonar.logistics.api.tiles.displays.DisplayLayout;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.api.tiles.displays.IDisplay;
import sonar.logistics.api.tiles.displays.ILargeDisplay;
import sonar.logistics.client.gui.GuiDisplayScreen;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.helpers.PacketHelper;
import sonar.logistics.network.PacketConnectedDisplayScreen;

public class LargeDisplayScreenPart
extends AbstractDisplayPart
implements ILargeDisplay {
    public int registryID = -1;
    public boolean wasAdded = false;
    public static final PropertyEnum<DisplayConnections> TYPE = PropertyEnum.func_177709_a((String)"type", DisplayConnections.class);
    public ConnectedDisplay overrideDisplay = null;
    public NBTTagCompound savedTag = null;
    public SyncTagType.BOOLEAN shouldRender = new SyncTagType.BOOLEAN(3);
    public SyncTagType.BOOLEAN wasLocked = new SyncTagType.BOOLEAN(4);
    public boolean onRenderChange = true;

    public LargeDisplayScreenPart() {
        this.syncList.addParts(new IDirtyPart[]{this.shouldRender, this.wasLocked});
    }

    public LargeDisplayScreenPart(EnumFacing dir, EnumFacing rotation) {
        super(dir, rotation);
        this.syncList.addParts(new IDirtyPart[]{this.shouldRender, this.wasLocked});
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        if (stack != null && stack.func_77973_b() instanceof IOperatorTool) {
            return false;
        }
        if (this.isClient()) {
            return true;
        }
        if (hit.field_178784_b != this.face) {
            ConnectedDisplay display = this.getDisplayScreen();
            LargeDisplayScreenPart part = (LargeDisplayScreenPart)display.getTopLeftScreen();
            if (part != null) {
                part.openFlexibleGui(player, 0);
            }
            return true;
        }
        return this.container().onClicked(this, player.func_70093_af() ? BlockInteractionType.SHIFT_RIGHT : BlockInteractionType.RIGHT, this.getWorld(), player, hand, stack, hit);
    }

    @Override
    public boolean performOperation(RayTraceUtils.AdvancedRayTraceResultPart rayTrace, OperatorMode mode, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.getDisplayScreen() != null && !this.getWorld().field_72995_K) {
            this.incrementLayout();
            FontHelper.sendMessage((String)("Screen Layout: " + this.getDisplayScreen().layout.getObject()), (World)this.getWorld(), (EntityPlayer)player);
        }
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer() && this.onRenderChange) {
            if (this.shouldRender()) {
                this.getDisplayScreen().sendViewers();
            }
            this.sendSyncPacket();
            this.sendByteBufPacket(5);
            this.onRenderChange = false;
        }
    }

    @Override
    public void updateDefaultInfo() {
        if (this.getDisplayScreen() != null && this.shouldRender()) {
            super.updateDefaultInfo();
        }
    }

    @Override
    public InfoContainer container() {
        return this.getDisplayScreen().container;
    }

    @Override
    public DisplayLayout getLayout() {
        ConnectedDisplay screen = this.getDisplayScreen();
        return screen == null ? DisplayLayout.ONE : screen.getLayout();
    }

    @Override
    public void incrementLayout() {
        this.getDisplayScreen().layout.incrementEnum();
        while (((DisplayLayout)this.getDisplayScreen().layout.getObject()).maxInfo > this.maxInfo()) {
            this.getDisplayScreen().layout.incrementEnum();
        }
        this.sendSyncPacket();
        this.getDisplayScreen().sendViewers();
    }

    @Override
    public DisplayType getDisplayType() {
        return DisplayType.LARGE;
    }

    @Override
    public int maxInfo() {
        return 4;
    }

    @Override
    public ConnectableType getConnectableType() {
        return ConnectableType.CONNECTABLE;
    }

    @Override
    public int getRegistryID() {
        return this.registryID;
    }

    @Override
    public void setRegistryID(int id) {
        this.registryID = id;
    }

    @Override
    public ConnectedDisplay getDisplayScreen() {
        return this.overrideDisplay != null ? this.overrideDisplay : PL2.getInfoManager(this.isClient()).getOrCreateDisplayScreen(this.getWorld(), this, this.registryID);
    }

    @Override
    public void setConnectedDisplay(ConnectedDisplay connectedDisplay) {
        if (this.isServer() && this.shouldRender() && this.savedTag != null && !this.savedTag.func_82582_d()) {
            connectedDisplay.readData(this.savedTag, NBTHelper.SyncType.SAVE);
            this.savedTag = null;
            connectedDisplay.sendViewers();
            PL2.getServerManager().updateViewingMonitors = true;
        }
    }

    @Override
    public boolean shouldRender() {
        return (Boolean)this.shouldRender.getObject() != false && this.getRegistryID() != -1 && this.getDisplayScreen() != null;
    }

    @Override
    public void setShouldRender(boolean shouldRender) {
        if (shouldRender != (Boolean)this.shouldRender.getObject()) {
            this.shouldRender.setObject((Object)shouldRender);
        }
        this.onRenderChange = true;
        if (this.isServer()) {
            PL2.getServerManager().updateViewingMonitors = true;
        }
        this.markDirty();
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.getDisplayScreen().getListenerList();
    }

    @Override
    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
        this.getDisplayScreen().onListenerAdded(tally);
    }

    @Override
    public void onListenerRemoved(ListenerTally<PlayerListener> tally) {
        this.getDisplayScreen().onListenerRemoved(tally);
    }

    @Override
    public void onNetworkConnect(ILogisticsNetwork network) {
        super.onNetworkConnect(network);
        this.getDisplayScreen().setHasChanged();
    }

    @Override
    public void onNetworkDisconnect(ILogisticsNetwork network) {
        super.onNetworkDisconnect(network);
        this.getDisplayScreen().setHasChanged();
    }

    @Override
    public boolean canConnectOnSide(int connectingID, EnumFacing dir, boolean internal) {
        return dir != this.face && dir != this.face.func_176734_d() && (connectingID == this.registryID || (Boolean)this.wasLocked.getObject() == false && (Boolean)this.getDisplayScreen().isLocked.getObject() == false);
    }

    @Override
    public void addInfo(List<String> info) {
        super.addInfo(info);
        info.add("Large Display ID: " + this.registryID);
        info.add("Should Render " + this.shouldRender.getObject());
    }

    @Override
    public void addConnection() {
        if (this.isServer()) {
            PL2.getDisplayManager().addConnection(this);
        }
    }

    @Override
    public void removeConnection() {
        if (this.isServer()) {
            PL2.getDisplayManager().removeConnection(this);
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (this.isServer() && !this.wasAdded) {
            this.addConnection();
            this.wasAdded = true;
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.wasRemoved = true;
        this.wasAdded = false;
        this.removeConnection();
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        double p = 0.0625;
        double height = p * 16.0;
        double width = 0.0;
        double length = p * 1.0;
        switch (this.face) {
            case EAST: {
                list.add(new AxisAlignedBB(1.0, 0.0, width / 2.0, 1.0 - length, height, 1.0 - width / 2.0));
                break;
            }
            case NORTH: {
                list.add(new AxisAlignedBB(width / 2.0, 0.0, length, 1.0 - width / 2.0, height, 0.0));
                break;
            }
            case SOUTH: {
                list.add(new AxisAlignedBB(width / 2.0, 0.0, 1.0, 1.0 - width / 2.0, height, 1.0 - length));
                break;
            }
            case WEST: {
                list.add(new AxisAlignedBB(length, 0.0, width / 2.0, 0.0, height, 1.0 - width / 2.0));
                break;
            }
            case DOWN: {
                list.add(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, length, 1.0));
                break;
            }
            case UP: {
                list.add(new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 1.0 - length, 1.0));
                break;
            }
        }
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess w, BlockPos pos) {
        IBlockState currentState = state;
        ArrayList faces = Lists.newArrayList();
        block8: for (EnumFacing face : EnumFacing.field_82609_l) {
            IDisplay display;
            if (face == this.face || face == this.face.func_176734_d() || this.getWorld() == null || (display = PL2API.getCableHelper().getDisplayScreen(BlockCoords.translateCoords((BlockCoords)this.getCoords(), (EnumFacing)face), this.face)) == null || display.getDisplayType() != DisplayType.LARGE || ((ILargeDisplay)display).getRegistryID() != this.registryID) continue;
            switch (this.face) {
                case DOWN: {
                    EnumFacing toAdd = face;
                    if (toAdd == EnumFacing.NORTH || toAdd == EnumFacing.SOUTH) {
                        toAdd = toAdd.func_176734_d();
                    }
                    faces.add(toAdd);
                    continue block8;
                }
                case EAST: {
                    EnumFacing toAdd = face.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.Y);
                    if (toAdd == EnumFacing.NORTH || toAdd == EnumFacing.SOUTH) {
                        toAdd = toAdd.func_176734_d();
                    }
                    faces.add(toAdd);
                    continue block8;
                }
                case NORTH: {
                    EnumFacing toAdd = face.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.Y);
                    if (toAdd == EnumFacing.NORTH || toAdd == EnumFacing.SOUTH) {
                        toAdd = toAdd.func_176734_d();
                    }
                    faces.add(toAdd);
                    continue block8;
                }
                case SOUTH: {
                    EnumFacing toAdd = face.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.X).func_176732_a(EnumFacing.Axis.Y).func_176734_d();
                    faces.add(toAdd);
                    continue block8;
                }
                case UP: {
                    faces.add(face);
                    continue block8;
                }
                case WEST: {
                    faces.add(face.func_176732_a(EnumFacing.Axis.Z).func_176732_a(EnumFacing.Axis.Y).func_176734_d());
                    continue block8;
                }
            }
        }
        DisplayConnections type = DisplayConnections.getType(faces);
        return currentState.func_177226_a((IProperty)PL2Properties.ORIENTATION, (Comparable)this.face).func_177226_a((IProperty)PL2Properties.ROTATION, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    @Override
    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PL2Properties.ORIENTATION, PL2Properties.ROTATION, TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (nbt.func_74764_b("id")) {
            this.registryID = nbt.func_74762_e("id");
            this.shouldRender.readData(nbt, type);
            this.wasLocked.readData(nbt, type);
        }
        if (this.isServer() && type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE}) && nbt.func_74764_b("connected")) {
            this.savedTag = nbt;
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC}) || type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE}) && ((Boolean)this.getDisplayScreen().isLocked.getObject()).booleanValue()) {
            nbt.func_74768_a("id", this.registryID);
            this.shouldRender.writeData(nbt, type);
            this.wasLocked.setObject(this.getDisplayScreen().isLocked.getObject());
            this.wasLocked.writeData(nbt, type);
        }
        if (this.isServer() && type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE}) && this.shouldRender() && this.getDisplayScreen() != null) {
            this.getDisplayScreen().writeData(nbt, type);
        }
        return super.writeData(nbt, type);
    }

    public void onSyncPacketRequested(EntityPlayer player) {
        super.onSyncPacketRequested(player);
        ConnectedDisplay screen = this.getDisplayScreen();
        if (screen != null) {
            PL2.network.sendTo((IMessage)new PacketConnectedDisplayScreen(screen, this.registryID), (EntityPlayerMP)player);
        }
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        switch (id) {
            case 5: {
                this.shouldRender.writeToBuf(buf);
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        switch (id) {
            case 5: {
                this.shouldRender.readFromBuf(buf);
                break;
            }
            case 6: {
                if (((Boolean)this.getDisplayScreen().isLocked.getObject()).booleanValue()) {
                    this.getDisplayScreen().unlock();
                    break;
                }
                this.getDisplayScreen().lock();
            }
        }
    }

    @Override
    public Object getServerElement(AbstractDisplayPart obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerMultipartSync((SonarMultipart)obj) : null;
    }

    @Override
    public Object getClientElement(AbstractDisplayPart obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiDisplayScreen(obj) : null;
    }

    @Override
    public void onGuiOpened(AbstractDisplayPart obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                LargeDisplayScreenPart part = (LargeDisplayScreenPart)this.getDisplayScreen().getTopLeftScreen();
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
                PL2.network.sendTo((IMessage)new PacketConnectedDisplayScreen(this.getDisplayScreen(), this.registryID), (EntityPlayerMP)player);
                PacketHelper.sendLocalProvidersFromScreen(part, player);
            }
        }
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.LARGE_DISPLAY_SCREEN;
    }
}

