/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.misc;

import io.netty.buffer.ByteBuf;
import java.text.SimpleDateFormat;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IRedstonePart;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.cable.NetworkConnectionType;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.client.gui.GuiClock;
import sonar.logistics.common.multiparts.SidedPart;
import sonar.logistics.info.types.ClockInfo;

public class ClockPart
extends SidedPart
implements IInfoProvider,
IRedstonePart,
IByteBufTile,
IFlexibleGui {
    public static final TileMessage[] validStates = new TileMessage[0];
    public static final long[] tickAdjustments = new long[]{100L, -100L, 1000L, -1000L, 60000L, -60000L, 3600000L, -3600000L};
    public final ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, ListenerType.ALL.size());
    public SyncTagType.LONG tickTime = new SyncTagType.LONG(1);
    public long lastMillis;
    public long currentMillis;
    public long offset = 0L;
    public float rotation;
    public boolean isSet;
    public boolean lastSignal;
    public boolean wasStarted;
    public boolean powering;
    public long finalStopTime;

    public ClockPart() {
        this.syncList.addParts(new IDirtyPart[]{this.tickTime});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isClient()) {
            return;
        }
        this.currentMillis = this.getWorld().func_82737_E() * 50L;
        if ((Long)this.tickTime.getObject() >= 10L) {
            long start = this.currentMillis - this.lastMillis;
            this.rotation = start * 360L / (Long)this.tickTime.getObject();
            if (start > (Long)this.tickTime.getObject()) {
                this.lastMillis = this.currentMillis;
                this.powering = true;
                this.notifyBlockUpdate();
            } else if (this.powering) {
                this.powering = false;
                this.notifyBlockUpdate();
            }
            this.markDirty();
        }
        this.sendByteBufPacket(0);
        this.setClockInfo();
    }

    @Override
    public NetworkConnectionType canConnect(EnumFacing dir) {
        return dir == this.face.getObject() || dir.func_176734_d() == this.face.getObject() ? NetworkConnectionType.NETWORK : NetworkConnectionType.NONE;
    }

    public void setClockInfo() {
        ClockInfo info = null;
        if ((Long)this.tickTime.getObject() >= 10L) {
            long start = this.currentMillis - this.lastMillis;
            String timeString = new SimpleDateFormat("HH:mm:ss:SSS").format(start - 3600000L).substring(0, 11);
            info = new ClockInfo(start, ((Long)this.tickTime.getObject()).longValue(), timeString);
        }
        if (info != null) {
            InfoUUID id = new InfoUUID(this.getIdentity(), 0);
            IInfo oldInfo = PL2.getServerManager().getInfoFromUUID(id);
            if (!(oldInfo != null && oldInfo.isMatchingType(info) && oldInfo.isMatchingInfo(info) && oldInfo.isIdenticalInfo(info))) {
                PL2.getServerManager().changeInfo(id, info);
            }
        }
    }

    @Override
    public IInfo getMonitorInfo(int pos) {
        return PL2.getServerManager().getInfoFromUUID(new InfoUUID(this.getIdentity(), 0));
    }

    @Override
    public int getMaxInfo() {
        return 1;
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    @Override
    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
        SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((PlayerListener)tally.listener).player);
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)PL2Properties.ORIENTATION, (Comparable)this.getCableFace()).func_177226_a((IProperty)PL2Properties.CLOCK_HAND, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PL2Properties.ORIENTATION, PL2Properties.CLOCK_HAND});
    }

    @Override
    public void validate() {
        super.validate();
        if (this.isServer()) {
            this.setClockInfo();
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.tickTime.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            nbt.func_74757_a("isSet", this.isSet);
            nbt.func_74757_a("lastSignal", this.lastSignal);
            nbt.func_74757_a("wasStarted", this.wasStarted);
            nbt.func_74772_a("finalStopTime", this.finalStopTime);
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        this.tickTime.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE) {
            this.isSet = nbt.func_74767_n("isSet");
            this.lastSignal = nbt.func_74767_n("lastSignal");
            this.wasStarted = nbt.func_74767_n("wasStarted");
            this.finalStopTime = nbt.func_74763_f("finalStopTime");
        }
        return nbt;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                buf.writeFloat(this.rotation);
                break;
            }
            case 1: {
                this.tickTime.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -4: {
                this.sendByteBufPacket(-2);
                break;
            }
            case 0: {
                this.rotation = buf.readFloat();
                break;
            }
            case 1: {
                this.tickTime.readFromBuf(buf);
            }
        }
        if (id >= 2 && id <= 9) {
            this.tickTime.increaseBy(tickAdjustments[id - 2]);
        }
        if ((Long)this.tickTime.getObject() < 0L) {
            this.tickTime.setObject((Object)0L);
        } else if ((Long)this.tickTime.getObject() > 86400000L) {
            this.tickTime.setObject((Object)86399999L);
        }
    }

    @Override
    public boolean hasStandardGui() {
        return true;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerMultipartSync((SonarMultipart)this) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiClock(this) : null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    public boolean canConnectRedstone(EnumFacing side) {
        return side != this.getCableFace().func_176734_d();
    }

    public int getWeakSignal(EnumFacing side) {
        return side != this.getCableFace().func_176734_d() && this.powering ? 15 : 0;
    }

    public int getStrongSignal(EnumFacing side) {
        return side != this.getCableFace().func_176734_d() && this.powering ? 15 : 0;
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.CLOCK;
    }
}

