/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.misc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IRedstonePart;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncNBTAbstractList;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.signaller.EmitterStatement;
import sonar.logistics.api.tiles.signaller.ILogisticsTile;
import sonar.logistics.api.tiles.signaller.SignallerModes;
import sonar.logistics.api.viewers.ILogicListenable;
import sonar.logistics.client.gui.generic.GuiStatementList;
import sonar.logistics.common.multiparts.SidedPart;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.helpers.PacketHelper;

public class RedstoneSignallerPart
extends SidedPart
implements IRedstonePart,
ILogisticsTile,
IByteBufTile,
IFlexibleGui {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK, TileMessage.NO_STATEMENTS};
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public SyncTagType.BOOLEAN isActive = new SyncTagType.BOOLEAN(1);
    public SyncNBTAbstractList<EmitterStatement> statements = new SyncNBTAbstractList(EmitterStatement.class, 2);
    public SyncEnum<SignallerModes> mode = new SyncEnum((Enum[])SignallerModes.values(), 3);

    public RedstoneSignallerPart() {
        this.syncList.addParts(new IDirtyPart[]{this.isActive, this.statements, this.mode});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isClient()) {
            return;
        }
        if (this.statements.getObjects().isEmpty()) {
            this.isActive.setObject((Object)false);
            return;
        }
        ArrayList ids = Lists.newArrayList();
        for (EmitterStatement statement : this.statements.getObjects()) {
            statement.addRequiredUUIDs(ids);
        }
        HashMap infoList = Maps.newHashMap();
        for (InfoUUID id : ids) {
            IInfo monitorInfo;
            ILogicListenable monitor;
            if (infoList.containsKey(id) || (monitor = CableHelper.getMonitorFromIdentity(id.getIdentity(), false)) == null || !this.network.getLocalInfoProviders().contains(monitor) || (monitorInfo = PL2.getServerManager().getInfoFromUUID(id)) == null) continue;
            infoList.put(id, monitorInfo);
        }
        switch ((SignallerModes)this.mode.getObject()) {
            case ALL_FALSE: {
                for (EmitterStatement statement : this.statements.getObjects()) {
                    boolean matching = statement.isMatching(infoList).getBool();
                    statement.wasTrue.setObject((Object)matching);
                    if (!matching) continue;
                    this.isActive.setObject((Object)false);
                    return;
                }
                this.isActive.setObject((Object)true);
                break;
            }
            case ALL_TRUE: {
                for (EmitterStatement statement : this.statements.getObjects()) {
                    boolean matching = statement.isMatching(infoList).getBool();
                    statement.wasTrue.setObject((Object)matching);
                    if (matching) continue;
                    this.isActive.setObject((Object)false);
                    return;
                }
                this.isActive.setObject((Object)true);
                break;
            }
            case ONE_FALSE: {
                for (EmitterStatement statement : this.statements.getObjects()) {
                    boolean matching = statement.isMatching(infoList).getBool();
                    statement.wasTrue.setObject((Object)matching);
                    if (matching) continue;
                    this.isActive.setObject((Object)true);
                    return;
                }
                this.isActive.setObject((Object)false);
                break;
            }
            case ONE_TRUE: {
                for (EmitterStatement statement : this.statements.getObjects()) {
                    boolean matching = statement.isMatching(infoList).getBool();
                    statement.wasTrue.setObject((Object)matching);
                    if (!matching) continue;
                    this.isActive.setObject((Object)true);
                    return;
                }
                this.isActive.setObject((Object)false);
                break;
            }
        }
    }

    @Override
    public SyncNBTAbstractList<EmitterStatement> getStatements() {
        return this.statements;
    }

    @Override
    public SyncEnum<SignallerModes> emitterMode() {
        return this.mode;
    }

    public boolean canConnectRedstone(EnumFacing side) {
        return true;
    }

    public int getWeakSignal(EnumFacing side) {
        return this.isActive() ? 15 : 0;
    }

    public int getStrongSignal(EnumFacing side) {
        return this.isActive() ? 15 : 0;
    }

    public boolean isActive() {
        return (Boolean)this.isActive.getObject();
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)PL2Properties.ORIENTATION, (Comparable)this.getCableFace()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(this.isActive()));
    }

    @Override
    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PL2Properties.ORIENTATION, ACTIVE});
    }

    public void markChanged(IDirtyPart part) {
        super.markChanged(part);
        if (part == this.isActive && this.getWorld() != null) {
            SonarMultipartHelper.sendMultipartPacketAround((SonarMultipart)this, (int)0, (int)128);
            this.notifyBlockUpdate();
        }
    }

    public void onSyncPacketRequested(EntityPlayer player) {
        super.onSyncPacketRequested(player);
        PacketHelper.sendLocalProviders(this, this.getIdentity(), player);
    }

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        this.isActive.writeToBuf((ByteBuf)buf);
    }

    @Override
    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        this.isActive.readFromBuf((ByteBuf)buf);
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.isActive.writeToBuf(buf);
                break;
            }
            case 1: {
                this.mode.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.isActive.readFromBuf(buf);
                if (!this.isClient()) break;
                this.markRenderUpdate();
                break;
            }
            case 1: {
                this.mode.readFromBuf(buf);
            }
        }
    }

    @Override
    public boolean hasStandardGui() {
        return true;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                PacketHelper.sendLocalProviders(this, this.getIdentity(), player);
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerMultipartSync((SonarMultipart)this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiStatementList(player, this);
            }
        }
        return null;
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.REDSTONE_SIGNALLER;
    }
}

