/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.nodes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mcmultipart.multipart.ISlottedPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.inventory.SonarMultipartInventory;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.tiles.nodes.INode;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.wireless.ITransceiver;
import sonar.logistics.client.gui.GuiArray;
import sonar.logistics.common.containers.ContainerArray;
import sonar.logistics.common.multiparts.SidedPart;
import sonar.logistics.connections.CacheHandler;
import sonar.logistics.helpers.LogisticsHelper;

public class ArrayPart
extends SidedPart
implements ISlottedPart,
INode,
IFlexibleGui {
    public static boolean entityChanged = true;
    public List<NodeConnection> channels = Lists.newArrayList();
    public SyncTagType.INT priority = new SyncTagType.INT(1);
    public SonarMultipartInventory inventory = new SonarMultipartInventory(this, 8){

        public void func_70296_d() {
            super.func_70296_d();
            ArrayPart.this.updateConnectionLists();
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return stack != null && stack.func_77973_b() instanceof ITransceiver;
        }

        public NBTHelper.SyncType[] getSyncTypes() {
            return new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE, NBTHelper.SyncType.DEFAULT_SYNC};
        }
    };

    public ArrayPart() {
        this.syncList.addParts(new IDirtyPart[]{this.priority, this.inventory});
    }

    public void func_73660_a() {
        super.func_73660_a();
    }

    public void updateConnectionLists() {
        ArrayList channels = Lists.newArrayList();
        for (int i = 0; i < 8; ++i) {
            NodeConnection connect;
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ITransceiver) || !stack.func_77942_o() || channels.contains(connect = LogisticsHelper.getTransceiverNode(this, stack))) continue;
            channels.add(connect);
        }
        this.channels = channels;
        this.network.onCacheChanged(CacheHandler.NODES);
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList stacks = Lists.newArrayList();
        stacks.add(this.getItemStack());
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack == null) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    @Override
    public int getPriority() {
        return (Integer)this.priority.getObject();
    }

    @Override
    public void addConnections(List<NodeConnection> connections) {
        connections.addAll(this.channels);
    }

    @Override
    public void validate() {
        super.validate();
        this.updateConnectionLists();
        if (this.isClient()) {
            this.requestSyncPacket();
        }
    }

    public void onSyncPacketRequested(EntityPlayer player) {
        super.onSyncPacketRequested(player);
        this.inventory.markChanged();
    }

    @Override
    public boolean hasStandardGui() {
        return true;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        if (id == 0) {
            SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerArray(player, this) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiArray(player, this) : null;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.ARRAY;
    }
}

