/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.nodes;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.IWorldPosition;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.nodes.EntityConnection;
import sonar.logistics.api.tiles.nodes.EntityTarget;
import sonar.logistics.api.tiles.nodes.INode;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.client.gui.GuiEntityNode;
import sonar.logistics.common.multiparts.SidedPart;
import sonar.logistics.connections.CacheHandler;

public class EntityNodePart
extends SidedPart
implements INode,
IByteBufTile,
IFlexibleGui {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK};
    public SyncEnum<EntityTarget> entityTarget = new SyncEnum((Enum[])EntityTarget.values(), 1);
    public SyncTagType.INT entityRange = (SyncTagType.INT)new SyncTagType.INT(2).setDefault((Object)10);
    public SyncTagType.BOOLEAN nearest = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(3).setDefault((Object)true);
    public UUID uuid;
    public int update;

    public EntityNodePart() {
        this.syncList.addParts(new IDirtyPart[]{this.entityTarget, this.entityRange, this.nearest});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.update == 20) {
            Entity entity = this.getEntity();
            if (this.uuid == null && entity != null || entity == null || !this.uuid.equals(entity.getPersistentID())) {
                this.network.onCacheChanged(CacheHandler.ENTITY_NODES);
            }
            this.update = 0;
        } else {
            ++this.update;
        }
    }

    public Entity getEntity() {
        switch ((EntityTarget)this.entityTarget.getObject()) {
            case ANIMAL: {
                return SonarHelper.getEntity(EntityAnimal.class, (IWorldPosition)this, (int)((Integer)this.entityRange.getObject()), (boolean)((Boolean)this.nearest.getObject()));
            }
            case MOB: {
                return SonarHelper.getEntity(EntityMob.class, (IWorldPosition)this, (int)((Integer)this.entityRange.getObject()), (boolean)((Boolean)this.nearest.getObject()));
            }
            case NORMAL: {
                return SonarHelper.getEntity(Entity.class, (IWorldPosition)this, (int)((Integer)this.entityRange.getObject()), (boolean)((Boolean)this.nearest.getObject()));
            }
            case PLAYER: {
                return SonarHelper.getEntity(EntityPlayer.class, (IWorldPosition)this, (int)((Integer)this.entityRange.getObject()), (boolean)((Boolean)this.nearest.getObject()));
            }
        }
        return null;
    }

    @Override
    public void addConnections(List<NodeConnection> connections) {
        Entity entity = this.getEntity();
        if (entity != null) {
            this.uuid = entity.getPersistentID();
            connections.add(new EntityConnection(this, entity));
        } else {
            this.uuid = null;
        }
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.entityTarget.writeToBuf(buf);
                break;
            }
            case 3: {
                this.nearest.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.entityTarget.readFromBuf(buf);
                break;
            }
            case 1: {
                if ((Integer)this.entityRange.getObject() == 64) break;
                this.entityRange.increaseBy(1);
                break;
            }
            case 2: {
                if ((Integer)this.entityRange.getObject() == 1) break;
                this.entityRange.decreaseBy(1);
                break;
            }
            case 3: {
                this.nearest.readFromBuf(buf);
            }
        }
    }

    @Override
    public boolean hasStandardGui() {
        return true;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerMultipartSync((SonarMultipart)this) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiEntityNode(this) : null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.ENTITY_NODE;
    }
}

