/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.nodes;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.InventoryHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUUID;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.filters.ITransferFilteredTile;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.operator.IOperatorTile;
import sonar.logistics.api.operator.OperatorMode;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.IChannelledTile;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.INode;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.tiles.nodes.TransferType;
import sonar.logistics.api.tiles.readers.ChannelList;
import sonar.logistics.api.utils.ChannelType;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.client.gui.generic.GuiChannelSelection;
import sonar.logistics.client.gui.generic.GuiFilterList;
import sonar.logistics.common.containers.ContainerChannelSelection;
import sonar.logistics.common.containers.ContainerFilterList;
import sonar.logistics.common.multiparts.SidedPart;
import sonar.logistics.info.types.MonitoredBlockCoords;
import sonar.logistics.info.types.MonitoredEntity;
import sonar.logistics.network.sync.SyncFilterList;

public class TransferNodePart
extends SidedPart
implements INode,
IOperatorTile,
ITransferFilteredTile,
IFlexibleGui,
InventoryHelper.IInventoryFilter,
IChannelledTile,
IByteBufTile {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK};
    public ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, ListenerType.ALL.size());
    public static final PropertyEnum<NodeTransferMode> TRANSFER = PropertyEnum.func_177709_a((String)"transfer", NodeTransferMode.class);
    public SyncTagType.INT priority = new SyncTagType.INT(1);
    public SyncEnum<NodeTransferMode> transferMode = new SyncEnum((Enum[])NodeTransferMode.values(), 2).setDefault((Enum)NodeTransferMode.ADD);
    public SyncFilterList filters = new SyncFilterList(3);
    public ChannelList list = new ChannelList(this.getIdentity(), this.channelType(), 4);
    public SyncTagType.BOOLEAN connection = new SyncTagType.BOOLEAN(5);
    public SyncTagType.BOOLEAN items = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(6).setDefault((Object)true);
    public SyncTagType.BOOLEAN fluids = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(7).setDefault((Object)true);
    public SyncTagType.BOOLEAN energy = (SyncTagType.BOOLEAN)new SyncTagType.BOOLEAN(8).setDefault((Object)true);
    public SyncCoords lastSelected = new SyncCoords(-11);
    public SyncUUID lastSelectedUUID = new SyncUUID(-10);
    public int ticks = 20;

    public TransferNodePart() {
        this.syncList.addParts(new IDirtyPart[]{this.priority, this.transferMode, this.filters, this.list, this.connection, this.items, this.fluids, this.energy});
    }

    @Override
    public boolean performOperation(RayTraceUtils.AdvancedRayTraceResultPart rayTrace, OperatorMode mode, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.getWorld().field_72995_K) {
            this.transferMode.incrementEnum();
            this.sendSyncPacket();
            this.sendUpdatePacket(true);
            FontHelper.sendMessage((String)("Transfer Mode: " + this.transferMode.getObject()), (World)this.getWorld(), (EntityPlayer)player);
        }
        return true;
    }

    public boolean allowed(ItemStack stack) {
        return this.filters.matches(new StoredItemStack(stack), (NodeTransferMode)this.transferMode.getObject());
    }

    public boolean allowed(FluidStack stack) {
        return this.filters.matches(new StoredFluidStack(stack), (NodeTransferMode)this.transferMode.getObject());
    }

    @Override
    public void addConnections(List<NodeConnection> connections) {
        connections.add(this.getConnected());
    }

    @Override
    public int getPriority() {
        return (Integer)this.priority.getObject();
    }

    @Override
    public SyncFilterList getFilters() {
        return this.filters;
    }

    @Override
    public NodeTransferMode getTransferMode() {
        return (NodeTransferMode)this.transferMode.getObject();
    }

    @Override
    public boolean isTransferEnabled(TransferType type) {
        switch (type) {
            case ENERGY: {
                return (Boolean)this.energy.getObject();
            }
            case FLUID: {
                return (Boolean)this.fluids.getObject();
            }
            case GAS: 
            case INFO: {
                break;
            }
            case ITEMS: {
                return (Boolean)this.items.getObject();
            }
        }
        return false;
    }

    @Override
    public void setTransferType(TransferType type, boolean enable) {
        switch (type) {
            case ENERGY: {
                this.energy.setObject((Object)enable);
                break;
            }
            case FLUID: {
                this.fluids.setObject((Object)enable);
                break;
            }
            case GAS: 
            case INFO: {
                break;
            }
            case ITEMS: {
                this.items.setObject((Object)enable);
                break;
            }
        }
        this.sendByteBufPacket(2);
    }

    @Override
    public BlockConnection getConnected() {
        return this.wasRemoved ? null : new BlockConnection(this, new BlockCoords(this.getPos().func_177972_a(this.getCableFace()), this.getWorld().field_73011_w.getDimension()), this.getCableFace());
    }

    @Override
    public boolean canConnectToNodeConnection() {
        return (Boolean)this.connection.getObject();
    }

    @Override
    public void incrementTransferMode() {
        this.transferMode.incrementEnum();
        this.sendByteBufPacket(3);
    }

    @Override
    public void addInfo(List<String> info) {
        super.addInfo(info);
        info.add("Transfer Mode: " + this.transferMode.getObject());
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.UNLIMITED;
    }

    @Override
    public ChannelList getChannels() {
        return this.list;
    }

    @Override
    public void sendCoordsToServer(IInfo info, int channelID) {
        if (info instanceof MonitoredBlockCoords) {
            this.lastSelected.setCoords(((MonitoredBlockCoords)info).getCoords());
            this.sendByteBufPacket(-3);
        }
        if (info instanceof MonitoredEntity) {
            this.lastSelectedUUID.setObject(((MonitoredEntity)info).getUUID());
            this.sendByteBufPacket(-4);
        }
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.isClient()) {
            this.requestSyncPacket();
        }
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)PL2Properties.ORIENTATION, (Comparable)this.getCableFace()).func_177226_a(TRANSFER, (Comparable)((Object)this.transferMode.getObject()));
    }

    @Override
    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PL2Properties.ORIENTATION, TRANSFER});
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -4: {
                this.lastSelectedUUID.writeToBuf(buf);
                break;
            }
            case -3: {
                this.lastSelected.writeToBuf(buf);
                break;
            }
            case 1: {
                this.list.writeToBuf(buf);
                break;
            }
            case 2: {
                this.items.writeToBuf(buf);
                this.fluids.writeToBuf(buf);
                this.energy.writeToBuf(buf);
                break;
            }
            case 3: {
                this.transferMode.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -4: {
                this.lastSelectedUUID.readFromBuf(buf);
                this.list.give(this.lastSelectedUUID.getUUID());
                this.sendByteBufPacket(1);
                break;
            }
            case -3: {
                this.lastSelected.readFromBuf(buf);
                this.list.give(this.lastSelected.getCoords());
                this.sendByteBufPacket(1);
                break;
            }
            case 1: {
                this.list.readFromBuf(buf);
                break;
            }
            case 2: {
                this.items.readFromBuf(buf);
                this.fluids.readFromBuf(buf);
                this.energy.readFromBuf(buf);
                break;
            }
            case 3: {
                this.transferMode.readFromBuf(buf);
                this.sendSyncPacket();
                this.sendUpdatePacket(true);
            }
        }
    }

    @Override
    public boolean hasStandardGui() {
        return true;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerFilterList(player, this);
            }
            case 1: {
                return new ContainerChannelSelection(this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiFilterList(player, this, id);
            }
            case 1: {
                return new GuiChannelSelection(player, this, 0);
            }
        }
        return null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
                break;
            }
            case 1: {
                this.sendNetworkCoordMap(player);
                this.list.markDirty();
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.TRANSFER_NODE;
    }
}

