/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.readers;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.common.multiparts.readers.AbstractListReaderPart;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.info.LogicInfoRegistry;
import sonar.logistics.info.types.InfoError;
import sonar.logistics.info.types.ProgressInfo;
import sonar.logistics.network.sync.SyncMonitoredType;

public abstract class AbstractInfoReaderPart<T extends IProvidableInfo>
extends AbstractListReaderPart<T> {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK, TileMessage.NO_DATA_SELECTED};
    private List<SyncMonitoredType<T>> selected = Lists.newArrayListWithCapacity((int)this.getMaxInfo());
    private List<SyncMonitoredType<T>> paired = Lists.newArrayListWithCapacity((int)this.getMaxInfo());

    public AbstractInfoReaderPart() {
        for (int i = 0; i < this.getMaxInfo(); ++i) {
            this.selected.add(i, new SyncMonitoredType(i + 10));
            this.paired.add(i, new SyncMonitoredType(i + 10 + 100));
        }
        this.syncList.addParts(this.selected);
        this.syncList.addParts(this.paired);
    }

    public List<T> getCachedInfo(List<SyncMonitoredType<T>> parts) {
        ArrayList cached = Lists.newArrayList();
        parts.forEach(i -> cached.add(i.getMonitoredInfo()));
        return cached;
    }

    public List<T> getSelectedInfo() {
        return this.getCachedInfo(this.selected);
    }

    public List<T> getPairedInfo() {
        return this.getCachedInfo(this.paired);
    }

    public void addInfo(T info, int type, int newPos) {
        List<SyncMonitoredType<T>> syncInfo;
        List<SyncMonitoredType<T>> list = syncInfo = type == 0 ? this.selected : this.paired;
        if (newPos == -1) {
            int pos = 0;
            for (SyncMonitoredType sync : syncInfo) {
                IProvidableInfo pInfo = (IProvidableInfo)sync.getMonitoredInfo();
                if (pInfo != null) {
                    if (InfoHelper.isMatchingInfo(pInfo, info)) {
                        sync.setInfo(null);
                        (type != 0 ? this.selected : this.paired).get(pos).setInfo(null);
                        this.sendByteBufPacket(100);
                        this.lastPos = -1;
                        return;
                    }
                } else if (newPos == -1) {
                    newPos = pos;
                }
                ++pos;
            }
        } else {
            this.lastPos = newPos;
        }
        syncInfo.get(newPos == -1 ? 0 : newPos).setInfo((IInfo<T>)info);
        this.sendSyncPacket();
    }

    @Override
    public void setMonitoredInfo(MonitoredList<T> updateInfo, List<NodeConnection> usedChannels, InfoUUID uuid) {
        List<T> selected = this.getSelectedInfo();
        List<T> paired = this.getPairedInfo();
        for (int i = 0; i < this.getMaxInfo(); ++i) {
            IInfo<InfoError> latestInfo = null;
            InfoUUID id = new InfoUUID(this.getIdentity(), i);
            Pair<Boolean, IProvidableInfo> info = LogicInfoRegistry.INSTANCE.getLatestInfo(updateInfo, usedChannels, (IProvidableInfo)selected.get(i));
            Pair<Boolean, IProvidableInfo> pair = LogicInfoRegistry.INSTANCE.getLatestInfo(updateInfo, usedChannels, (IProvidableInfo)paired.get(i));
            if (info != null && ((Boolean)info.a).booleanValue()) {
                latestInfo = pair != null && ProgressInfo.isStorableInfo((IInfo)pair.b) && ProgressInfo.isStorableInfo((IInfo)info.b) ? new ProgressInfo((IInfo)info.b, (IInfo)pair.b) : (info != null ? (IInfo)info.b : InfoError.noData);
            }
            PL2.getServerManager().changeInfo(id, latestInfo);
        }
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        if (id == 100) {
            for (SyncMonitoredType<T> sync : this.selected) {
                sync.writeToBuf(buf);
            }
            for (SyncMonitoredType<T> sync : this.paired) {
                sync.writeToBuf(buf);
            }
        }
        switch (id) {
            case -10: 
            case -9: {
                this.selectedInfo.writeToBuf(buf);
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        if (id == 100) {
            for (SyncMonitoredType<T> sync : this.selected) {
                sync.readFromBuf(buf);
            }
            for (SyncMonitoredType<T> sync : this.paired) {
                sync.readFromBuf(buf);
            }
        }
        switch (id) {
            case -10: {
                this.selectedInfo.readFromBuf(buf);
                this.addInfo((IProvidableInfo)this.selectedInfo.info, 1, this.lastPos);
                break;
            }
            case -9: {
                this.selectedInfo.readFromBuf(buf);
                this.addInfo((IProvidableInfo)this.selectedInfo.info, 0, -1);
            }
        }
    }
}

