/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.readers;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.energy.StoredEnergyStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncEnergyType;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.networks.INetworkListHandler;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.readers.EnergyReader;
import sonar.logistics.api.utils.ChannelType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.client.gui.GuiEnergyReader;
import sonar.logistics.common.containers.ContainerEnergyReader;
import sonar.logistics.common.multiparts.readers.AbstractListReaderPart;
import sonar.logistics.connections.handlers.EnergyNetworkHandler;
import sonar.logistics.helpers.EnergyHelper;
import sonar.logistics.info.types.BaseInfo;
import sonar.logistics.info.types.LogicInfoList;
import sonar.logistics.info.types.MonitoredBlockCoords;
import sonar.logistics.info.types.MonitoredEnergyStack;

public class EnergyReaderPart
extends AbstractListReaderPart<MonitoredEnergyStack>
implements IByteBufTile {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK};
    public SyncCoords selected = new SyncCoords(1);
    public SyncEnum<SortingDirection> sortingOrder = (SyncEnum)new SyncEnum((Enum[])SortingDirection.values(), 2).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<EnergyReader.Modes> setting = (SyncEnum)new SyncEnum((Enum[])EnergyReader.Modes.values(), 3).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnergyType energyType = new SyncEnergyType(4);

    public EnergyReaderPart() {
        this.syncList.addParts(new IDirtyPart[]{this.selected, this.sortingOrder, this.setting, this.energyType});
    }

    @Override
    public List<INetworkListHandler> addValidHandlers(List<INetworkListHandler> handlers) {
        handlers.add(EnergyNetworkHandler.INSTANCE);
        return handlers;
    }

    @Override
    public MonitoredList<MonitoredEnergyStack> sortMonitoredList(MonitoredList<MonitoredEnergyStack> updateInfo, int channelID) {
        EnergyHelper.sortEnergyList(updateInfo, (SortingDirection)this.sortingOrder.getObject(), EnergyReader.SortingType.NAME);
        return updateInfo;
    }

    @Override
    public void setMonitoredInfo(MonitoredList<MonitoredEnergyStack> updateInfo, List<NodeConnection> usedChannels, InfoUUID uuid) {
        BaseInfo info = null;
        block0 : switch ((EnergyReader.Modes)this.setting.getObject()) {
            case STORAGE: {
                if (this.selected.getCoords() == null) break;
                for (MonitoredEnergyStack stack : updateInfo) {
                    if (!stack.getMonitoredCoords().getCoords().equals((Object)this.selected.getCoords())) continue;
                    MonitoredEnergyStack convert = stack.copy();
                    convert.getEnergyStack().convertEnergyType(this.energyType.getEnergyType());
                    info = convert;
                    break block0;
                }
                break;
            }
            case STORAGES: {
                info = new LogicInfoList(this.getIdentity(), "energy", this.getNetworkID());
                break;
            }
            case TOTAL: {
                MonitoredEnergyStack energy = new MonitoredEnergyStack(new StoredEnergyStack(this.energyType.getEnergyType()), new MonitoredBlockCoords(this.getCoords(), this.getDisplayName()), new StoredItemStack(this.getItemStack()));
                for (MonitoredEnergyStack stack : updateInfo.cloneInfo()) {
                    MonitoredEnergyStack convert = stack.copy();
                    convert.getEnergyStack().convertEnergyType(this.energyType.getEnergyType());
                    energy = (MonitoredEnergyStack)energy.joinInfo(convert);
                }
                info = energy;
                break;
            }
        }
        PL2.getServerManager().changeInfo(uuid, info);
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.UNLIMITED;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -10: 
            case -9: {
                this.selected.writeToBuf(buf);
                return;
            }
        }
        super.writePacket(buf, id);
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -9: {
                this.selected.readFromBuf(buf);
                return;
            }
        }
        super.readPacket(buf, id);
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerEnergyReader(player, this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiEnergyReader(player, this);
            }
        }
        return null;
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.ENERGY_READER;
    }
}

