/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.readers;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.Pair;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.networks.INetworkListHandler;
import sonar.logistics.api.register.RegistryType;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.readers.FluidReader;
import sonar.logistics.api.utils.ChannelType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.client.gui.GuiFluidReader;
import sonar.logistics.client.gui.generic.GuiChannelSelection;
import sonar.logistics.common.containers.ContainerChannelSelection;
import sonar.logistics.common.containers.ContainerFluidReader;
import sonar.logistics.common.multiparts.readers.AbstractListReaderPart;
import sonar.logistics.connections.channels.FluidNetworkChannels;
import sonar.logistics.connections.handlers.FluidNetworkHandler;
import sonar.logistics.helpers.FluidHelper;
import sonar.logistics.info.types.LogicInfo;
import sonar.logistics.info.types.LogicInfoList;
import sonar.logistics.info.types.MonitoredFluidStack;
import sonar.logistics.info.types.ProgressInfo;
import sonar.logistics.network.sync.SyncMonitoredType;

public class FluidReaderPart
extends AbstractListReaderPart<MonitoredFluidStack>
implements IByteBufTile {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK, TileMessage.NO_FLUID_SELECTED};
    public SyncMonitoredType<MonitoredFluidStack> selected = new SyncMonitoredType(1);
    public SyncEnum<FluidReader.Modes> setting = (SyncEnum)new SyncEnum((Enum[])FluidReader.Modes.values(), 2).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncTagType.INT targetSlot = (SyncTagType.INT)new SyncTagType.INT(3).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncTagType.INT posSlot = (SyncTagType.INT)new SyncTagType.INT(4).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<SortingDirection> sortingOrder = (SyncEnum)new SyncEnum((Enum[])SortingDirection.values(), 5).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<FluidReader.SortingType> sortingType = (SyncEnum)new SyncEnum((Enum[])FluidReader.SortingType.values(), 6).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});

    public FluidReaderPart() {
        this.syncList.addParts(new IDirtyPart[]{this.setting, this.targetSlot, this.posSlot, this.sortingOrder, this.sortingType, this.selected});
    }

    @Override
    public List<INetworkListHandler> addValidHandlers(List<INetworkListHandler> handlers) {
        handlers.add(FluidNetworkHandler.INSTANCE);
        return handlers;
    }

    @Override
    public MonitoredList<MonitoredFluidStack> sortMonitoredList(MonitoredList<MonitoredFluidStack> updateInfo, int channelID) {
        FluidHelper.sortFluidList(updateInfo, (SortingDirection)this.sortingOrder.getObject(), (FluidReader.SortingType)this.sortingType.getObject());
        return updateInfo;
    }

    @Override
    public void setMonitoredInfo(MonitoredList<MonitoredFluidStack> updateInfo, List<NodeConnection> usedChannels, InfoUUID uuid) {
        INameableInfo<LogicInfoList> info = null;
        switch ((FluidReader.Modes)this.setting.getObject()) {
            case SELECTED: {
                MonitoredFluidStack stack = this.selected.getMonitoredInfo();
                if (stack == null || !stack.isValid()) break;
                stack.getStoredStack().setStackSize(0L);
                MonitoredFluidStack dummyInfo = stack.copy();
                Pair<Boolean, IInfo> latestInfo = updateInfo.getLatestInfo(dummyInfo);
                info = (Boolean)latestInfo.a != false ? (IInfo)latestInfo.b : dummyInfo;
                break;
            }
            case POS: {
                break;
            }
            case STORAGE: {
                info = new ProgressInfo(LogicInfo.buildDirectInfo("fluid.storage", RegistryType.TILE, updateInfo.sizing.getStored()), LogicInfo.buildDirectInfo("max", RegistryType.TILE, updateInfo.sizing.getMaxStored()));
                break;
            }
            case TANKS: {
                info = new LogicInfoList(this.getIdentity(), "fluid", this.getNetworkID());
                break;
            }
        }
        PL2.getServerManager().changeInfo(uuid, info);
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.UNLIMITED;
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        FluidNetworkChannels list;
        super.readPacket(buf, id);
        if ((id == 5 || id == 6) && (list = this.network.getNetworkChannels(FluidNetworkChannels.class)) != null) {
            List players = this.listeners.getListeners(new Enum[]{ListenerType.INFO});
            players.forEach(player -> list.sendLocalRapidUpdate(this, (EntityPlayer)player.player));
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerFluidReader(this, player);
            }
            case 1: {
                return new ContainerChannelSelection(this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiFluidReader(this, player);
            }
            case 1: {
                return new GuiChannelSelection(player, this, 0);
            }
        }
        return null;
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.FLUID_READER;
    }
}

