/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.readers;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.inventory.SonarMultipartInventory;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.Pair;
import sonar.core.utils.SortingDirection;
import sonar.logistics.PL2;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.filters.IFilteredTile;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.INameableInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.networks.INetworkListHandler;
import sonar.logistics.api.register.RegistryType;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.EntityConnection;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.tiles.readers.InventoryReader;
import sonar.logistics.api.utils.ChannelType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.client.gui.GuiInventoryReader;
import sonar.logistics.client.gui.generic.GuiChannelSelection;
import sonar.logistics.client.gui.generic.GuiFilterList;
import sonar.logistics.common.containers.ContainerChannelSelection;
import sonar.logistics.common.containers.ContainerFilterList;
import sonar.logistics.common.containers.ContainerInventoryReader;
import sonar.logistics.common.multiparts.readers.AbstractListReaderPart;
import sonar.logistics.connections.channels.ItemNetworkChannels;
import sonar.logistics.connections.handlers.ItemNetworkHandler;
import sonar.logistics.helpers.ItemHelper;
import sonar.logistics.info.types.LogicInfo;
import sonar.logistics.info.types.LogicInfoList;
import sonar.logistics.info.types.MonitoredItemStack;
import sonar.logistics.info.types.ProgressInfo;
import sonar.logistics.network.sync.SyncFilterList;

public class InventoryReaderPart
extends AbstractListReaderPart<MonitoredItemStack>
implements IByteBufTile,
IFilteredTile {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK, TileMessage.NO_STACK_SELECTED};
    public SonarMultipartInventory inventory = new SonarMultipartInventory((SonarMultipart)this, 1);
    public SyncEnum<InventoryReader.Modes> setting = (SyncEnum)new SyncEnum((Enum[])InventoryReader.Modes.values(), 2).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncTagType.INT targetSlot = (SyncTagType.INT)new SyncTagType.INT(3).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncTagType.INT posSlot = (SyncTagType.INT)new SyncTagType.INT(4).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<SortingDirection> sortingOrder = (SyncEnum)new SyncEnum((Enum[])SortingDirection.values(), 5).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<InventoryReader.SortingType> sortingType = (SyncEnum)new SyncEnum((Enum[])InventoryReader.SortingType.values(), 6).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncFilterList filters = new SyncFilterList(9);

    public InventoryReaderPart() {
        this.syncList.addParts(new IDirtyPart[]{this.inventory, this.setting, this.targetSlot, this.posSlot, this.sortingOrder, this.sortingType, this.filters});
    }

    @Override
    public List<INetworkListHandler> addValidHandlers(List<INetworkListHandler> handlers) {
        handlers.add(ItemNetworkHandler.INSTANCE);
        return handlers;
    }

    @Override
    public MonitoredList<MonitoredItemStack> sortMonitoredList(MonitoredList<MonitoredItemStack> updateInfo, int channelID) {
        ItemHelper.sortItemList(updateInfo, (SortingDirection)this.sortingOrder.getObject(), (InventoryReader.SortingType)this.sortingType.getObject());
        return updateInfo;
    }

    public boolean canMonitorInfo(MonitoredItemStack info, int infoID, Map<NodeConnection, MonitoredList<?>> channels, List<NodeConnection> usedChannels) {
        if (this.setting.getObject() == InventoryReader.Modes.FILTERED) {
            return this.filters.matches(info.getStoredStack(), NodeTransferMode.ADD_REMOVE);
        }
        return true;
    }

    @Override
    public void setMonitoredInfo(MonitoredList<MonitoredItemStack> updateInfo, List<NodeConnection> usedChannels, InfoUUID uuid) {
        INameableInfo<LogicInfoList> info = null;
        switch ((InventoryReader.Modes)this.setting.getObject()) {
            case INVENTORIES: 
            case FILTERED: {
                info = new LogicInfoList(this.getIdentity(), "item", this.getNetworkID());
                break;
            }
            case POS: {
                int pos = (Integer)this.posSlot.getObject();
                if (pos >= updateInfo.size()) break;
                MonitoredItemStack posItem = ((MonitoredItemStack)updateInfo.get((Integer)this.posSlot.getObject())).copy();
                posItem.setNetworkSource(this.network.getNetworkID());
                info = posItem;
                break;
            }
            case SLOT: {
                NodeConnection connection;
                StoredItemStack slotStack = null;
                if (!usedChannels.isEmpty() && (connection = usedChannels.get(0)) != null) {
                    if (connection instanceof BlockConnection) {
                        slotStack = ItemHelper.getTileStack((BlockConnection)connection, (Integer)this.targetSlot.getObject());
                    }
                    if (connection instanceof EntityConnection) {
                        slotStack = ItemHelper.getEntityStack((EntityConnection)connection, (Integer)this.targetSlot.getObject());
                    }
                }
                if (slotStack == null) break;
                MonitoredItemStack newInfo = new MonitoredItemStack(slotStack);
                newInfo.setNetworkSource(this.network.getNetworkID());
                info = newInfo;
                break;
            }
            case STACK: {
                ItemStack stack = this.inventory.func_70301_a(0);
                if (stack == null) break;
                MonitoredItemStack dummyInfo = new MonitoredItemStack(new StoredItemStack(stack.func_77946_l(), 0L), this.network.getNetworkID());
                Pair<Boolean, IInfo> latestInfo = updateInfo.getLatestInfo(dummyInfo);
                if (latestInfo.b instanceof MonitoredItemStack) {
                    ((MonitoredItemStack)latestInfo.b).setNetworkSource(this.network.getNetworkID());
                }
                info = (Boolean)latestInfo.a != false ? (IInfo)latestInfo.b : dummyInfo;
                break;
            }
            case STORAGE: {
                info = new ProgressInfo(LogicInfo.buildDirectInfo("item.storage", RegistryType.TILE, updateInfo.sizing.getStored()), LogicInfo.buildDirectInfo("max", RegistryType.TILE, updateInfo.sizing.getMaxStored()));
                break;
            }
        }
        PL2.getServerManager().changeInfo(uuid, info);
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.UNLIMITED;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        ItemNetworkChannels list;
        super.readPacket(buf, id);
        if ((id == 5 || id == 6) && (list = this.network.getNetworkChannels(ItemNetworkChannels.class)) != null) {
            List players = this.listeners.getListeners(new Enum[]{ListenerType.INFO});
            players.forEach(player -> list.sendLocalRapidUpdate(this, (EntityPlayer)player.player));
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerInventoryReader(this, player);
            }
            case 1: {
                return new ContainerChannelSelection(this);
            }
            case 2: {
                return new ContainerFilterList(player, this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiInventoryReader(this, player);
            }
            case 1: {
                return new GuiChannelSelection(player, this, 0);
            }
            case 2: {
                return new GuiFilterList(player, this, 0);
            }
        }
        return null;
    }

    public boolean allowed(ItemStack stack) {
        return this.filters.matches(new StoredItemStack(stack), NodeTransferMode.ADD_REMOVE);
    }

    @Override
    public SyncFilterList getFilters() {
        return this.filters;
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.INVENTORY_READER;
    }
}

