/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.wireless;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.inventory.ContainerMultipartSync;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.PlayerListener;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.networks.INetworkChannels;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.networks.INetworkListHandler;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.api.wireless.DataEmitterSecurity;
import sonar.logistics.api.wireless.IDataEmitter;
import sonar.logistics.client.gui.GuiDataEmitter;
import sonar.logistics.common.multiparts.wireless.AbstractWirelessPart;
import sonar.logistics.connections.channels.ListNetworkChannels;
import sonar.logistics.connections.handlers.FluidNetworkHandler;
import sonar.logistics.connections.handlers.ItemNetworkHandler;
import sonar.logistics.info.types.MonitoredFluidStack;
import sonar.logistics.info.types.MonitoredItemStack;
import sonar.logistics.managers.WirelessManager;

public class DataEmitterPart
extends AbstractWirelessPart
implements IDataEmitter,
IFlexibleGui,
IByteBufTile {
    public static int STATIC_ITEM_ID = -16;
    public static int STATIC_FLUID_ID = -17;
    public static final String UNNAMED = "Unnamed Emitter";
    public ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, ListenerType.ALL.size());
    public List<INetworkListHandler> validHandlers;
    public SyncTagType.STRING emitterName = (SyncTagType.STRING)new SyncTagType.STRING(2).setDefault((Object)"Unnamed Emitter");
    public SyncEnum<DataEmitterSecurity> security = new SyncEnum((Enum[])DataEmitterSecurity.values(), 5);

    public DataEmitterPart() {
        this.syncList.addParts(new IDirtyPart[]{this.emitterName, this.security});
    }

    @Override
    public boolean canPlayerConnect(UUID uuid) {
        return this.playerUUID.getUUID().equals(uuid);
    }

    @Override
    public String getEmitterName() {
        return (String)this.emitterName.getObject();
    }

    @Override
    public DataEmitterSecurity getSecurity() {
        return (DataEmitterSecurity)this.security.getObject();
    }

    @Override
    public MonitoredList<MonitoredItemStack> getServerItems() {
        return PL2.getServerManager().getMonitoredList(this.getNetworkID(), new InfoUUID(this.getIdentity(), STATIC_ITEM_ID));
    }

    @Override
    public MonitoredList<MonitoredFluidStack> getServerFluids() {
        return PL2.getServerManager().getMonitoredList(this.getNetworkID(), new InfoUUID(this.getIdentity(), STATIC_FLUID_ID));
    }

    public void writePacket(ByteBuf buf, int id) {
        ISyncPart part = NBTHelper.getSyncPartByID((ArrayList)this.syncList.getStandardSyncParts(), (int)id);
        if (part != null) {
            part.writeToBuf(buf);
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        ISyncPart part = NBTHelper.getSyncPartByID((ArrayList)this.syncList.getStandardSyncParts(), (int)id);
        if (part != null) {
            part.readFromBuf(buf);
        }
        if (id == 5) {
            WirelessManager.emitterChanged(this);
        }
    }

    @Override
    public boolean hasStandardGui() {
        return true;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerMultipartSync((SonarMultipart)this) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiDataEmitter(this) : null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
            }
        }
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    @Override
    public MonitoredList sortMonitoredList(MonitoredList updateInfo, int channelID) {
        return updateInfo;
    }

    @Override
    public void sendRapidUpdate(EntityPlayer player) {
        SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
        for (INetworkHandler iNetworkHandler : this.getValidHandlers()) {
            INetworkChannels list = this.network.getNetworkChannels(iNetworkHandler.getChannelsType());
            if (list == null || !(list instanceof ListNetworkChannels)) continue;
            ((ListNetworkChannels)list).sendLocalRapidUpdate(this, player);
        }
    }

    @Override
    public MonitoredList<IInfo> getUpdatedList(InfoUUID uuid, Map<NodeConnection, MonitoredList<IInfo>> channels, List<NodeConnection> usedChannels) {
        MonitoredList<IInfo> updateList = MonitoredList.newMonitoredList(this.getNetworkID());
        for (Map.Entry<NodeConnection, MonitoredList<IInfo>> entry : channels.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            for (IInfo coordInfo : entry.getValue()) {
                updateList.addInfoToList(coordInfo, entry.getValue());
            }
            updateList.sizing.add(entry.getValue().sizing);
            usedChannels.add(entry.getKey());
        }
        return updateList;
    }

    @Override
    public List<INetworkListHandler> getValidHandlers() {
        if (this.validHandlers == null) {
            this.validHandlers = Lists.newArrayList((Object[])new INetworkListHandler[]{ItemNetworkHandler.INSTANCE, FluidNetworkHandler.INSTANCE});
        }
        return this.validHandlers;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.DATA_EMITTER;
    }
}

