/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.common.multiparts.wireless;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.IFlexibleGui;
import sonar.core.integration.multipart.SonarMultipart;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncNBTAbstractList;
import sonar.core.network.utils.IByteBufTile;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.api.states.TileMessage;
import sonar.logistics.api.wireless.ClientDataEmitter;
import sonar.logistics.api.wireless.IDataEmitter;
import sonar.logistics.api.wireless.IDataReceiver;
import sonar.logistics.client.gui.GuiDataReceiver;
import sonar.logistics.common.containers.ContainerDataReceiver;
import sonar.logistics.common.multiparts.wireless.AbstractWirelessPart;
import sonar.logistics.managers.WirelessManager;

public class DataReceiverPart
extends AbstractWirelessPart
implements IDataReceiver,
IFlexibleGui,
IByteBufTile {
    public static final TileMessage[] validStates = new TileMessage[]{TileMessage.NO_NETWORK, TileMessage.NO_EMITTERS_CONNECTED, TileMessage.EMITTERS_OFFLINE};
    public SyncNBTAbstractList<ClientDataEmitter> clientEmitters = new SyncNBTAbstractList(ClientDataEmitter.class, 2);
    public SyncNBTAbstract<ClientDataEmitter> selectedEmitter = new SyncNBTAbstract(ClientDataEmitter.class, 4);
    public List<Integer> networks = Lists.newArrayList();

    public DataReceiverPart() {
        this.syncList.addParts(new IDirtyPart[]{this.clientEmitters, this.selectedEmitter});
    }

    public void updateStates() {
        this.states.markTileMessage(TileMessage.NO_EMITTERS_CONNECTED, this.clientEmitters.getObjects().isEmpty());
        this.states.markTileMessage(TileMessage.EMITTERS_OFFLINE, !this.clientEmitters.getObjects().isEmpty() && this.networks.isEmpty());
    }

    public void addEmitterFromClient(ClientDataEmitter emitter) {
        ArrayList emitters = Lists.newArrayList((Iterable)this.clientEmitters.getObjects());
        Iterator iterator = emitters.iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            ClientDataEmitter entry = (ClientDataEmitter)iterator.next();
            if (!entry.equals(emitter)) continue;
            IDataEmitter tile = WirelessManager.getEmitter(entry.getIdentity());
            iterator.remove();
            found = true;
            break;
        }
        if (!found) {
            IDataEmitter tile = WirelessManager.getEmitter(emitter.getIdentity());
            emitters.add(emitter);
        }
        this.clientEmitters.setObjects((List)emitters);
        this.networks = this.getNetworks();
        WirelessManager.receiverChanged(this);
        this.sendSyncPacket();
        this.updateStates();
    }

    @Override
    public List<Integer> getConnectedNetworks() {
        return this.networks;
    }

    @Override
    public void refreshConnectedNetworks() {
        this.networks = this.getNetworks();
        this.updateStates();
    }

    public List<Integer> getNetworks() {
        ArrayList networks = Lists.newArrayList();
        List<IDataEmitter> emitters = this.getEmitters();
        for (IDataEmitter emitter : emitters) {
            if (emitter.getNetworkID() == -1) continue;
            networks.add(emitter.getNetworkID());
        }
        return networks;
    }

    public List<IDataEmitter> getEmitters() {
        ArrayList emitters = Lists.newArrayList();
        for (ClientDataEmitter dataEmitter : this.clientEmitters.getObjects()) {
            IDataEmitter emitter = WirelessManager.getEmitter(dataEmitter.getIdentity());
            if (emitter == null || !emitter.canPlayerConnect(this.playerUUID.getUUID())) continue;
            emitters.add(emitter);
        }
        return emitters;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.selectedEmitter.writeToBuf(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.selectedEmitter.readFromBuf(buf);
                this.addEmitterFromClient(((ClientDataEmitter)this.selectedEmitter.getObject()).copy());
            }
        }
    }

    @Override
    public boolean hasStandardGui() {
        return true;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new ContainerDataReceiver(this) : null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return id == 0 ? new GuiDataReceiver(this) : null;
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                SonarMultipartHelper.sendMultipartSyncToPlayer((SonarMultipart)this, (EntityPlayerMP)((EntityPlayerMP)player));
                WirelessManager.addViewer(player);
            }
        }
    }

    @Override
    public TileMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public PL2Multiparts getMultipart() {
        return PL2Multiparts.DATA_RECEIVER;
    }
}

