/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.connections;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ISonarListener;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkChannels;
import sonar.logistics.api.networks.INetworkListener;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.readers.IInfoProvider;
import sonar.logistics.api.utils.CacheType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.connections.CacheHandler;
import sonar.logistics.connections.NetworkUpdate;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.helpers.LogisticsHelper;
import sonar.logistics.helpers.PacketHelper;
import sonar.logistics.network.PacketChannels;

public class LogisticsNetwork
implements ILogisticsNetwork {
    public final ListenableList<ILogisticsNetwork> subNetworks = new ListenableList((ISonarListenable)this, 2);
    public final Map<Class, INetworkChannels> handlers = Maps.newLinkedHashMap();
    public final List<IInfoProvider> localProviders = Lists.newArrayList();
    private List<NetworkUpdate> toUpdate = SonarHelper.convertArray((Object[])NetworkUpdate.values());
    private List<CacheHandler> changedCaches = Lists.newArrayList(CacheHandler.handlers);
    private Map<CacheHandler, List> caches = LogisticsHelper.getCachesMap();
    public Queue<INetworkListener> toAdd = new ConcurrentLinkedQueue<INetworkListener>();
    public Queue<INetworkListener> toRemove = new ConcurrentLinkedQueue<INetworkListener>();
    private List<NodeConnection> localChannels = Lists.newArrayList();
    private List<NodeConnection> globalChannels = Lists.newArrayList();
    private List<NodeConnection> allChannels = Lists.newArrayList();
    public int networkID;
    public boolean isValid = true;

    public LogisticsNetwork(int networkID) {
        this.networkID = networkID;
    }

    @Override
    public void onNetworkCreated() {
    }

    @Override
    public void onNetworkTick() {
        this.addConnections();
        this.removeConnections();
        this.updateCaches();
        this.runNetworkUpdates();
        this.updateNetworkHandlers();
    }

    @Override
    public void onNetworkRemoved() {
        this.isValid = false;
        List watching = this.subNetworks.getListeners(new int[]{1});
        watching.forEach(network -> network.getListenerList().removeListener((ISonarListener)this, true, new int[]{0}));
        this.subNetworks.invalidateList();
        this.getCachedTiles(CacheHandler.TILE, CacheType.LOCAL).forEach(TILE -> CacheHandler.TILE.onConnectionRemoved(this, (INetworkListener)TILE));
        this.handlers.values().forEach(CHANNELS2 -> CHANNELS2.onDeleted());
        this.caches.clear();
        this.handlers.clear();
    }

    @Override
    public void onCablesChanged() {
        this.caches = LogisticsHelper.getCachesMap();
        PL2.getCableManager().getConnections(this.networkID).forEach(cable -> cable.addConnections(this));
        this.updateChannels();
    }

    @Override
    public void onCacheChanged(CacheHandler ... caches) {
        for (CacheHandler cache : caches) {
            if (this.changedCaches.contains(cache)) continue;
            this.changedCaches.add(cache);
        }
    }

    public void updateCaches() {
        if (!this.changedCaches.isEmpty()) {
            this.changedCaches.forEach(handler -> handler.update(this, this.caches.get(handler)));
            this.changedCaches.clear();
        }
    }

    @Override
    public void markUpdate(NetworkUpdate ... updates) {
        for (NetworkUpdate update : updates) {
            if (this.toUpdate.contains((Object)update)) continue;
            this.toUpdate.add(update);
        }
    }

    private void runNetworkUpdates() {
        if (!this.toUpdate.isEmpty()) {
            block6: for (NetworkUpdate update : NetworkUpdate.values()) {
                if (!this.toUpdate.contains((Object)update)) continue;
                switch (update) {
                    case GLOBAL: {
                        this.updateGlobalChannels();
                        continue block6;
                    }
                    case HANDLER_CHANNELS: {
                        this.updateHandlerChannels();
                        continue block6;
                    }
                    case LOCAL: {
                        this.updateLocalChannels();
                        continue block6;
                    }
                    case SUB_NETWORKS: {
                        this.updateSubNetworks();
                    }
                }
            }
            this.toUpdate.clear();
        }
    }

    @Override
    public boolean validateTile(INetworkListener listener) {
        if (!listener.isValid()) {
            this.removeConnection(listener);
            return false;
        }
        return true;
    }

    @Override
    public void onConnectionChanged(INetworkListener tile) {
        if (this.validateTile(tile)) {
            CacheHandler.getValidCaches(tile).forEach(cache -> {
                if (!this.changedCaches.contains(cache)) {
                    this.changedCaches.add((CacheHandler)cache);
                }
            });
        }
    }

    @Override
    public void addConnection(INetworkListener tile) {
        this.toAdd.add(tile);
        this.toRemove.remove(tile);
    }

    @Override
    public void removeConnection(INetworkListener tile) {
        this.toRemove.add(tile);
        this.toAdd.remove(tile);
    }

    @Override
    public void addConnections() {
        if (this.toAdd.isEmpty()) {
            return;
        }
        Iterator iterator = this.toAdd.iterator();
        while (iterator.hasNext()) {
            INetworkListener tile = (INetworkListener)iterator.next();
            CacheHandler.getValidCaches(tile).forEach(cache -> {
                if (!this.caches.get(cache).contains(tile) && this.caches.get(cache).add(tile)) {
                    this.onCacheChanged((CacheHandler)cache);
                    cache.onConnectionAdded(this, tile);
                }
            });
            iterator.remove();
        }
    }

    @Override
    public void removeConnections() {
        if (this.toRemove.isEmpty()) {
            return;
        }
        Iterator iterator = this.toRemove.iterator();
        while (iterator.hasNext()) {
            INetworkListener tile = (INetworkListener)iterator.next();
            CacheHandler.getValidCaches(tile).forEach(cache -> {
                if (this.caches.get(cache).remove(tile)) {
                    this.onCacheChanged((CacheHandler)cache);
                    cache.onConnectionRemoved(this, tile);
                }
            });
            iterator.remove();
        }
    }

    @Override
    public void addLocalInfoProvider(IInfoProvider monitor) {
        if (!this.localProviders.contains(monitor)) {
            this.localProviders.add(monitor);
        }
    }

    @Override
    public void removeLocalInfoProvider(IInfoProvider monitor) {
        this.localProviders.remove(monitor);
    }

    public void onListenerAdded(ListenerTally<ILogisticsNetwork> tally) {
        if (tally.listener == this) {
            return;
        }
        ((ILogisticsNetwork)tally.listener).getListenerList().addListener((ISonarListener)this, new int[]{0});
    }

    public void onListenerRemoved(ListenerTally<ILogisticsNetwork> tally) {
        if (tally.listener == this) {
            return;
        }
        ((ILogisticsNetwork)tally.listener).getListenerList().removeListener((ISonarListener)this, true, new int[]{0});
    }

    public void onSubListenableAdded(ISonarListenable<ILogisticsNetwork> listen) {
    }

    public void onSubListenableRemoved(ISonarListenable<ILogisticsNetwork> listen) {
    }

    public ListenableList<ILogisticsNetwork> getListenerList() {
        return this.subNetworks;
    }

    @Override
    public void sendConnectionsPacket(EntityPlayer player) {
        MonitoredList<IInfo> coords = this.createConnectionsList(CacheType.ALL);
        NBTTagCompound channelTag = InfoHelper.writeMonitoredList(new NBTTagCompound(), coords.isEmpty(), coords.copyInfo(), NBTHelper.SyncType.DEFAULT_SYNC);
        if (channelTag.func_82582_d()) {
            return;
        }
        PL2.network.sendTo((IMessage)new PacketChannels(this.getNetworkID(), channelTag), (EntityPlayerMP)player);
    }

    @Override
    public List<NodeConnection> getConnections(CacheType cacheType) {
        switch (cacheType) {
            case GLOBAL: {
                return this.globalChannels;
            }
            case LOCAL: {
                return this.localChannels;
            }
        }
        return this.allChannels;
    }

    private void updateSubNetworks() {
        this.subNetworks.invalidateList();
        this.subNetworks.validateList();
        this.getCachedTiles(CacheHandler.RECEIVERS, CacheType.LOCAL).forEach(r -> {
            if (this.validateTile((INetworkListener)r)) {
                r.refreshConnectedNetworks();
                LogisticsHelper.addConnectedNetworks(this, r);
            }
        });
    }

    private void updateChannels() {
        this.updateLocalChannels();
        this.updateGlobalChannels();
    }

    private void updateLocalChannels() {
        ArrayList channels = Lists.newArrayList();
        LogisticsHelper.sortNodeConnections(channels, this.getCachedTiles(CacheHandler.NODES, CacheType.LOCAL));
        this.localChannels = Lists.newArrayList((Iterable)channels);
    }

    private void updateGlobalChannels() {
        ArrayList channels = Lists.newArrayList();
        LogisticsHelper.sortNodeConnections(channels, this.getCachedTiles(CacheHandler.NODES, CacheType.GLOBAL));
        this.globalChannels = Lists.newArrayList((Iterable)channels);
        ArrayList all = Lists.newArrayList();
        ListHelper.addWithCheck((Collection)all, this.globalChannels);
        ListHelper.addWithCheck((Collection)all, this.localChannels);
        NodeConnection.sortConnections(all);
        this.allChannels = all;
    }

    private void updateNetworkHandlers() {
        this.handlers.values().forEach(CHANNELS2 -> CHANNELS2.updateChannel());
        this.localProviders.forEach(provider -> PacketHelper.sendNormalProviderInfo(provider));
    }

    private void updateHandlerChannels() {
        this.handlers.forEach((H, C) -> C.onChannelsChanged());
    }

    @Override
    public MonitoredList<IInfo> createConnectionsList(CacheType cacheType) {
        MonitoredList<IInfo> list = MonitoredList.newMonitoredList(this.getNetworkID());
        this.getConnections(cacheType).forEach(CHANNEL -> list.add(CHANNEL.getChannel()));
        return list;
    }

    @Override
    public <T> List<T> getCachedTiles(CacheHandler<T> handler, CacheType cacheType) {
        ArrayList tiles;
        ArrayList arrayList = tiles = cacheType.isLocal() ? Lists.newArrayList((Iterable)this.caches.getOrDefault(handler, Lists.newArrayList())) : Lists.newArrayList();
        if (cacheType.isGlobal()) {
            List connected = this.subNetworks.getListeners(new int[]{0});
            connected.forEach(network -> ListHelper.addWithCheck((Collection)tiles, network.getCachedTiles(handler, CacheType.LOCAL)));
        }
        return tiles;
    }

    @Override
    public <T extends INetworkChannels> T getNetworkChannels(Class<T> channelClass) {
        return (T)this.handlers.get(channelClass);
    }

    @Override
    public <T extends INetworkChannels> T getOrCreateNetworkChannels(Class<T> channelClass) {
        return (T)this.handlers.computeIfAbsent(channelClass, c -> (INetworkChannels)LogisticsHelper.getChannelInstance(channelClass, this));
    }

    @Override
    public List<IInfoProvider> getLocalInfoProviders() {
        return this.localProviders;
    }

    @Override
    public IInfoProvider getLocalInfoProvider() {
        return !this.localProviders.isEmpty() ? this.localProviders.get(0) : null;
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

