/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.connections.channels;

import java.util.concurrent.ThreadLocalRandom;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkChannels;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.networks.INetworkListener;
import sonar.logistics.connections.CacheHandler;

public abstract class DefaultNetworkChannels<H extends INetworkHandler>
implements INetworkChannels<H> {
    private final CacheHandler[] caches;
    public final ILogisticsNetwork network;
    private Integer updateTicks = null;

    public DefaultNetworkChannels(ILogisticsNetwork network, CacheHandler ... caches) {
        this.network = network;
        this.caches = caches;
        this.onCreated();
    }

    @Override
    public ILogisticsNetwork getNetwork() {
        return this.network;
    }

    @Override
    public CacheHandler[] getValidCaches() {
        return this.caches;
    }

    protected void updateTicks() {
    }

    private void tick() {
        if (this.updateTicks == null) {
            this.updateTicks = ThreadLocalRandom.current().nextInt(0, this.getUpdateRate() + 1);
            this.updateTicks();
        }
        if (this.updateTicks < this.getUpdateRate()) {
            Integer n = this.updateTicks;
            Integer n2 = this.updateTicks = Integer.valueOf(this.updateTicks + 1);
            return;
        }
        this.updateTicks = 0;
        this.updateTicks();
    }

    public abstract int getUpdateRate();

    @Override
    public void onChannelsChanged() {
    }

    @Override
    public void updateChannel() {
        this.tick();
    }

    @Override
    public void onDeleted() {
    }

    @Override
    public void addConnection(CacheHandler cache, INetworkListener connection) {
    }

    @Override
    public void removeConnection(CacheHandler cache, INetworkListener connection) {
    }
}

