/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.connections.channels;

import javax.annotation.Nullable;
import sonar.logistics.api.info.IProvidableInfo;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.EntityConnection;
import sonar.logistics.api.tiles.readers.ChannelList;
import sonar.logistics.api.tiles.readers.IListReader;
import sonar.logistics.api.tiles.readers.INetworkReader;
import sonar.logistics.api.utils.ChannelType;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.connections.channels.ListNetworkChannels;
import sonar.logistics.connections.handlers.InfoNetworkHandler;

public class InfoNetworkChannels
extends ListNetworkChannels<IProvidableInfo, InfoNetworkHandler> {
    private ChannelList currentList;

    public InfoNetworkChannels(ILogisticsNetwork network) {
        super(InfoNetworkHandler.INSTANCE, network);
    }

    @Override
    public void updateChannel() {
        super.updateChannel();
        for (IListReader reader : this.readers) {
            ((InfoNetworkHandler)this.handler).updateAndSendList(this.network, reader, this.channels, false);
        }
    }

    @Override
    public void updateTickLists() {
        super.updateTickLists();
        this.currentList = this.getChannelsList();
    }

    @Nullable
    public ChannelList getChannelsList() {
        ChannelList list = new ChannelList(-1, ChannelType.NETWORK_SINGLE, this.network.getNetworkID());
        for (IListReader monitor : this.readers) {
            if (!(monitor instanceof INetworkReader) || monitor.getListenerList().getListeners(new Enum[]{ListenerType.FULL_INFO, ListenerType.TEMPORARY}).isEmpty()) continue;
            ChannelList channels = ((INetworkReader)monitor).getChannels();
            list.addAll(channels.getCoords());
            list.addAllUUID(channels.getUUIDs());
        }
        return list;
    }

    @Override
    public boolean isCoordsMonitored(BlockConnection connection) {
        return this.currentList == null || this.currentList.isCoordsMonitored(connection.coords);
    }

    @Override
    public boolean isEntityMonitored(EntityConnection connection) {
        return this.currentList == null || this.currentList.isEntityMonitored(connection.uuid);
    }

    @Override
    public void onDeleted() {
        super.onDeleted();
        this.currentList = null;
    }
}

