/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.connections.channels;

import net.minecraft.entity.player.EntityPlayer;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkListHandler;
import sonar.logistics.api.tiles.readers.IListReader;
import sonar.logistics.api.viewers.ListenerType;
import sonar.logistics.connections.channels.ListNetworkChannels;
import sonar.logistics.connections.handlers.ItemNetworkHandler;
import sonar.logistics.info.types.MonitoredItemStack;

public class ItemNetworkChannels
extends ListNetworkChannels<MonitoredItemStack, INetworkListHandler<MonitoredItemStack>> {
    public boolean updateLargeInventory = false;

    public ItemNetworkChannels(ILogisticsNetwork network) {
        super(ItemNetworkHandler.INSTANCE, network);
    }

    public boolean updateLargeInventory() {
        return this.updateLargeInventory;
    }

    @Override
    public void updateTickLists() {
        super.updateTickLists();
        this.updateLargeInventory = false;
        for (IListReader reader : this.readers) {
            if (reader.getListenerList().getListeners(new Enum[]{ListenerType.FULL_INFO, ListenerType.TEMPORARY}).isEmpty()) continue;
            this.updateLargeInventory = true;
            break;
        }
    }

    @Override
    public void sendFullRapidUpdate() {
        this.updateLargeInventory = true;
        super.sendFullRapidUpdate();
        this.updateLargeInventory = false;
    }

    @Override
    public void sendLocalRapidUpdate(IListReader<MonitoredItemStack> reader, EntityPlayer viewer) {
        this.updateLargeInventory = true;
        super.sendLocalRapidUpdate(reader, viewer);
        this.updateLargeInventory = false;
    }
}

