/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.connections.channels;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.listener.PlayerListener;
import sonar.core.utils.Pair;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkListChannels;
import sonar.logistics.api.networks.INetworkListHandler;
import sonar.logistics.api.networks.INetworkListener;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.EntityConnection;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.readers.IListReader;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.connections.CacheHandler;
import sonar.logistics.connections.channels.DefaultNetworkChannels;
import sonar.logistics.helpers.PacketHelper;

public abstract class ListNetworkChannels<M extends IInfo, H extends INetworkListHandler>
extends DefaultNetworkChannels<H>
implements INetworkListChannels<H> {
    public final H handler;
    public List<IListReader<M>> readers = Lists.newArrayList();
    protected Iterator<IListReader<M>> readerIterator;
    protected int readersPerTick = 0;
    public Map<NodeConnection, MonitoredList<M>> channels = Maps.newHashMap();
    protected Iterator<Map.Entry<NodeConnection, MonitoredList<M>>> channelIterator;
    protected int channelsPerTick = 0;
    protected boolean hasListeners = false;

    protected ListNetworkChannels(H handler, ILogisticsNetwork network) {
        super(network, CacheHandler.READER);
        this.handler = handler;
    }

    @Override
    public H getHandler() {
        return this.handler;
    }

    @Override
    public int getUpdateRate() {
        return this.handler.updateRate();
    }

    @Override
    public void updateChannel() {
        super.updateChannel();
        if (this.hasListeners) {
            this.updateChannels();
            this.updateReaders(true);
        }
    }

    @Override
    protected void updateTicks() {
        super.updateTicks();
        this.hasListeners = false;
        for (IListReader<M> reader : this.readers) {
            if (!reader.getListenerList().hasListeners()) continue;
            this.hasListeners = true;
            break;
        }
        if (this.hasListeners) {
            this.updateTickLists();
        }
    }

    public void updateTickLists() {
        this.readersPerTick = this.readers.size() > this.handler.updateRate() ? (int)Math.ceil(this.readers.size() / Math.max(1, this.handler.updateRate())) : 1;
        this.channelsPerTick = this.channels.size() > this.handler.updateRate() ? (int)Math.ceil(this.channels.size() / Math.max(1, this.handler.updateRate())) : 1;
        this.channelIterator = this.channels.entrySet().iterator();
        this.readerIterator = this.readers.iterator();
    }

    @Override
    public void addConnection(CacheHandler cache, INetworkListener connection) {
        IListReader reader = (IListReader)connection;
        if (reader.getValidHandlers().contains(this.handler) && !this.readers.contains(reader) && this.readers.add(reader)) {
            this.onChannelsChanged();
            this.updateTicks();
        }
    }

    @Override
    public void removeConnection(CacheHandler cache, INetworkListener connection) {
        if (this.readers.remove(connection)) {
            this.onChannelsChanged();
            this.updateTicks();
        }
    }

    @Override
    public void onChannelsChanged() {
        this.channels = this.handler.getAllChannels(Maps.newHashMap(), this.channels, this.network);
        this.updateTicks();
    }

    public void updateChannels() {
        for (int used = 0; this.channelIterator.hasNext() && used != this.channelsPerTick; ++used) {
            Map.Entry<NodeConnection, MonitoredList<M>> entry = this.channelIterator.next();
            MonitoredList<Object> oldList = entry.getValue() == null ? MonitoredList.newMonitoredList(this.network.getNetworkID()) : entry.getValue();
            MonitoredList newList = this.handler.updateConnection(this, MonitoredList.newMonitoredList(this.network.getNetworkID()), oldList, entry.getKey());
            this.channels.put(entry.getKey(), newList);
        }
    }

    public void updateReaders(boolean send) {
        for (int used = 0; this.readerIterator.hasNext() && used != this.readersPerTick; ++used) {
            IListReader<M> reader = this.readerIterator.next();
            if (!reader.getListenerList().hasListeners()) continue;
            this.handler.updateAndSendList(this.network, reader, this.channels, send);
        }
    }

    public void updateAllChannels() {
        for (Map.Entry<NodeConnection, MonitoredList<M>> entry : this.channels.entrySet()) {
            MonitoredList<Object> oldList = entry.getValue() == null ? MonitoredList.newMonitoredList(this.network.getNetworkID()) : entry.getValue();
            this.channels.put(entry.getKey(), this.handler.updateConnection(this, MonitoredList.newMonitoredList(this.network.getNetworkID()), oldList, entry.getKey()));
        }
    }

    public void updateAllReaders(boolean send) {
        this.readers.forEach(reader -> this.handler.updateAndSendList(this.network, reader, this.channels, send));
    }

    public void sendFullRapidUpdate() {
        this.updateAllChannels();
        this.updateAllReaders(true);
    }

    public void sendLocalRapidUpdate(IListReader<M> reader, EntityPlayer viewer) {
        PlayerListener listener = reader.getListenerList().findListener(viewer);
        if (listener != null) {
            this.updateAllChannels();
            Pair<InfoUUID, MonitoredList<M>> list = this.handler.updateAndSendList(this.network, reader, this.channels, false);
            PacketHelper.sendReaderFullInfo(Lists.newArrayList((Object[])new PlayerListener[]{listener}), reader, (MonitoredList)list.b, (InfoUUID)list.a);
        }
    }

    @Override
    public void onDeleted() {
        super.onDeleted();
        this.readers.clear();
        this.readerIterator = null;
        this.channels.clear();
        this.channelIterator = null;
    }

    @Override
    public void onCreated() {
    }

    @Override
    public boolean isCoordsMonitored(BlockConnection connection) {
        return true;
    }

    @Override
    public boolean isEntityMonitored(EntityConnection connection) {
        return true;
    }
}

