/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.connections.channels;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import sonar.core.helpers.InventoryHelper;
import sonar.logistics.api.filters.ITransferFilteredTile;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkHandler;
import sonar.logistics.api.networks.INetworkListener;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.tiles.nodes.TransferType;
import sonar.logistics.api.utils.CacheType;
import sonar.logistics.connections.CacheHandler;
import sonar.logistics.connections.channels.DefaultNetworkChannels;
import sonar.logistics.helpers.FluidHelper;
import sonar.logistics.helpers.ItemHelper;

public class TransferNetworkChannels<M extends IInfo, H extends INetworkHandler>
extends DefaultNetworkChannels<H> {
    private List<ITransferFilteredTile> nodes = Lists.newArrayList();
    private Iterator<ITransferFilteredTile> nodeIterator;
    private int nodesPerTick = 0;
    private InventoryHelper.DefaultTransferOverride override = new InventoryHelper.DefaultTransferOverride(128L);

    public TransferNetworkChannels(ILogisticsNetwork network) {
        super(network, CacheHandler.TRANSFER_NODES);
    }

    @Override
    public int getUpdateRate() {
        return 20;
    }

    @Override
    public void onCreated() {
    }

    @Override
    public void onDeleted() {
        super.onDeleted();
        this.nodes.clear();
        this.nodeIterator = null;
    }

    @Override
    protected void updateTicks() {
        super.updateTicks();
        this.nodesPerTick = this.nodes.size() > this.getUpdateRate() ? (int)Math.ceil(this.nodes.size() / Math.max(1, this.getUpdateRate())) : 1;
        this.nodeIterator = this.nodes.iterator();
        this.override.reset();
    }

    @Override
    public void updateChannel() {
        super.updateChannel();
        this.updateTransferNodes(this.network.getConnections(CacheType.ALL));
    }

    @Override
    public void addConnection(CacheHandler cache, INetworkListener connection) {
        if (!this.nodes.contains(connection) && this.nodes.add((ITransferFilteredTile)connection)) {
            this.onChannelsChanged();
            this.updateTicks();
        }
    }

    @Override
    public void removeConnection(CacheHandler cache, INetworkListener connection) {
        if (this.nodes.remove(connection)) {
            this.onChannelsChanged();
            this.updateTicks();
        }
    }

    private void updateTransferNodes(List<NodeConnection> allChannels) {
        int used = 0;
        while (this.nodeIterator.hasNext() && used != this.nodesPerTick) {
            this.override.reset();
            ITransferFilteredTile transfer = this.nodeIterator.next();
            BlockConnection connected = transfer.getConnected();
            NodeTransferMode mode = transfer.getTransferMode();
            if (connected == null || mode.isPassive()) continue;
            boolean items = transfer.isTransferEnabled(TransferType.ITEMS);
            boolean fluids = transfer.isTransferEnabled(TransferType.FLUID);
            if (items || fluids) {
                for (NodeConnection connect : allChannels) {
                    if (!this.override.canTransfer()) break;
                    if (connect == null || !(connect instanceof BlockConnection) || connect.source == connected.source || !transfer.getChannels().isMonitored(connect)) continue;
                    if (items) {
                        ItemHelper.transferItems(mode, connected, (BlockConnection)connect, (InventoryHelper.ITransferOverride)this.override);
                    }
                    if (!fluids) continue;
                    FluidHelper.transferFluids(mode, connected, (BlockConnection)connect);
                }
            }
            ++used;
        }
    }
}

