/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.connections.handlers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import sonar.core.utils.Pair;
import sonar.logistics.PL2;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.networks.IEntityMonitorHandler;
import sonar.logistics.api.networks.ILogisticsNetwork;
import sonar.logistics.api.networks.INetworkListChannels;
import sonar.logistics.api.networks.INetworkListHandler;
import sonar.logistics.api.networks.ITileMonitorHandler;
import sonar.logistics.api.tiles.nodes.BlockConnection;
import sonar.logistics.api.tiles.nodes.EntityConnection;
import sonar.logistics.api.tiles.nodes.NodeConnection;
import sonar.logistics.api.tiles.nodes.NodeConnectionType;
import sonar.logistics.api.tiles.readers.IListReader;
import sonar.logistics.api.tiles.readers.INetworkReader;
import sonar.logistics.api.utils.CacheType;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.helpers.PacketHelper;

public abstract class ListNetworkHandler<I extends IInfo>
implements INetworkListHandler<I> {
    Boolean tiles;
    Boolean entities;

    public int getReaderID(IListReader reader) {
        return 0;
    }

    public boolean canHandleTiles() {
        if (this.tiles == null) {
            this.tiles = this instanceof ITileMonitorHandler;
        }
        return this.tiles;
    }

    public boolean canHandleEntities() {
        if (this.entities == null) {
            this.entities = this instanceof IEntityMonitorHandler;
        }
        return this.entities;
    }

    public boolean canHandle(NodeConnection connection) {
        NodeConnectionType type = connection.getType();
        switch (type) {
            case ENTITY: {
                return this.canHandleEntities();
            }
            case TILE: {
                return this.canHandleTiles();
            }
        }
        return false;
    }

    @Override
    public Map<NodeConnection, MonitoredList<I>> getAllChannels(Map<NodeConnection, MonitoredList<I>> compiling, Map<NodeConnection, MonitoredList<I>> oldList, ILogisticsNetwork network) {
        for (NodeConnection connection : network.getConnections(CacheType.ALL)) {
            if (!network.validateTile(connection.source) || !this.canHandle(connection) || compiling.containsKey(connection)) continue;
            compiling.put(connection, oldList.getOrDefault(connection, MonitoredList.newMonitoredList(network.getNetworkID())));
        }
        return compiling;
    }

    @Override
    public MonitoredList<I> updateConnection(INetworkListChannels channels, MonitoredList<I> newList, MonitoredList<I> oldList, NodeConnection c) {
        EntityConnection connection;
        if (c instanceof BlockConnection) {
            BlockConnection connection2 = (BlockConnection)c;
            if (channels.isCoordsMonitored(connection2)) {
                return ((ITileMonitorHandler)((Object)this)).updateInfo(channels, newList, oldList, connection2);
            }
        } else if (c instanceof EntityConnection && channels.isEntityMonitored(connection = (EntityConnection)c)) {
            return ((IEntityMonitorHandler)((Object)this)).updateInfo(channels, newList, oldList, connection);
        }
        return oldList;
    }

    @Override
    public Pair<InfoUUID, MonitoredList<I>> updateAndSendList(ILogisticsNetwork network, IListReader<I> reader, Map<NodeConnection, MonitoredList<I>> channelLists, boolean send) {
        InfoUUID uuid = new InfoUUID(reader.getIdentity(), this.getReaderID(reader));
        if (network.validateTile(reader)) {
            ArrayList usedChannels = Lists.newArrayList();
            MonitoredList lastList = PL2.getServerManager().monitoredLists.getOrDefault(uuid, MonitoredList.newMonitoredList(network.getNetworkID()));
            MonitoredList<I> updateList = reader.getUpdatedList(uuid, channelLists, usedChannels).updateList(lastList);
            if (reader instanceof INetworkReader) {
                ((INetworkReader)reader).setMonitoredInfo(updateList, usedChannels, uuid);
            }
            PL2.getServerManager().monitoredLists.put(uuid, updateList);
            if (send) {
                PacketHelper.sendReaderToListeners(reader, updateList, lastList, uuid);
            }
            return new Pair((Object)uuid, updateList);
        }
        return new Pair((Object)uuid, MonitoredList.newMonitoredList(network.getNetworkID()));
    }
}

