/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.guide;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.opengl.GL11;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.client.gui.GuiGuide;
import sonar.logistics.guide.GuidePageHelper;
import sonar.logistics.guide.IGuidePage;
import sonar.logistics.guide.IGuidePageElement;
import sonar.logistics.guide.elements.ElementInfo;
import sonar.logistics.guide.elements.ElementInfoFormatted;
import sonar.logistics.guide.elements.ElementLink;

public abstract class BaseInfoPage
implements IGuidePage {
    public int pageID;
    public int pageCount = 1;
    public int currentSubPage = 0;
    public Map<String, ElementInfoFormatted> pageInfo = Maps.newHashMap();
    public List<ElementLink> currentLinks = Lists.newArrayList();
    public List<ElementInfoFormatted> currentData = Lists.newArrayList();
    public List<IGuidePageElement> elements = Lists.newArrayList();
    private GuiButton selectedButton;
    public List<GuiButton> guideButtons = Lists.newArrayList();
    public static final int topOffset = 18;

    public BaseInfoPage(int pageID) {
        this.pageID = pageID;
    }

    @Override
    public int pageID() {
        return this.pageID;
    }

    @Override
    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public List<IGuidePageElement> getElements(GuiGuide gui, List<IGuidePageElement> elements) {
        return elements;
    }

    @Override
    public void initGui(GuiGuide gui, int subPage) {
        this.currentSubPage = subPage;
        this.pageInfo.clear();
        this.guideButtons.clear();
        this.elements = this.getElements(gui, Lists.newArrayList());
        ArrayList newLinks = Lists.newArrayList();
        ArrayList newData = Lists.newArrayList();
        boolean newPage = false;
        int ordinal = 0;
        int lineTally = 0;
        List<ElementInfo> pgInfo = this.getPageInfo(gui, Lists.newArrayList());
        int currentInfoPos = 0;
        for (ElementInfo info : pgInfo) {
            int numPagesNeeded;
            int to = 0;
            int from = 0;
            if (!newPage && info.newPage && lineTally != 0) {
                ++ordinal;
                lineTally = 0;
                newPage = false;
            } else if (newPage) {
                newPage = false;
            }
            ArrayList links = Lists.newArrayList();
            List<String> lines = GuidePageHelper.getLines(this, ordinal, lineTally, info, links);
            for (int currentPages = numPagesNeeded = (lines.size() + lineTally) / GuidePageHelper.maxLinesPerPage + 1; currentPages > 0; --currentPages) {
                boolean firstPage = numPagesNeeded == currentPages;
                from = Math.min(GuidePageHelper.maxLinesPerPage * (numPagesNeeded - currentPages), to);
                to = Math.min(GuidePageHelper.maxLinesPerPage * (numPagesNeeded + 1 - currentPages) - lineTally, lines.size());
                ArrayList pageLinks = Lists.newArrayList();
                for (ElementLink link : links) {
                    if (link.lineNum < from || link.lineNum > to) break;
                    int linePos = lineTally + link.lineNum - 1;
                    link.setDisplayPosition(ordinal, this.getLineOffset(linePos, ordinal) + link.index, 27 + (linePos - (numPagesNeeded - currentPages) * GuidePageHelper.maxLinesPerPage) * 12);
                    pageLinks.add(link);
                }
                links.removeAll(pageLinks);
                List<String> wrapLines = lines.subList(from, to);
                if (wrapLines.isEmpty()) continue;
                ElementInfo infoSource = new ElementInfo(info.key, info.additionals);
                ElementInfoFormatted infoFormatted = new ElementInfoFormatted(ordinal, infoSource, wrapLines, pageLinks);
                infoFormatted.setDisplayPosition(8, lineTally == 0 ? 0 : lineTally * 12);
                if (ordinal == subPage) {
                    newData.add(infoFormatted);
                    newLinks.addAll(infoFormatted.links);
                }
                this.pageInfo.put(info.key, infoFormatted);
                lineTally += wrapLines.size();
                if (to == lines.size() && currentInfoPos + 1 >= pgInfo.size()) continue;
                if (lineTally + 1 >= GuidePageHelper.maxLinesPerPage) {
                    ++ordinal;
                    lineTally = 0;
                    newPage = true;
                    continue;
                }
                ++lineTally;
            }
            ++currentInfoPos;
        }
        this.pageCount = Math.max(1 + ordinal, !this.elements.isEmpty() ? this.elements.get(this.elements.size() - 1).getDisplayPage() + 1 : 0);
        this.currentLinks = newLinks;
        this.currentData = newData;
    }

    @Override
    public int getLineWidth(int linePos, int page) {
        int wrapWidth = 342;
        int pos = 18 + linePos * 12;
        for (IGuidePageElement e : this.elements) {
            int[] position;
            if (e.getDisplayPage() != page || (position = e.getSizing())[1] + position[3] <= pos) continue;
            wrapWidth -= position[2] + position[0];
            break;
        }
        return wrapWidth;
    }

    public int getLineOffset(int linePos, int page) {
        int pos = 18 + linePos * 12;
        int offset = 0;
        for (IGuidePageElement e : this.elements) {
            int[] position;
            if (e.getDisplayPage() != page || (position = e.getSizing())[1] + position[3] < pos || position[0] + position[2] <= offset) continue;
            offset = position[0] + position[2];
        }
        return offset;
    }

    @Override
    public void drawPageInGui(GuiGuide gui, int yPos) {
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        FontHelper.text((String)this.getDisplayName(), (int)28, (int)(yPos + 3), (int)-1);
    }

    @Override
    public void drawPage(GuiGuide gui, int x, int y, int page) {
        for (ElementLink pageLink : this.currentLinks) {
            if (pageLink == null || !pageLink.isMouseOver(gui, x - gui.getGuiLeft(), y - gui.getGuiTop())) continue;
            GlStateManager.func_179097_i();
            gui.drawSonarCreativeTabHoveringText(TextFormatting.BLUE + "Open: " + TextFormatting.RESET + (pageLink.getGuidePage() == null ? "ERROR" : pageLink.getGuidePage().getDisplayName()), x, y);
            GlStateManager.func_179140_f();
            break;
        }
        for (IGuidePageElement element : this.elements) {
            if (element.getDisplayPage() != page) continue;
            RenderHelper.saveBlendState();
            element.drawElement(gui, gui.getGuiLeft() + element.getSizing()[0], gui.getGuiTop() + element.getSizing()[1], page, x, y);
            RenderHelper.restoreBlendState();
        }
    }

    @Override
    public void drawBackgroundPage(GuiGuide gui, int x, int y, int page) {
        for (IGuidePageElement element : this.elements) {
            if (element.getDisplayPage() != page) continue;
            RenderHelper.saveBlendState();
            element.drawBackgroundElement(gui, gui.getGuiLeft() + element.getSizing()[0], gui.getGuiTop() + element.getSizing()[1], page, x, y);
            RenderHelper.restoreBlendState();
        }
    }

    @Override
    public void drawForegroundPage(GuiGuide gui, int x, int y, int page) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < this.guideButtons.size(); ++i) {
            GuiButton button = this.guideButtons.get(i);
            button.func_146111_b(x, y);
        }
        int listTally = 0;
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        for (ElementInfoFormatted guidePage : this.currentData) {
            List<String> info = guidePage.formattedList;
            for (int i = 0; i < Math.min(GuidePageHelper.maxLinesPerPage, info.size()); ++i) {
                String s = info.get(i);
                FontHelper.text((String)s, (int)(guidePage.displayX + this.getLineOffset(i + listTally, this.currentSubPage)), (int)(18 + (i + listTally) * 12), (int)-1);
            }
            listTally += (listTally == 0 ? 1 : 1) + guidePage.formattedList.size();
        }
        for (IGuidePageElement element : this.elements) {
            if (element.getDisplayPage() != this.currentSubPage) continue;
            RenderHelper.saveBlendState();
            element.drawForegroundElement(gui, element.getSizing()[0], element.getSizing()[1], page, x, y);
            RenderHelper.restoreBlendState();
        }
        for (int i = 0; i < this.guideButtons.size(); ++i) {
            GuiButton button = this.guideButtons.get(i);
            int left = x + gui.getGuiLeft();
            int top = y + gui.getGuiTop();
            button.func_146112_a(gui.field_146297_k, left, top);
        }
    }

    @Override
    public void mouseClicked(GuiGuide gui, int x, int y, int button) {
        if (button == 0) {
            for (int i = 0; i < this.guideButtons.size(); ++i) {
                GuiButton guibutton = this.guideButtons.get(i);
                if (!guibutton.func_146116_c(gui.field_146297_k, x - gui.getGuiLeft(), y - gui.getGuiTop())) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)gui, guibutton, this.guideButtons);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.selectedButton = guibutton = event.getButton();
                guibutton.func_146113_a(gui.field_146297_k.func_147118_V());
                this.actionPerformed(guibutton);
                if (!this.equals(gui.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)gui, event.getButton(), this.guideButtons));
            }
        }
        for (ElementLink pageLink : this.currentLinks) {
            if (!pageLink.isMouseOver(gui, x - gui.getGuiLeft(), y - gui.getGuiTop())) continue;
            gui.setCurrentPage(pageLink.guidePageLink, 0);
        }
        for (IGuidePageElement element : this.elements) {
            if (element.getDisplayPage() != this.currentSubPage || !element.mouseClicked(gui, this, x, y, button)) continue;
            return;
        }
    }

    public void actionPerformed(GuiButton button) {
    }
}

