/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.guide;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.GuiSonar;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.client.gui.GuiGuide;
import sonar.logistics.guide.GeneralPage;
import sonar.logistics.guide.IGuidePage;
import sonar.logistics.guide.IGuidePageElement;
import sonar.logistics.guide.elements.ElementCraftingRecipe;
import sonar.logistics.guide.elements.ElementHammerRecipe;
import sonar.logistics.guide.elements.ElementItem;
import sonar.logistics.guide.elements.ElementLink;

public class BaseItemPage
extends GeneralPage
implements IGuidePage {
    public String unlocalizedName;
    public ItemStack stack;
    public List<ElementLink> links = Lists.newArrayList();
    public double rotate = 0.0;

    public BaseItemPage(int pageID, ItemStack stack) {
        this(pageID, stack, "guide." + stack.func_77977_a().substring(5) + ".name");
    }

    public BaseItemPage(int pageID, ItemStack stack, String ... descKey) {
        super(pageID, "", descKey);
        this.stack = stack;
        this.unlocalizedName = stack.func_77977_a();
    }

    @Override
    public String getDisplayName() {
        return this.stack.func_82833_r();
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public List<IGuidePageElement> getElements(GuiGuide gui, List<IGuidePageElement> elements) {
        super.getElements(gui, elements);
        elements.add(new ElementItem(0, this.stack, 4, 15));
        ElementCraftingRecipe recipe = new ElementCraftingRecipe(0, (EntityPlayer)gui.field_146297_k.field_71439_g, this.stack, 4, 104);
        if (recipe.recipe != null) {
            elements.add(recipe);
        } else {
            ElementHammerRecipe hammerR = new ElementHammerRecipe(0, (EntityPlayer)gui.field_146297_k.field_71439_g, this.stack, 4, 74);
            if (hammerR.recipe != null) {
                elements.add(hammerR);
            }
        }
        return elements;
    }

    @Override
    public void drawPageInGui(GuiGuide gui, int yPos) {
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.saveBlendState();
        GL11.glEnable((int)2929);
        RenderHelper.renderItem((GuiSonar)gui, (int)8, (int)(yPos - 1), (ItemStack)this.stack);
        RenderHelper.renderStoredItemStackOverlay((ItemStack)this.stack, (long)(this.stack.field_77994_a == 1 ? 0L : (long)this.stack.field_77994_a), (int)8, (int)(yPos - 1), null, (boolean)true);
        RenderHelper.restoreBlendState();
        FontHelper.text((String)this.stack.func_82833_r(), (int)28, (int)(yPos + 3), (int)-1);
    }
}

