/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.guide;

import com.google.common.collect.Lists;
import mcmultipart.multipart.Multipart;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.client.gui.MultipartStateOverride;
import sonar.logistics.PL2Items;
import sonar.logistics.api.PL2Properties;
import sonar.logistics.api.info.InfoUUID;
import sonar.logistics.api.register.RegistryType;
import sonar.logistics.api.tiles.cable.CableRenderType;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.DisplayConnections;
import sonar.logistics.api.utils.MonitoredList;
import sonar.logistics.common.multiparts.displays.DataCablePart;
import sonar.logistics.common.multiparts.displays.DisplayScreenPart;
import sonar.logistics.common.multiparts.displays.LargeDisplayScreenPart;
import sonar.logistics.common.multiparts.misc.RedstoneSignallerPart;
import sonar.logistics.common.multiparts.nodes.NodePart;
import sonar.logistics.common.multiparts.readers.InfoReaderPart;
import sonar.logistics.common.multiparts.readers.InventoryReaderPart;
import sonar.logistics.common.multiparts.wireless.DataEmitterPart;
import sonar.logistics.common.multiparts.wireless.DataReceiverPart;
import sonar.logistics.guide.Logistics3DRenderer;
import sonar.logistics.info.types.LogicInfo;
import sonar.logistics.info.types.LogicInfoList;
import sonar.logistics.info.types.MonitoredItemStack;
import sonar.logistics.info.types.ProgressInfo;

public class ExampleConfigurations {

    public static class MultipleInventory
    extends Logistics3DRenderer {
        public MultipleInventory() {
            super(16);
            NodePart node = new NodePart();
            node.setCableFace(EnumFacing.DOWN);
            InventoryReaderPart reader = new InventoryReaderPart();
            reader.setCableFace(EnumFacing.NORTH);
            ConnectedDisplay fullDisplay = new ConnectedDisplay(-1);
            fullDisplay.width.setObject((Object)2);
            fullDisplay.height.setObject((Object)0);
            LargeDisplayScreenPart screen1 = new LargeDisplayScreenPart(EnumFacing.NORTH, EnumFacing.NORTH);
            screen1.overrideDisplay = fullDisplay;
            screen1.shouldRender.setObject((Object)true);
            fullDisplay.topLeftScreen = screen1;
            fullDisplay.container.resetRenderProperties();
            final MonitoredList list = MonitoredList.newMonitoredList(-1);
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(PL2Items.sapphire), 512L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(PL2Items.stone_plate), 256L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150347_e), 256L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack((Block)Blocks.field_150354_m), 256L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150364_r, 1, 0), 128L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150364_r, 1, 1), 128L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150364_r, 1, 2), 128L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150364_r, 1, 3), 128L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150344_f, 1, 0), 64L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150344_f, 1, 1), 64L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150344_f, 1, 2), 64L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150344_f, 1, 3), 64L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150346_d), 64L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150426_aN), 64L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150366_p), 64L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(PL2Items.cable), 16L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(PL2Items.info_reader), 4L)));
            list.add(new MonitoredItemStack(new StoredItemStack(new ItemStack(PL2Items.operator), 1L)));
            fullDisplay.container.storedInfo.get((int)0).cachedInfo = new LogicInfoList(){
                {
                    this.infoID.setObject((Object)"item");
                    this.listChanged = false;
                }

                @Override
                public MonitoredList<?> getCachedList(InfoUUID id) {
                    return list;
                }
            };
            LargeDisplayScreenPart screen2 = new LargeDisplayScreenPart(EnumFacing.NORTH, EnumFacing.NORTH);
            LargeDisplayScreenPart screen3 = new LargeDisplayScreenPart(EnumFacing.NORTH, EnumFacing.NORTH);
            MultipartStateOverride screenState1 = new MultipartStateOverride((Multipart)screen1){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a(LargeDisplayScreenPart.TYPE, (Comparable)((Object)DisplayConnections.ONE_E));
                }
            };
            MultipartStateOverride screenState2 = new MultipartStateOverride((Multipart)screen2){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a(LargeDisplayScreenPart.TYPE, (Comparable)((Object)DisplayConnections.OPPOSITE_2));
                }
            };
            MultipartStateOverride screenState3 = new MultipartStateOverride((Multipart)screen3){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a(LargeDisplayScreenPart.TYPE, (Comparable)((Object)DisplayConnections.ONE_W));
                }
            };
            MultipartStateOverride cable1 = new MultipartStateOverride((Multipart)new DataCablePart()){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)PL2Properties.DOWN, (Comparable)((Object)CableRenderType.INTERNAL)).func_177226_a((IProperty)PL2Properties.WEST, (Comparable)((Object)CableRenderType.CABLE)).func_177226_a((IProperty)PL2Properties.NORTH, (Comparable)((Object)CableRenderType.INTERNAL));
                }
            };
            MultipartStateOverride cable2 = new MultipartStateOverride((Multipart)new DataCablePart()){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)PL2Properties.DOWN, (Comparable)((Object)CableRenderType.INTERNAL)).func_177226_a((IProperty)PL2Properties.EAST, (Comparable)((Object)CableRenderType.CABLE)).func_177226_a((IProperty)PL2Properties.WEST, (Comparable)((Object)CableRenderType.CABLE));
                }
            };
            MultipartStateOverride cable3 = new MultipartStateOverride((Multipart)new DataCablePart()){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)PL2Properties.DOWN, (Comparable)((Object)CableRenderType.INTERNAL)).func_177226_a((IProperty)PL2Properties.EAST, (Comparable)((Object)CableRenderType.CABLE)).func_177226_a((IProperty)PL2Properties.NORTH, (Comparable)((Object)CableRenderType.INTERNAL));
                }
            };
            this.addMultiparts(Lists.newArrayList((Object[])new Object[]{node, screenState1, cable1}), new BlockPos(1, 0, 0));
            this.addMultiparts(Lists.newArrayList((Object[])new Object[]{node, screenState3, cable3}), new BlockPos(-1, 0, 0));
            this.addMultiparts(Lists.newArrayList((Object[])new Object[]{node, reader, screenState2, cable2}), new BlockPos(0, 0, 0));
            IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH);
            this.addBlock(chestState, new BlockPos(0, -1, 0));
            this.addBlock(chestState, new BlockPos(1, -1, 0));
            this.addBlock(chestState, new BlockPos(-1, -1, 0));
            this.addTileEntity((TileEntity)new TileEntityChest(), new BlockPos(0, -1, 0));
            this.addTileEntity((TileEntity)new TileEntityChest(), new BlockPos(1, -1, 0));
            this.addTileEntity((TileEntity)new TileEntityChest(), new BlockPos(-1, -1, 0));
        }
    }

    public static class WirelessRedstone
    extends Logistics3DRenderer {
        public WirelessRedstone() {
            super(16);
            this.addBlock(Blocks.field_150488_af.func_176223_P().func_177226_a((IProperty)BlockRedstoneWire.field_176351_O, (Comparable)Integer.valueOf(15)), new BlockPos(1, 0, 0));
            this.addBlock(Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.UP_Z).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(true)), new BlockPos(1, 0, -1));
            NodePart node = new NodePart();
            node.setCableFace(EnumFacing.NORTH);
            MultipartStateOverride cable = new MultipartStateOverride((Multipart)new DataCablePart()){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)PL2Properties.EAST, (Comparable)((Object)CableRenderType.INTERNAL)).func_177226_a((IProperty)PL2Properties.NORTH, (Comparable)((Object)CableRenderType.INTERNAL));
                }
            };
            DataEmitterPart emitter = new DataEmitterPart();
            emitter.setCableFace(EnumFacing.EAST);
            this.addMultiparts(Lists.newArrayList((Object[])new Object[]{node, cable, emitter}), new BlockPos(1, 0, 1));
            InfoReaderPart reader = new InfoReaderPart();
            reader.setCableFace(EnumFacing.NORTH);
            DataReceiverPart receiver = new DataReceiverPart();
            receiver.setCableFace(EnumFacing.NORTH);
            receiver.face.setObject((Enum)EnumFacing.WEST);
            MultipartStateOverride cable2 = new MultipartStateOverride((Multipart)new DataCablePart()){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)PL2Properties.WEST, (Comparable)((Object)CableRenderType.INTERNAL));
                }
            };
            this.addMultiparts(Lists.newArrayList((Object[])new Object[]{reader, cable2, receiver}), new BlockPos(-1, 0, 1));
            RedstoneSignallerPart signallerPart = new RedstoneSignallerPart();
            signallerPart.setCableFace(EnumFacing.NORTH);
            MultipartStateOverride signaller = new MultipartStateOverride((Multipart)signallerPart){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)RedstoneSignallerPart.ACTIVE, (Comparable)Boolean.valueOf(true));
                }
            };
            MultipartStateOverride cable3 = new MultipartStateOverride((Multipart)new DataCablePart()){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)PL2Properties.NORTH, (Comparable)((Object)CableRenderType.HALF)).func_177226_a((IProperty)PL2Properties.SOUTH, (Comparable)((Object)CableRenderType.INTERNAL));
                }
            };
            this.addMultiparts(Lists.newArrayList((Object[])new Object[]{signaller, cable3}), new BlockPos(-1, 0, 0));
        }
    }

    public static class InventoryExample
    extends Logistics3DRenderer {
        public static final InventoryExample instance = new InventoryExample();

        public InventoryExample() {
            super(4);
            NodePart node = new NodePart();
            node.setCableFace(EnumFacing.DOWN);
            InventoryReaderPart reader = new InventoryReaderPart();
            reader.setCableFace(EnumFacing.NORTH);
            DisplayScreenPart screen = new DisplayScreenPart(EnumFacing.NORTH, EnumFacing.NORTH);
            screen.container.storedInfo.get((int)0).cachedInfo = new MonitoredItemStack(new StoredItemStack(new ItemStack(Blocks.field_150347_e), 256L), -1);
            MultipartStateOverride cable = new MultipartStateOverride((Multipart)new DataCablePart()){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)PL2Properties.DOWN, (Comparable)((Object)CableRenderType.INTERNAL));
                }
            };
            this.addMultiparts(Lists.newArrayList((Object[])new Object[]{node, reader, screen, cable}), new BlockPos(0, 0, 0));
            this.addBlock(Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH), new BlockPos(0, -1, 0));
            this.addTileEntity((TileEntity)new TileEntityChest(), new BlockPos(0, -1, 0));
        }
    }

    public static class FurnaceProgress
    extends Logistics3DRenderer {
        public static final FurnaceProgress instance2 = new FurnaceProgress();

        public FurnaceProgress() {
            super(4);
            NodePart node = new NodePart();
            node.setCableFace(EnumFacing.DOWN);
            InfoReaderPart reader = new InfoReaderPart();
            reader.setCableFace(EnumFacing.NORTH);
            DisplayScreenPart screen = new DisplayScreenPart(EnumFacing.NORTH, EnumFacing.NORTH);
            LogicInfo info1 = LogicInfo.buildDirectInfo("TileEntityFurnace.cookTime", RegistryType.TILE, 100);
            LogicInfo info2 = LogicInfo.buildDirectInfo("TileEntityFurnace.totalCookTime", RegistryType.TILE, 200);
            screen.container.storedInfo.get((int)0).cachedInfo = new ProgressInfo(info1, info2);
            MultipartStateOverride cable = new MultipartStateOverride((Multipart)new DataCablePart()){

                public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
                    return super.getActualState(state, world, pos).func_177226_a((IProperty)PL2Properties.DOWN, (Comparable)((Object)CableRenderType.INTERNAL));
                }
            };
            this.addMultiparts(Lists.newArrayList((Object[])new Object[]{node, reader, screen, cable}), new BlockPos(0, 0, 0));
            this.addBlock(Blocks.field_150470_am.func_176223_P(), new BlockPos(0, -1, 0));
        }
    }
}

