/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.guide;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import sonar.logistics.PL2Blocks;
import sonar.logistics.PL2Items;
import sonar.logistics.guide.BaseItemPage;
import sonar.logistics.guide.GeneralPage;
import sonar.logistics.guide.IGuidePage;
import sonar.logistics.guide.general.ExamplesPages;
import sonar.logistics.guide.pages.EnergyReaderPage;
import sonar.logistics.guide.pages.FluidReaderPage;
import sonar.logistics.guide.pages.InfoReaderPage;
import sonar.logistics.guide.pages.InventoryReaderPage;
import sonar.logistics.guide.pages.TransferNodePage;

public class GuidePageRegistry {
    public static List<IGuidePage> pages = new ArrayList<IGuidePage>();

    public static void init() {
        GuidePageRegistry.addGuidePage(new GeneralPage(0, "guide.Welcome.title", "guide.Welcome.name"));
        GuidePageRegistry.addGuidePage(new GeneralPage(1, "guide.GettingStarted.title", "guide.GettingStarted.name", "guide.GettingStarted2.name"));
        GuidePageRegistry.addGuidePage(new ExamplesPages(2));
        GuidePageRegistry.addGuidePage(new BaseItemPage(6, new ItemStack(PL2Items.operator)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(7, new ItemStack(PL2Blocks.hammer)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(8, new ItemStack(PL2Blocks.sapphire_ore)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(9, new ItemStack(PL2Items.sapphire)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(10, new ItemStack(PL2Items.sapphire_dust)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(11, new ItemStack(PL2Items.stone_plate)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(12, new ItemStack(PL2Items.etched_plate)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(13, new ItemStack(PL2Items.cable)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(14, new ItemStack(PL2Items.node)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(15, new ItemStack(PL2Items.entity_node)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(16, new ItemStack(PL2Items.array)));
        GuidePageRegistry.addGuidePage(new TransferNodePage(17));
        GuidePageRegistry.addGuidePage(new BaseItemPage(18, new ItemStack(PL2Items.transceiver)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(19, new ItemStack(PL2Items.entity_transceiver)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(20, new ItemStack(PL2Items.wireless_storage_reader)));
        GuidePageRegistry.addGuidePage(new InfoReaderPage(21));
        GuidePageRegistry.addGuidePage(new InventoryReaderPage(22));
        GuidePageRegistry.addGuidePage(new FluidReaderPage(23));
        GuidePageRegistry.addGuidePage(new EnergyReaderPage(24));
        GuidePageRegistry.addGuidePage(new BaseItemPage(25, new ItemStack(PL2Items.display_screen)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(26, new ItemStack(PL2Items.large_display_screen)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(27, new ItemStack(PL2Items.holographic_display)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(28, new ItemStack(PL2Items.data_emitter)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(29, new ItemStack(PL2Items.data_receiver)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(30, new ItemStack(PL2Items.redstone_signaller)));
        GuidePageRegistry.addGuidePage(new BaseItemPage(31, new ItemStack(PL2Items.clock)));
    }

    public static void addGuidePage(IGuidePage page) {
        pages.add(page);
    }

    public static IGuidePage getGuidePage(ItemStack stack) {
        for (IGuidePage page : pages) {
            if (!(page instanceof BaseItemPage) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((BaseItemPage)page).getItemStack())) continue;
            return page;
        }
        return null;
    }

    public static IGuidePage getGuidePage(int pageID) {
        for (IGuidePage page : pages) {
            if (page.pageID() != pageID) continue;
            return page;
        }
        return null;
    }

    public static IGuidePage getGuidePage(String unlocalizedName) {
        for (IGuidePage page : pages) {
            if (!(page instanceof BaseItemPage) || !unlocalizedName.equals(((BaseItemPage)page).unlocalizedName.substring(5))) continue;
            return page;
        }
        return null;
    }
}

