/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.guide;

import java.util.List;
import java.util.Map;
import javax.vecmath.Vector3d;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import sonar.core.client.gui.GuiBlockRenderer3D;
import sonar.core.client.gui.MultipartStateOverride;
import sonar.logistics.api.info.IInfo;
import sonar.logistics.api.info.render.DisplayInfo;
import sonar.logistics.api.info.render.InfoContainer;
import sonar.logistics.api.tiles.displays.ConnectedDisplay;
import sonar.logistics.api.tiles.displays.DisplayLayout;
import sonar.logistics.api.tiles.displays.DisplayType;
import sonar.logistics.api.tiles.displays.ILargeDisplay;
import sonar.logistics.common.multiparts.AbstractDisplayPart;
import sonar.logistics.helpers.InfoRenderer;
import sonar.logistics.info.types.InfoError;

public class Logistics3DRenderer
extends GuiBlockRenderer3D {
    public Logistics3DRenderer(int cubeSize) {
        super(cubeSize);
    }

    public void doMultipartRenderPass(Vector3d trans) {
        BlockPos pos;
        VertexBuffer wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Tessellator.func_178181_a().func_178180_c().func_178969_c(trans.x, trans.y, trans.z);
        for (Map.Entry entry : this.multiparts.entrySet()) {
            pos = (BlockPos)entry.getKey();
            for (MultipartStateOverride part : (List)entry.getValue()) {
                IBlockState state = part.getActualState(MultipartRegistry.getDefaultState((IMultipart)part.part).func_177621_b(), (IBlockAccess)this, pos);
                this.renderMultipart(state, pos, (IBlockAccess)this, Tessellator.func_178181_a().func_178180_c());
            }
        }
        Tessellator.func_178181_a().func_78381_a();
        Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
        for (Map.Entry entry : this.multiparts.entrySet()) {
            pos = (BlockPos)entry.getKey();
            for (MultipartStateOverride part : (List)entry.getValue()) {
                if (!(part.part instanceof AbstractDisplayPart)) continue;
                try {
                    this.renderScreenAt((AbstractDisplayPart)part.part, pos, 0.0f);
                }
                catch (Throwable throwable) {}
            }
        }
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    public void renderScreenAt(AbstractDisplayPart part, BlockPos pos, float partialTicks) {
        if (part instanceof ILargeDisplay && !((ILargeDisplay)((Object)part)).shouldRender()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - 0.5), (double)pos.func_177956_o(), (double)((double)pos.func_177952_p() - 0.5));
        if (part instanceof ILargeDisplay) {
            ConnectedDisplay screen = ((ILargeDisplay)((Object)part)).getDisplayScreen();
            InfoRenderer.rotateDisplayRendering(part.face, EnumFacing.NORTH, (Integer)screen.width.getObject(), (Integer)screen.height.getObject());
        } else {
            InfoRenderer.rotateDisplayRendering(part.face, EnumFacing.NORTH, 0, 0);
        }
        GL11.glTranslated((double)-0.0625, (double)0.0, (double)0.0);
        if (part.getDisplayType() == DisplayType.LARGE) {
            GL11.glTranslated((double)0.0, (double)-0.25, (double)0.0);
        }
        DisplayLayout layout = part.getLayout();
        DisplayType type = part.getDisplayType();
        for (int dataPos = 0; dataPos < layout.maxInfo; ++dataPos) {
            DisplayInfo info = part.container().getDisplayInfo(dataPos);
            GL11.glPushMatrix();
            GlStateManager.func_179123_a();
            double[] translation = info.getRenderProperties().translation;
            double[] scaling = info.getRenderProperties().scaling;
            GL11.glTranslated((double)translation[0], (double)translation[1], (double)translation[2]);
            if (info.cachedInfo != null && !info.getUnformattedStrings().isEmpty()) {
                InfoRenderer.renderNormalInfo(type, scaling[0], scaling[1], scaling[2], info.getFormattedStrings());
            } else {
                IInfo<InfoError> toDisplay = info.cachedInfo == null ? InfoError.noData : info.cachedInfo;
                toDisplay.renderInfo((InfoContainer)part.container(), info, scaling[0], scaling[1], scaling[2], dataPos);
            }
            GlStateManager.func_179099_b();
            GL11.glPopMatrix();
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }
}

